//
//  IBTBaseEntity.h
//
//
//  Created by Xummer on 15/4/7.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "IBTObject.h"

@class FMResultSet;
@protocol IBTDatabaseObject <NSObject>

@property (strong, nonatomic) NSMutableArray *arrSubModels;

+ (id)DBObject;

+ (id)objectFromFetchResult:(FMResultSet *)result;
- (void)updateFromFetchResult:(FMResultSet *)result;

// Fuctions
- (NSDictionary *)dictForCommit;
- (NSDictionary *)dictForLocalSave;
- (void)praseFromJsonDict:(NSDictionary *)dict;
- (void)praseFromLocalDict:(NSDictionary *)dict;
- (void)praseFromJsonDict:(NSDictionary *)dict isNilLeague:(BOOL)bIsNilLeague;

// SQLite
+ (NSString *)TableName;
+ (NSString *)PrimaryKey;
+ (NSArray *)PrimaryKeys;

- (NSString *)SQLForInsertOrUpdate:(NSArray * __autoreleasing *)pValues;
+ (NSString *)SQLForCreateTable;

+ (NSString *)SQLForUpdateKeyValueDict:(NSDictionary *)kvDict
                          WhereInfoStr:(NSString *)nsWhereInfoStr;
+ (NSString *)SQLForUpdateKeyValueDict:(NSDictionary *)kvDict
                             WhereInfo:(NSDictionary *)dictWhere;

- (void)saveToDBWithHandleData:(void (^)(id <IBTDatabaseObject>))handleDataBlock
                      complete:(void (^)(void))complete
                          fail:(void (^)(NSError *))fail;

@end

@interface IBTModel : IBTObject <IBTDatabaseObject>

// 需要替换的 keys map, @"|property key|" : @"|json key|",  如: @{ @"customID" : @"id" }
+ (NSDictionary *)specialKeysAndReplaceKeys;

// 不需要解析的键值对 的 Key
+ (NSArray *)customAcitonKeys;

// 不需要从json中解析，但是要写入本地数据库的 Key
+ (NSArray *)localKeys;

/*
    formate (?,?,?)
 */
+ (NSString *)ValuePlaceholdersWithCount:(NSUInteger)uiCount;
@end
