//
//  TopSheetView.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/12.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "TopSheetView.h"
#import "SurveyCell.h"
#define LeftMargin 15
#define TopMargin 20
#define LeftWidth 80
#define TableHeight 44
#define SpaceHeight 10

@interface TopSheetView ()<UITableViewDataSource,UITableViewDelegate,HPGrowingTextViewDelegate,UITextFieldDelegate>
{
    UITableView *_tableView;
    NSMutableArray *_dataArr;
}
@end


@implementation TopSheetView
- (instancetype)initWithFrame:(CGRect)frame{
    self = [super initWithFrame:frame];
    if (self) {
        //界面
        [self bulidLayout];
    }
    return self;
}

#pragma mark - 布局
- (void)bulidLayout
{
    self.backgroundColor  = XXFBgColor;
    _dataArr = [NSMutableArray array];
    NSArray *arr = @[@"标题:",@"供应商:",@"联系人:",@"联系电话:",@"加工工厂:",@"备注:"];
    [_dataArr addObjectsFromArray:arr];
    
    _tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, TopMargin,self.frame.size.width, self.frame.size.height - TopMargin)) style:(UITableViewStylePlain)];
    _tableView.backgroundColor = [UIColor whiteColor];
    _tableView.bounces = NO;
    _tableView.delegate = self;
    _tableView.dataSource = self;
    [self addSubview:_tableView];
}
#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"cellID";
    SurveyCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[SurveyCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        if (indexPath.row ==1 || indexPath.row == 4) {
            cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
        }
        [self createViewInCell:cell indexPath:indexPath];
    }
    [cell setTitleStr:_dataArr[indexPath.row]];
    return cell;
}
-  (void)createViewInCell:(SurveyCell *)cell indexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == 0 || indexPath.row == 2 || indexPath.row == 3) {
        UITextField *textField = [[UITextField alloc] initWithFrame:CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-10, TableHeight)];
        textField.textAlignment = NSTextAlignmentRight;
        textField.textColor = GXF_CONTENT_COLOR;
        textField.font = GXF_FIFTEENTEN_SIZE;
        textField.returnKeyType = UIReturnKeyDone;
        textField.delegate = self;
        [cell.contentView addSubview:textField];
        if (indexPath.row == 0) {
            self.titleTextFiled = textField;
            self.titleTextFiled.placeholder = @"请输入标题";
        }else if(indexPath.row == 2){
            self.peopleTextFiled = textField;
            self.peopleTextFiled.placeholder = @"请输入联系人";
        }else if(indexPath.row == 3){
            self.phoneTextFiled = textField;
            self.phoneTextFiled.placeholder = @"请输入联系人手机";
        }
        
    }else if (indexPath.row == _dataArr.count -1){
        self.remarkTextView = [[HPGrowingTextView alloc] initWithFrame:CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-10, TableHeight)];
        self.remarkTextView.contentInset = UIEdgeInsetsMake(5, 5, 5, 0);
        self.remarkTextView.minNumberOfLines = 1;
        self.remarkTextView.maxNumberOfLines = 2;
        self.remarkTextView.font = GXF_FIFTEENTEN_SIZE;
        self.remarkTextView.textAlignment = NSTextAlignmentRight;
        self.remarkTextView.delegate = self;
        self.remarkTextView.returnKeyType = UIReturnKeyDone;
        self.remarkTextView.placeholder = @"输入备注内容";
        [cell.contentView addSubview:self.remarkTextView];
    }else{
        UILabel *contentLabel = [[UILabel alloc]initWithFrame:(CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-10, TableHeight))];
        contentLabel.textAlignment= NSTextAlignmentRight;
        contentLabel.textColor = GXF_PLACEHOLDER_COLOR;
        contentLabel.font = GXF_FIFTEENTEN_SIZE;
        [cell.contentView addSubview:contentLabel];
        if (indexPath.row == 1) {
            contentLabel.text = @"选择供应商";
            self.supplierLabel = contentLabel;
            
        }else if(indexPath.row == 4){
            contentLabel.text = @"选择加工工厂";
            self.factoryLabel = contentLabel;
            
        }
    }
}

- (BOOL)growingTextViewShouldReturn:(HPGrowingTextView *)growingTextView{
    [self.remarkTextView resignFirstResponder];
    return YES;
}
- (BOOL)textFieldShouldReturn:(UITextField *)textField{
    [self.delegate hiddenKeyBoard];
    return YES;
}

@end
