//
//  ChooseSupplierViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/23.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ChooseVendorViewController.h"
#import "Vendor.h"
#define TopMargin 50
#define TableHeight 50
@interface ChooseVendorViewController ()
{
    NSIndexPath *_currentIndexPath;
}

@end

@implementation ChooseVendorViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    //记录更新时间
    self.tableView.header.lastUpdatedTimeKey = ChooseVendorUpdateDate;
    self.title = @"选择供应商";
    [self fetchVendorList:@""];
    
}


- (void)getBaseDataFromServer{
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        if (data) {
            __strong __typeof(weakSelf)strongSelf = weakSelf;
            [strongSelf endRefreshing];
            [strongSelf fetchVendorList:@""];
        }else{
            [IBTLoadingView showTips:data];
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    [[ICRHTTPController sharedController] getVendorWithPage_number:0 page_size:100 success:succ failure:fail];
}

#pragma mark -成功
- (void)fetchVendorList:(NSString *)titleStr{
    ICRDatabaseFetchBlock fetchBlk = ^FMResultSet *(FMDatabase *db) {
        NSString * sql = @"";
        if (titleStr.length > 0) {
            sql = [NSString stringWithFormat:@"SELECT * FROM %@ WHERE NAME LIKE '%%%@%%' ORDER BY %@", [Vendor TableName],titleStr, @"uuid"];
        }else{
            sql = [NSString stringWithFormat:@"SELECT * FROM %@ ORDER BY %@", [Vendor TableName], @"uuid"];
        }
        return [db executeQuery:sql];
    };
    
    __weak typeof(self)weakSelf = self;
    ICRDatabaseFetchResultsBlock fetchResultsBlk = ^(NSArray *fetchedObjects) {
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        
        if (![GXF_NSUSERFEFTAULTS objectForKey:ChooseVendorUpdateDate]) {
            [GXF_NSUSERFEFTAULTS setObject:[NSDate date] forKey:ChooseVendorUpdateDate];
            [GXF_NSUSERFEFTAULTS synchronize];
            [self getBaseDataFromServer];
        }else{
            [strongSelf.dataArr removeAllObjects];
            [strongSelf.dataArr addObject:self.tableView.header.lastUpdatedTime];
            [strongSelf.dataArr addObjectsFromArray:fetchedObjects];
            [self tableViewRefresh];
        }
    };
    ICRDataBaseController *dbCtrl = [ICRDataBaseController sharedController];
    [dbCtrl runFetchForClass:[Vendor class]
                  fetchBlock:fetchBlk
           fetchResultsBlock:fetchResultsBlk];
}

- (void)sureClick{
    if (self.isMoreChose) {
        NSMutableArray *arr = [[NSMutableArray alloc]init];
        for (NSIndexPath *index in self.indexArr) {
            Vendor *vendor = self.dataArr[index.row];
            [arr addObject:vendor];
        }
        self.choseVendor(arr);
        
    }else{
        NSMutableArray *arr = [[NSMutableArray alloc]init];
        if (self.dataArr.count > 0) {
            Vendor *vendor = self.dataArr[_currentIndexPath.row];
            [arr addObject:vendor];
            self.choseVendor(arr);
        }
    }
    [self PopViewControllerAnimated:YES];
}


- (void)deleteTextFieldStr {
    [super deleteTextFieldStr];
    [self boxValueChanged:nil];
}

#pragma mark - 协议方法
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"MaskCell";
    MaskCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[MaskCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID totalWidth:ScreenSize.width totalHeight:TableHeight];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.Commitbtn.hidden = YES;
    }
    if (self.isMoreChose) {
        if ([self isHaveIndexPath:indexPath]) {
            cell.Commitbtn.hidden = NO;
        }else{
            cell.Commitbtn.hidden = YES;
        }
    }else{
        if (_currentIndexPath) {
            if (indexPath.row == _currentIndexPath.row) {
                cell.Commitbtn.hidden = NO;
            }else{
                cell.Commitbtn.hidden = YES;
            }
        }else{
            cell.Commitbtn.hidden = YES;
        }
    }
    if (self.dataArr.count > 0) {
        if (indexPath.row == 0) {
            NSString *dateStr = [self.dataArr[indexPath.row] httpParameterString];
            cell.titleLabel.textColor = GXF_CONTENT_COLOR;
            [cell setTitleStr:[NSString stringWithFormat:@"上次更新时间:%@",dateStr]];
        }else{
            Vendor *vendor =  self.dataArr[indexPath.row];
            NSString *proStr = [NSString stringWithFormat:@"%@[%@]",vendor.name,vendor.code];
            [cell setTitleStr:proStr];
        }
    }
    return cell;
}


- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == 0) {
        return;
    }
    if (self.isMoreChose == YES) {
        MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
        cell.Commitbtn.hidden = NO;
        if (![self isHaveIndexPath:indexPath]) {
            [self.indexArr addObject:indexPath];
        }
        
        }else{
        MaskCell *currentCell = (MaskCell *)[tableView cellForRowAtIndexPath:_currentIndexPath];
        currentCell.Commitbtn.hidden = YES;
        MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
        cell.Commitbtn.hidden = NO;
        _currentIndexPath = indexPath;
    }
}

#pragma mark - 按钮事件
- (void)boxValueChanged:(NSNotification *)fication{
    NSString *tilkeStr = [IBTCommon trimmingCharacters:self.selectTextFiled.text];
    [self fetchVendorList:tilkeStr];
}
- (void)tableViewRefresh{
    _currentIndexPath = nil;
    if (self.indexArr.count > 0) {
        [self.indexArr removeAllObjects];
    }
    [self.tableView reloadData];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
