//
//  NewReceiveProductViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/10/15.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "NewReceiveProductViewController.h"
#import "SurveyCell.h"
#import "HPGrowingTextView.h"
#import "ChooseProductViewController.h"
#import "ChooseProductUnitViewController.h"
#define LeftMargin 15
#define BtnHeight 44
#define TableRowHeight 46
#define CornerRadius 5
#define BtnSize 19
#define TotalHeight 230
#define KeyboardHeight 258

@interface NewReceiveProductViewController ()<UITableViewDataSource,UITableViewDelegate,HPGrowingTextViewDelegate,UITextFieldDelegate,UIAlertViewDelegate>
{
    UITableView *_tableView;
    NSMutableArray *_dataArr;
    
    UILabel *_chooseProductLabel;
    UILabel *_choosePackUnitLabel;
    UILabel *_choosePackStandLabel;
    UILabel *_choosePackCountLabel;
    UILabel *_chooseBaseCountLabel;
    UILabel *_choosePackPriceLabel;
    UILabel *_chooseBasePriceLabel;
    UILabel *_chooseTotalPriceLabel;

    UITextField *_shPackField;
    UITextField *_shBaseQuantityField;
    UILabel *_shjcLabel;
    UILabel *_shbzLabel;
    
    HPGrowingTextView *_noteTextView;
}
@property (nonatomic,strong)NSString *productNameStr;
@property (nonatomic,strong)NSString *productCodeStr;
@property (nonatomic,strong)NSString *productUuidStr;
@property (nonatomic,strong)NSString *productQpcStr;//商品规格描述
@property (nonatomic,strong)NSMutableArray *selectProducts;
@property (nonatomic,strong)NSString *selectUnit;

@end

@implementation NewReceiveProductViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = self.navTitle;
    [self initData];
    [self createTableView];
    
}
- (void)initData{
    
    _dataArr = [NSMutableArray array];
    self.selectProducts = [NSMutableArray array];
    [_dataArr addObject:@"商品"];
    [_dataArr addObject:@"包装单位"];
    [_dataArr addObject:@"包装规格"];
    [_dataArr addObject:@"包装数量"];
    [_dataArr addObject:@"包装数量[收货]"];
    [_dataArr addObject:@"基础数量"];
    [_dataArr addObject:@"基础数量[收货]"];
    [_dataArr addObject:@"包装单价"];
    [_dataArr addObject:@"基础单价"];
    [_dataArr addObject:@"总金额[收货]"];
    [_dataArr addObject:@"备注"];
}

- (void)createTableView
{
    self.view.backgroundColor  = XXFBgColor;

    _tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, LeftMargin,ScreenSize.width, ScreenSize.height - 64 - LeftMargin)) style:(UITableViewStylePlain)];
    _tableView.delegate = self;
    _tableView.dataSource = self;
    
    UIView *footView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 50)];
    
    UIButton *commitBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(LeftMargin, 5, (ScreenSize.width - LeftMargin*2), BtnHeight) target:self sel:@selector(btnClick:) tag:0 image:nil title:@"保存" titleColor: [UIColor whiteColor] isCorner:YES corner:CornerRadius bgColor:GXF_COMMIT_COLOR];
    [footView addSubview:commitBtn];
    
    _tableView.tableFooterView = footView;
    [self.view addSubview:_tableView];
}

#pragma mark - 按钮点击事件
- (void)btnClick:(UIButton *)btn{
    if ([self checkCost]) {
        self.editReceiveProduct(self.noticeProduct,self.indexTag);
        [self PopViewControllerAnimated:YES];
    }
}
- (BOOL)checkCost{
    
    if (_shPackField.text.length == 0) {
        ShowMessage(@"包装数量(收货)不能为空");
        return NO;
    }
    if (_shBaseQuantityField.text.length == 0) {
        ShowMessage(@"基础数量(收货)不能为空");
        return NO;
    }
    if (!self.noticeProduct) {
        self.noticeProduct = [[TransferPdtDetail alloc]init];
    }
    
    self.noticeProduct.rctQty =[NSNumber numberWithFloat:[_shPackField.text floatValue]];
    self.noticeProduct.rctBaseQty = [NSNumber numberWithFloat:[_shBaseQuantityField.text floatValue]];;
    self.noticeProduct.rctTotal = [NSNumber numberWithFloat:[_chooseTotalPriceLabel.text floatValue]];
    self.noticeProduct.note = _noteTextView.text;
    return YES;
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"cellID";
    SurveyCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[SurveyCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        [self createViewInCell:cell indexPath:indexPath];
    }
    [cell setTitleStr:_dataArr[indexPath.row]];
    return cell;
}

-  (void)createViewInCell:(SurveyCell *)cell indexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == _dataArr.count -1){
        _noteTextView = [[HPGrowingTextView alloc] initWithFrame:CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-15, TableRowHeight)];
        _noteTextView.contentInset = UIEdgeInsetsMake(5, 5, 5, 0);
        _noteTextView.minNumberOfLines = 1;
        _noteTextView.maxNumberOfLines = 2;
        _noteTextView.isScrollable = YES;
        _noteTextView.font = GXF_FIFTEENTEN_SIZE;
        _noteTextView.textAlignment = NSTextAlignmentRight;
        _noteTextView.delegate = self;
        _noteTextView.returnKeyType = UIReturnKeyDone;
        _noteTextView.placeholder = @"输入备注内容";
        [cell.contentView addSubview:_noteTextView];
        
        CGRect lineFrame =  cell.lineLabel.frame;
        lineFrame.origin.y = TableRowHeight*2-1;
        cell.lineLabel.frame = lineFrame;
    }else if(indexPath.row == 4 || indexPath.row == 6){
        UITextField *textField = [[UITextField alloc] initWithFrame:CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-30, TableRowHeight)];
        textField.textAlignment = NSTextAlignmentRight;
        textField.textColor = GXF_CONTENT_COLOR;
        textField.font = GXF_FIFTEENTEN_SIZE;
        textField.returnKeyType = UIReturnKeyDone;
        textField.keyboardType = UIKeyboardTypeDecimalPad;
        textField.delegate = self;
        [cell.contentView addSubview:textField];
        textField.textColor = [UIColor redColor];

        UILabel *label = [[UILabel alloc]initWithFrame:CGRectMake(CGRectGetMaxX(textField.frame)+ 5, 0, 20, TableRowHeight)];
        label.textColor = GXF_CONTENT_COLOR;
        label.font = GXF_FIFTEENTEN_SIZE;
        [cell.contentView addSubview:label];
        if (indexPath.row == 4) {
            _shbzLabel = label;
            textField.placeholder = @"输入包装数量(收货)";
            [textField addTarget:self action:@selector(textChange:) forControlEvents:UIControlEventAllEditingEvents];
            _shPackField = textField;
        }else if(indexPath.row == 6){
            _shjcLabel = label;
            textField.enabled = NO;
            textField.placeholder = @"基础数量(收货)";
            _shBaseQuantityField = textField;
        }
    }else{
        UILabel *contentLabel = [[UILabel alloc]initWithFrame:(CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-15, TableRowHeight))];
        contentLabel.textAlignment= NSTextAlignmentRight;
        contentLabel.textColor = GXF_CONTENT_COLOR;
        contentLabel.font = GXF_FIFTEENTEN_SIZE;
        [cell.contentView addSubview:contentLabel];
        
        if (indexPath.row == 0) {
            _chooseProductLabel = contentLabel;
        }else if(indexPath.row == 1) {
            _choosePackUnitLabel = contentLabel;
        }else if(indexPath.row == 2) {
            _choosePackStandLabel = contentLabel;
        }else if(indexPath.row == 3) {
            _choosePackCountLabel = contentLabel;
        }else if(indexPath.row == 5) {
            _chooseBaseCountLabel = contentLabel;
        }else if(indexPath.row == 7) {
            _choosePackPriceLabel = contentLabel;
        }else if(indexPath.row == 8) {
            _chooseBasePriceLabel = contentLabel;
        }else if(indexPath.row == 9) {
            _chooseTotalPriceLabel= contentLabel;
            _chooseTotalPriceLabel.textColor = [UIColor redColor];
        }
    }
    if (self.noticeProduct) {
        [self prepareDataIncell];
    }
}
- (void)prepareDataIncell{
    _chooseProductLabel.text = [NSString stringWithFormat:@"%@[%@]",self.noticeProduct.productName,self.noticeProduct.productCode];
    
    _choosePackUnitLabel.text = self.noticeProduct.unit;
    
    _choosePackStandLabel.text = [NSString stringWithFormat:@"1*%@ %@",self.noticeProduct.qpc,self.noticeProduct.baseUnit];
    _choosePackCountLabel.text = [NSString stringWithFormat:@"%@ %@",self.noticeProduct.qty,self.noticeProduct.unit];
    _chooseBaseCountLabel.text = [NSString stringWithFormat:@"%@ %@",self.noticeProduct.baseQty,self.noticeProduct.baseUnit];
    _choosePackPriceLabel.text = [NSString stringWithFormat:@"%@ 元",self.noticeProduct.packprice];
     _chooseBasePriceLabel.text = [NSString stringWithFormat:@"%@ 元",self.noticeProduct.price];
    
    _shbzLabel.text = self.noticeProduct.unit;
    _shjcLabel.text = self.noticeProduct.baseUnit;
    if (self.noticeProduct.rctBaseQty) {
        _shBaseQuantityField.text =[NSString stringWithFormat:@"%@",self.noticeProduct.rctBaseQty];
    }
    if (self.noticeProduct.rctQty) {
        _shPackField.text =[NSString stringWithFormat:@"%@",self.noticeProduct.rctQty];
    }
    if (self.noticeProduct.rctTotal) {
        _chooseTotalPriceLabel.text = [NSString stringWithFormat:@"%@ 元",self.noticeProduct.rctTotal];

    }else {
        _chooseTotalPriceLabel.text = @"0 元";
    }
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
//    if (indexPath.row == _dataArr.count - 1) {
//        return TableRowHeight *2;
//    }
    return TableRowHeight;
}


- (void)textChange:(UITextField *)textField{
    if (_shPackField.text.length > 0) {
        float total = [_shPackField.text floatValue] * [self.noticeProduct.packprice floatValue];
        float baseCount = 0;
        if ([self.noticeProduct.price floatValue] > 0) {
            baseCount = total / [self.noticeProduct.price floatValue];

        }
        _chooseTotalPriceLabel.text = [NSString stringWithFormat:@"%.1f",total];
        _shBaseQuantityField.text = [NSString stringWithFormat:@"%.0f",baseCount];
    }
}


#pragma mark delegate
- (BOOL)growingTextViewShouldReturn:(HPGrowingTextView *)growingTextView{
    [_noteTextView resignFirstResponder];
    return YES;
}

- (void)keyboardHidden{
    [_shPackField resignFirstResponder];
    [_shBaseQuantityField resignFirstResponder];
    [_noteTextView resignFirstResponder];
}


@end
