//
//  GXFSearchVendorViewController.m
//  XFFruit
//  供应商选择界面
//  Created by freecui on 15/9/1.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "GXFVendorViewController.h"
#import "MaskCell.h"
#import "GXFSearchView.h"

#import "Vendor.h"


@interface GXFVendorViewController ()<UITableViewDataSource,UITableViewDelegate,GXFSearchViewDelegate>
{
    // UITextField *_selectTextFiled;
    NSIndexPath *_currentIndexPath;
    
}
@property (nonatomic, strong) UITableView *f_tableView;
@property (nonatomic, strong) GXFSearchView *c_searchView;
@property (nonatomic,strong)NSMutableArray *dataArr;
@property (nonatomic,strong)NSMutableArray *indexArr;
@property (nonatomic,assign) BOOL d_isMoreChoices;//是否是多选

@end

@implementation GXFVendorViewController

- (instancetype)initWithTitle: (NSString *)title {
    self = [super init];
    if (!self) {
        return nil;
    }
    self.title = title;
    self.d_isMoreChoices = NO;
    return self;
}
- (instancetype) initWithTitle:(NSString *)title isMoreChoices:(BOOL)isMoreChoices {
    self = [super init];
    if (!self) {
        return nil;
    }
    self.title = title;
    self.d_isMoreChoices = isMoreChoices;
    return self;
}
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    [self initData];
    [self initSubViews];
    
}

- (void)initData{
    self.dataArr = [NSMutableArray array];
    self.indexArr = [NSMutableArray array];
    [self fetchVendorList];
    
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        if (data) {
            __strong __typeof(weakSelf)strongSelf = weakSelf;
            [strongSelf fetchVendorList];
        }else{
            [IBTLoadingView showTips:data];
        }
    };
    
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
        
    [[ICRHTTPController sharedController] getVendorWithPage_number:0 page_size:100 success:succ failure:fail];

}

- (void)fetchVendorList{
    
    
    ICRDatabaseFetchBlock fetchBlk = ^FMResultSet *(FMDatabase *db) {
        NSString * sql = [NSString stringWithFormat:@"SELECT * FROM %@ ORDER BY %@", [Vendor TableName], @"uuid"];;
        return [db executeQuery:sql];
    };
    
    __weak typeof(self)weakSelf = self;
    ICRDatabaseFetchResultsBlock fetchResultsBlk = ^(NSArray *fetchedObjects) {
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        [strongSelf.dataArr removeAllObjects];
        [strongSelf.dataArr addObjectsFromArray:fetchedObjects];
        [strongSelf.f_tableView reloadData];
    };
    
    ICRDataBaseController *dbCtrl = [ICRDataBaseController sharedController];
        [dbCtrl runFetchForClass:[Vendor class]
                      fetchBlock:fetchBlk
               fetchResultsBlock:fetchResultsBlk];
}
- (void)initSubViews {
    UIBarButtonItem *rightItem = [[UIBarButtonItem alloc]initWithTitle:@"确定" style:UIBarButtonItemStylePlain target:self action:@selector(sureClicked)];
    self.navigationItem.rightBarButtonItem = rightItem;
    
    self.c_searchView = [[GXFSearchView alloc]initWithFrame:CGRectMake(0, 0, self.view.width, SEARCH_TABLECELL_HEIGHT)];
    self.c_searchView.delegate = self;
    [self.view addSubview:_c_searchView];
    
    self.f_tableView = [[UITableView alloc]initWithFrame:CGRectMake(0, SEARCH_TABLECELL_HEIGHT, self.view.width, self.view.height - SEARCH_TABLECELL_HEIGHT - NavigationBarHeight) style:UITableViewStylePlain];
    self.f_tableView.delegate = self;
    self.f_tableView.dataSource = self;
    [self.view addSubview: _f_tableView];
    
    
}

- (void)sureClicked {
    if (_d_isMoreChoices) {
        NSMutableArray *arr = [[NSMutableArray alloc]init];
        for (NSIndexPath *index in self.indexArr) {
            Vendor *vendor = self.dataArr[index.row];
             [arr addObject:vendor];
            
        }
        self.choseVendor(arr);
        
    }else{
        NSMutableArray *arr = [[NSMutableArray alloc]init];
        if (self.dataArr.count > 0) {
         Vendor *vendor = self.dataArr[_currentIndexPath.row];
            [arr addObject:vendor];
            self.choseVendor(arr);
        }
    }
    [self PopViewControllerAnimated:YES];
    
}
- (void)searchViewClickedDelegateBtn {
    if (_d_isMoreChoices) {
        [self.indexArr removeAllObjects];
    }else{
        _currentIndexPath = nil;
    }
    self.c_searchView.f_textFiled.text = @"";
    //_selectTextFiled.text = @"";
    [self.f_tableView reloadData];
    
}
#pragma mark - UITableViewDataSource 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataArr.count;
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return 50;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"MaskCell";
    MaskCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[MaskCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID totalWidth:self.view.width totalHeight:SEARCH_TABLECELL_HEIGHT];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.Commitbtn.hidden = YES;
    }
    if (_d_isMoreChoices) {
        if ([self hasIndexPath:indexPath]) {
            cell.Commitbtn.hidden = NO;
        }else{
            cell.Commitbtn.hidden = YES;
        }
    }else{
        if (_currentIndexPath) {
            if (indexPath.row == _currentIndexPath.row) {
                cell.Commitbtn.hidden = NO;
            }else{
                cell.Commitbtn.hidden = YES;
            }
        }else{
            cell.Commitbtn.hidden = YES;
        }
    }
    
    
    //cell的现实内容
    if (self.dataArr.count > 0) {
        Vendor *vendor =  self.dataArr[indexPath.row];
        NSString *proStr = [NSString stringWithFormat:@"%@[%@]",vendor.name,vendor.code];
        
        [cell setTitleStr:proStr];
    }
    return cell;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    if (_d_isMoreChoices == YES) {
        MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
        cell.Commitbtn.hidden = NO;
        if (![self hasIndexPath:indexPath]) {
            [self.indexArr addObject:indexPath];
        }
        
        NSString *personStr = @"";
        for (NSIndexPath *index in self.indexArr) {
            Vendor *vendor = self.dataArr[index.row];
            if (personStr.length == 0) {
                personStr = [personStr stringByAppendingFormat:@"%@",vendor.name];
            }else{
                personStr = [personStr stringByAppendingFormat:@"、%@",vendor.name];
            }
        }
        self.c_searchView.f_textFiled.text = personStr;
        // _selectTextFiled.text = personStr;
    }else{
        MaskCell *currentCell = (MaskCell *)[tableView cellForRowAtIndexPath:_currentIndexPath];
        currentCell.Commitbtn.hidden = YES;
        MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
        cell.Commitbtn.hidden = NO;
        _currentIndexPath = indexPath;

        Vendor *vendor = self.dataArr[indexPath.row];
        self.c_searchView.f_textFiled.text  = vendor.name;
        
        
    }
}
- (BOOL)hasIndexPath:(NSIndexPath *)indexPath{
    for (NSIndexPath *path in self.indexArr) {
        if (path.row == indexPath.row) {
            return YES;
        }
    }
    return NO;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}



@end
