//
//  CostCell.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/7.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "CostCell.h"
#define LeftMargin 13
#define TableHeight 44
#define SmallSize 10
#define SmallWidth 20
#define SpaceMargin 1
#define LeftWidth 45
#define RightWidth 30

#define ShowWidth 150
#define ShowHeight 20

@implementation CostCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout
{
    CGFloat headWidth = (ScreenSize.width - LeftWidth - LeftWidth - SpaceMargin* (4 -1))/4;
    
    self.smallImageView = [[UIImageView alloc]initWithFrame:CGRectMake(LeftMargin, (TableHeight - SmallSize)/2 , SmallSize, SmallSize)];
    self.smallImageView.image = [UIImage imageNamed:@"arrowright"];
    
    self.seqLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.smallImageView.frame), 0, SmallWidth, TableHeight))];
    self.seqLabel.textColor = GXF_CONTENT_COLOR;
    self.seqLabel.text = @"13";
    self.seqLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.typeLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftWidth, 0, headWidth, TableHeight))];
    self.typeLabel.textAlignment = NSTextAlignmentCenter;
    self.typeLabel.textColor = GXF_CONTENT_COLOR;
    self.typeLabel.text = @"苹果桃子";
    self.typeLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.actualLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.typeLabel.frame) + SpaceMargin, 0, headWidth, TableHeight))];
    self.actualLabel.textAlignment = NSTextAlignmentCenter;
    self.actualLabel.textColor = GXF_CONTENT_COLOR;
    self.actualLabel.text = @"30000";
    self.actualLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.paidLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.actualLabel.frame) + SpaceMargin, 0, headWidth, TableHeight))];
    self.paidLabel.textAlignment = NSTextAlignmentCenter;
    self.paidLabel.text = @"2015-04-05";
    self.paidLabel.textColor = GXF_CONTENT_COLOR;
    self.paidLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.leftLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.paidLabel.frame) + SpaceMargin, 0, headWidth, TableHeight))];
    self.leftLabel.textAlignment = NSTextAlignmentCenter;
    self.leftLabel.text = @"2015-04-05";
    self.leftLabel.textColor = GXF_CONTENT_COLOR;
    self.leftLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.showView = [[UIView alloc]initWithFrame:CGRectMake(0, TableHeight, ScreenSize.width, 0)];
    self.showView.clipsToBounds = YES;
    
    self.showActualLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.seqLabel.frame), 0, ShowWidth, ShowHeight))];
    self.showActualLabel.textAlignment = NSTextAlignmentLeft;
    self.showActualLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showActualLabel.font = GXF_THREETEENTH_SIZE;
    
    
    self.showPaidLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.showActualLabel.frame), 0, ShowWidth, ShowHeight))];
    self.showPaidLabel.textAlignment = NSTextAlignmentLeft;
    self.showPaidLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showPaidLabel.font = GXF_THREETEENTH_SIZE;
    
    self.showLeftLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showActualLabel.frame), CGRectGetMaxY(self.showActualLabel.frame), ShowWidth, ShowHeight))];
    self.showLeftLabel.textAlignment = NSTextAlignmentLeft;
    self.showLeftLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showLeftLabel.font = GXF_THREETEENTH_SIZE;
    
    self.showNote = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showLeftLabel.frame), CGRectGetMaxY(self.showLeftLabel.frame), ShowWidth*2, ShowHeight))];
    self.showNote.textAlignment = NSTextAlignmentLeft;
    self.showNote.textColor = GXF_PLACEHOLDER_COLOR;
    self.showNote.font = GXF_THREETEENTH_SIZE;
    self.showNote.numberOfLines = 0;

    self.editBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.editBtn setImage:[UIImage imageNamed:@"edit"] forState:UIControlStateNormal];
    self.editBtn.frame = CGRectMake(ScreenSize.width - LeftWidth, 0, LeftWidth, TableHeight);
    
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin,TableHeight-1, ScreenSize.width  - LeftMargin * 2, 1))];;
    self.lineLabel.backgroundColor = GXF_LINE_COLOR;
    [self.contentView addSubview:self.smallImageView];
    [self.contentView addSubview:self.seqLabel];
    [self.contentView addSubview:self.smallImageView];
    [self.contentView addSubview:self.typeLabel];
    [self.contentView addSubview:self.editBtn];
    [self.contentView addSubview:self.actualLabel];
    [self.contentView addSubview:self.paidLabel];
    [self.contentView addSubview:self.leftLabel];
    [self.contentView addSubview:self.lineLabel];
    
    [self.contentView addSubview:self.showView];
    [self.showView addSubview:self.showActualLabel];
    [self.showView addSubview:self.showPaidLabel];
    [self.showView addSubview:self.showLeftLabel];
    [self.showView addSubview:self.showNote];

}
- (void)setFeeCost:(FeeAcountDetail *)fee row:(NSInteger)row
{
    self.seqLabel.text = [NSString stringWithFormat:@"%@",@(row+1)];
    self.typeLabel.text = fee.accounttitle;
    self.actualLabel.text = [NSString stringWithFormat:@"%@元",[fee.actualmoney stringValue]];
    self.paidLabel.text = [NSString stringWithFormat:@"%@元",[fee.paidmoney stringValue]];
    self.leftLabel.text = [NSString stringWithFormat:@"%@元",[fee.leftmoney stringValue]];
    
    self.showActualLabel.text = [NSString stringWithFormat:@"应付金额：%@元",[fee.actualmoney stringValue]];
    self.showPaidLabel.text = [NSString stringWithFormat:@"已付金额：%@元",[fee.paidmoney stringValue]];
    self.showLeftLabel.text = [NSString stringWithFormat:@"尾款：%@元",[fee.leftmoney stringValue]];
    self.showNote.text = [NSString stringWithFormat:@"备注：%@",fee.note?fee.note:@"无"];
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
