//
//  TransportDetailViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/7.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "TransportDetailViewController.h"
#import "TransportProductViewController.h"
#import "Transport.h"
#import "TransportPdtDetail.h"
#import "FeeAcountDetail.h"
#import "BottomTransportView.h"
#define BottomHeight                                50
#define LeftMargin                                  15
#define LeftWidth                                   100
#define LeftHeight                                  30
#define TopMargin                                   15
typedef enum : NSUInteger {
    AbortTag = 20000,
    EndTag,
    SubmitTag
    
} BtnTag;

@interface TransportDetailViewController ()
{
    UIScrollView *_scrollView;
    UIView *_transportView;
    UIView *_bottomView;
    UIButton *_firstBtn;
    UIButton *_secondBtn;
    BottomTransportView *_transView;
}
@property (nonatomic,strong)UILabel *billNumberLabel;
@property (nonatomic,strong)UILabel *purchaseLabel;
@property (nonatomic,strong)UILabel *stateLabel;
@property (nonatomic,strong)UILabel *warehouseLabel;
@property (nonatomic,strong)UILabel *rwarehouseLabel;
@property (nonatomic,strong)UILabel *carnumberLabel;
@property (nonatomic,strong)UILabel *carhoneLabel;
@property (nonatomic,strong)UILabel *createOperLabel;
@property (nonatomic, strong) UILabel *lastModifierLabel;
@property (nonatomic,strong)UILabel *arriveDateLabel;
@property (nonatomic,strong)UILabel *noteLabel;

@property (nonatomic,strong)UILabel *leftBillNumberLabel;
@property (nonatomic,strong)UILabel *leftPurchaseLabel;
@property (nonatomic,strong)UILabel *leftStateLabel;
@property (nonatomic,strong)UILabel *leftWarehouseLabel;
@property (nonatomic,strong)UILabel *leftRwarehouseLabel;
@property (nonatomic,strong)UILabel *leftCarnumberLabel;
@property (nonatomic,strong)UILabel *leftCarhoneLabel;
@property (nonatomic,strong)UILabel *leftCreateOperLabel;
@property (nonatomic, strong) UILabel *leftLastModifierLabel;
@property (nonatomic,strong)UILabel *leftArriveDateLabel;
@property (nonatomic,strong)UILabel *leftNoteLabel;
@end

@implementation TransportDetailViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"发运单详情";
    [self bulifLayout];
    [self getDataFromServer];
}

- (void)getDataFromServer{
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message  = data[@"message"] ;
            if (success == 1) {
                NSDictionary *dictData = data[@"data"];
                Transport *transport = [[Transport alloc]init];
                [transport setValuesForKeysWithDictionary:dictData];
                self.transport = transport;
                [strongSelf fetchtTransportDetail];
            }else{
                [IBTLoadingView showTips:message];
            }
        }else{
            [IBTLoadingView showTips:@"     无记录     "];
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    [[ICRHTTPController sharedController] getTransportResultWithTransportUuid:self.transport.uuid success:succ failure:fail];
}




- (void)fetchtTransportDetail{
    self.billNumberLabel.text = [IBTCommon checkString:self.transport.billnumber];
    if ([self.transport.state isEqualToString:TRANSPORT_STATE_UNRECEIVED]) {
        self.stateLabel.textColor = [UIColor redColor];
        self.stateLabel.text = @"待收货";
    }else if ([self.transport.state isEqualToString:TRANSPORT_STATE_RECEIVED]) {
        self.stateLabel.textColor = [UIColor greenColor];
        self.stateLabel.text = @"已收货";
    }else if ([self.transport.state isEqualToString:TRANSPORT_STATE_ABORTED]) {
        self.stateLabel.textColor = [UIColor grayColor];
        self.stateLabel.text = @"已作废";
    }else if ([self.transport.state isEqualToString:TRANSPORT_STATE_PROCESS]) {
        self.stateLabel.textColor = [UIColor greenColor];
        self.stateLabel.text = @"提交系统处理";
    }else if ([self.transport.state isEqualToString:TRANSPORT_STATE_PROCESSFAIL]) {
        self.stateLabel.textColor = [UIColor blackColor];
        self.stateLabel.text = @"系统处理失败";
    }
    self.purchaseLabel.text = [self getPurchaseWith:self.transport.pdtDetails];
    self.warehouseLabel.text = [IBTCommon checkString:self.transport.warehouseName];
    self.rwarehouseLabel.text = [IBTCommon checkString:self.transport.rwarehouseName];
    self.carnumberLabel.text = [IBTCommon checkString:self.transport.carnumber];
    self.carhoneLabel.text = [IBTCommon checkString:self.transport.carphone];
    self.noteLabel.text = [NSString stringWithFormat:@"%@",self.transport.note?self.transport.note:@"无"];
    self.createOperLabel.text = [NSString stringWithFormat:@"%@%@",[IBTCommon checkString:self.transport.create_operName],self.transport.create_time.length > 10 ? [self.transport.create_time substringToIndex:10] : self.transport.create_time];
    self.lastModifierLabel.text = [IBTCommon checkString:self.transport.lastModify_operName];
    self.arriveDateLabel.text = [NSString stringWithFormat:@"%@",self.transport.arriveDate?[[IBTCommon checkString:self.transport.arriveDate]substringToIndex:10]:@"无"];
    [_transView refreshTranProduct:self.transport.pdtDetails];
    [_transView refreshCost:self.transport.accountDetails];
    [self setNoteHeight];
}
- (NSString *)getPurchaseWith:(NSArray *)purchases{
    NSString *purchseNumber = @"";
    
    NSInteger count = 0;

    for (NSDictionary *billDict in purchases) {
        if (![billDict[@"purchasebillnumber"] isEqual:[NSNull null]]) {
            count ++;
            if (purchseNumber.length == 0) {
                purchseNumber = [purchseNumber stringByAppendingFormat:@"%@",billDict[@"purchasebillnumber"]];
            }else{
                purchseNumber = [purchseNumber stringByAppendingFormat:@",%@" ,billDict[@"purchasebillnumber"]];
            }
        }
    }
    if (count == 0) {
        purchseNumber = @"无";
    }
    return purchseNumber;
}
- (void)setNoteHeight
{
    CGFloat purchaseHeight = [self.purchaseLabel calculateHeight];
    if (purchaseHeight < LeftHeight) {
        purchaseHeight = LeftHeight;
    }
    self.purchaseLabel.height = purchaseHeight;
    
    self.leftStateLabel.top = self.purchaseLabel.bottom;
    self.stateLabel.top = self.purchaseLabel.bottom;
    
    self.leftWarehouseLabel.top = self.leftStateLabel.bottom;
    self.warehouseLabel.top = self.leftStateLabel.bottom;
    
    self.leftRwarehouseLabel.top = self.leftWarehouseLabel.bottom;
    self.rwarehouseLabel.top = self.leftWarehouseLabel.bottom;
    
    
    self.leftCarnumberLabel.top = self.leftRwarehouseLabel.bottom;
    self.carnumberLabel.top = self.leftRwarehouseLabel.bottom;
    
    self.leftCarhoneLabel.top = self.leftCarnumberLabel.bottom;
    self.carhoneLabel.top = self.leftCarnumberLabel.bottom;
    
    self.leftCreateOperLabel.top = self.leftCarhoneLabel.bottom;
    self.createOperLabel.top = self.leftCarhoneLabel.bottom;
    
    
    
    self.leftLastModifierLabel.top = self.leftCreateOperLabel.bottom;
    self.lastModifierLabel.top = self.leftCreateOperLabel.bottom;
    
    self.leftArriveDateLabel.top = self.leftLastModifierLabel.bottom;
    self.arriveDateLabel.top = self.leftLastModifierLabel.bottom;
    
    self.leftNoteLabel.top = self.leftArriveDateLabel.bottom;
    self.noteLabel.top = self.leftArriveDateLabel.bottom;
    
    CGFloat height =  [self.noteLabel calculateHeight];
    if (height < LeftHeight) {
        height = LeftHeight;
    }

    self.noteLabel.height = height;
    
    CGFloat totalHeight = height + LeftHeight*9 + purchaseHeight;
    
    CGRect purchaseFrame = _transportView.frame;
    purchaseFrame.size.height = totalHeight + LeftMargin;
    _transportView.frame = purchaseFrame;
    
    CGRect bottomFrame = _bottomView.frame;
    bottomFrame.origin.y = CGRectGetMaxY(_transportView.frame) + TopMargin;
    _bottomView.frame = bottomFrame;
    
    _scrollView.contentSize = CGSizeMake(ScreenSize.width, totalHeight + CGRectGetHeight(_bottomView.frame) + TopMargin*2);
}

- (void)btnClick:(UIButton *)btn{
    CLog(@"%ld",(long)btn.tag);
    switch (btn.tag) {
        case AbortTag:
        {
            CLog(@"作废");
            UIAlertView *alertView = [[UIAlertView alloc]initWithTitle:@"温馨提示" message:@"请确认作废" delegate:self cancelButtonTitle:@"取消" otherButtonTitles:@"确认", nil];
            alertView.delegate = self;
            alertView.tag = AbortTag;
            [alertView show];
        }
            break;
        case EndTag:
        {
            CLog(@"结束");
            UIAlertView *alertView = [[UIAlertView alloc]initWithTitle:@"温馨提示" message:@"请确认结束" delegate:self cancelButtonTitle:@"取消" otherButtonTitles:@"确认", nil];
            alertView.delegate = self;
            alertView.tag = EndTag;
            [alertView show];
        }
            break;
        case SubmitTag:
        {
            CLog(@"提交");
            UIAlertView *alertView = [[UIAlertView alloc]initWithTitle:@"温馨提示" message:@"请确认提交" delegate:self cancelButtonTitle:@"取消" otherButtonTitles:@"确认", nil];
            alertView.delegate = self;
            alertView.tag = SubmitTag;
            [alertView show];
        }
            break;
        default:
            break;
    }
}
- (void)dealByAction:(NSString *)action{
    //保存
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message = data[@"message"];
            if (success == 1) {
                [ICRUserUtil sharedInstance].needFresh = YES;
                [self PopViewControllerAnimated:YES];
            }else{
                [IBTLoadingView showTips:message];
            }
        }else{
            [IBTLoadingView showTips:@"操作异常"];
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    if ([action isEqualToString:TRANSPORT_STATE_ABORTED]) {
        [[ICRHTTPController sharedController] abortTransportWithTransportUuid:self.transport.uuid version:self.transport.version success:succ failure:fail];
    }else{
        [[ICRHTTPController sharedController] endTransportWithTransportUuid:self.transport.uuid version:self.transport.version success:succ failure:fail];
    }
}
- (void)hiddenAllBtn{
    CGRect scrollViewFrame = _scrollView.frame;
    scrollViewFrame.size.height = ScreenSize.height - 64;
    _scrollView.frame = scrollViewFrame;
}

- (void)createBtnWithArr:(NSArray *)arr{
    CGFloat btnWidth = (ScreenSize.width - LeftMargin * (arr.count+1))/arr.count;
    for (NSInteger i = 0; i < arr.count; i++) {
        NSInteger btnTag = 0;
        if ([arr[i] isEqualToString:@"结束"]) {
            btnTag = EndTag;
        }else if ([arr[i] isEqualToString:@"作废"]) {
            btnTag = AbortTag;
        }else if ([arr[i] isEqualToString:@"提交"]) {
            btnTag = SubmitTag;
        }
        CGRect btnFrame = CGRectMake(LeftMargin + (LeftMargin + btnWidth)*i,  ScreenSize.height  - 64 - BottomHeight +5, btnWidth, 40);
        UIButton *perBtn = [IBTCustomButtom creatButtonWithFrame:btnFrame target:self sel:@selector(btnClick:) tag:btnTag image:nil title:arr[i] titleColor:[UIColor whiteColor] isCorner:YES corner:5 bgColor:GXF_COMMIT_COLOR];
        [self.view addSubview:perBtn];
    }
}


#pragma mark - 视图初始化
- (void)bulifLayout{
    _scrollView = [[UIScrollView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, ScreenSize.height - 64 - BottomHeight)];
    _scrollView.showsHorizontalScrollIndicator  = NO;
    _scrollView.showsVerticalScrollIndicator = NO;
    _scrollView.backgroundColor = XXFBgColor;
    [self.view addSubview:_scrollView];

    
    if ([self.transport.state isEqualToString:TRANSPORT_STATE_ABORTED]) {
        [self hiddenAllBtn];
    }else if([self.transport.state isEqualToString:TRANSPORT_STATE_FINISHED]){
        if ([IBTCommon checkIsPermission:TRANSPORT_ACTION_ABORT]) {
            NSArray *arr = @[@"作废"];
            [self createBtnWithArr:arr];
        }else{
            [self hiddenAllBtn];
        }
    }else if([self.transport.state isEqualToString:TRANSPORT_STATE_RECEIVED]){
        NSMutableArray *arr = [NSMutableArray array];
        if ([IBTCommon checkIsPermission:TRANSPORT_ACTION_ABORT]) {
            [arr addObject:@"作废"];
        }
        if([IBTCommon checkIsPermission:TRANSPORT_ACTION_FINISH])
        {
            [arr addObject:@"结束"];
        }
        if (arr.count == 0) {
            [self hiddenAllBtn];
        }else{
            [self createBtnWithArr:arr];
        }
    }else if ([self.transport.state isEqualToString:TRANSPORT_STATE_PROCESSFAIL]){
        NSMutableArray *arr = [NSMutableArray array];
        if ([IBTCommon checkIsPermission:TRANSPORT_ACTION_ABORT]) {
            [arr addObject:@"作废"];
        }if ([IBTCommon checkIsPermission:TRANSPORT_ACTION_NEW]) {
            [arr addObject:@"提交"];
        }
        if (arr.count == 0) {
            [self hiddenAllBtn];
        }else{
            [self createBtnWithArr:arr];
        }
    }else{
        [self hiddenAllBtn];
    }
    NSArray *leftArr = @[@"单号:",@"采购单:",@"状态:",@"发货仓库:",@"收货仓库:",@"车辆:",@"司机电话:",@"创建:",@"最后修改人:", @"预计到货时间:",@"备注:"];
    
    _transportView= [[UIView alloc]initWithFrame:CGRectMake(0, TopMargin, ScreenSize.width, LeftHeight*leftArr.count +LeftMargin)];
    _transportView.backgroundColor = [UIColor whiteColor];
    [_scrollView addSubview:_transportView];
    
    
    for (NSInteger i = 0 ; i < leftArr.count; i++) {
        UILabel *leftLabel = [[UILabel alloc]initWithFrame:CGRectMake(LeftMargin, 10 + LeftHeight *i, LeftWidth, LeftHeight)];
        leftLabel.font = GXF_SEVENTEENTH_SIZE;
        leftLabel.text = leftArr[i];
        leftLabel.textColor = GXF_DETAIL_COLOR;
        [_transportView addSubview:leftLabel];
        
        UILabel *rightLabel = [[UILabel alloc]initWithFrame:CGRectMake(CGRectGetMaxX(leftLabel.frame), 10 + LeftHeight *i, _transportView.frame.size.width - LeftMargin - LeftWidth, LeftHeight)];
        rightLabel.font = GXF_SEVENTEENTH_SIZE;
        rightLabel.textColor = GXF_DETAIL_COLOR;
        
        if (i == 0) {
            self.billNumberLabel = rightLabel;
            self.leftBillNumberLabel = leftLabel;
        }else if (i == 1) {
            self.purchaseLabel = rightLabel;
            self.purchaseLabel.numberOfLines = 0;
            self.leftPurchaseLabel = leftLabel;
        }else if(i == 2){
            self.stateLabel = rightLabel;
            self.leftStateLabel = leftLabel;
        }else if(i == 3){
            self.warehouseLabel = rightLabel;
            self.leftWarehouseLabel = leftLabel;
        }else if(i == 4){
            self.rwarehouseLabel = rightLabel;
            self.leftRwarehouseLabel = leftLabel;
        }else if(i == 5){
            self.carnumberLabel = rightLabel;
            self.leftCarnumberLabel = leftLabel;
        }else if(i == 6){
            self.carhoneLabel = rightLabel;
            self.leftCarhoneLabel = leftLabel;
        }else if(i == 7){
            self.createOperLabel = rightLabel;
            self.leftCreateOperLabel = leftLabel;
        }else if(i == 8){//最后修改人
            self.lastModifierLabel = rightLabel;
            self.leftLastModifierLabel = leftLabel;
        }else if(i == 9){
            leftLabel.width = LeftWidth + 10;
            rightLabel.left = leftLabel.right;
            rightLabel.width = ScreenSize.width - leftLabel.width - LeftMargin;
            self.arriveDateLabel = rightLabel;
            self.leftArriveDateLabel = leftLabel;
        }else if(i == leftArr.count - 1){
            rightLabel.numberOfLines = 0;
            self.noteLabel = rightLabel;
            self.leftNoteLabel = leftLabel;
        }
        [_transportView addSubview:rightLabel];
    }
    [self createBottomView];
}

- (void)createBottomView{
    _bottomView= [[UIView alloc]initWithFrame:CGRectMake(0, CGRectGetMaxY(_transportView.frame) + TopMargin, ScreenSize.width, 300)];
    _bottomView.backgroundColor = [UIColor whiteColor];
    
    [_scrollView addSubview:_bottomView];
    
    _transView = [[BottomTransportView alloc]initWithFrame:_bottomView.bounds withHidden:YES];
    [_bottomView addSubview:_transView];
}

- (void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex{
    if (alertView.tag == AbortTag) {
        if (buttonIndex == 1) {
            [self dealByAction:TRANSPORT_STATE_ABORTED];//作废
        }
    }else if (alertView.tag == EndTag){
        if (buttonIndex == 1) {
            [self dealByAction:TRANSPORT_STATE_RECEIVED];//结束
        }
    }else if (alertView.tag == SubmitTag){
        if (buttonIndex == 1) {
            [self getDataFromServer:TRANSPORT_STATE_RECEIVED msg:@"正在提交..."];
        }
    }
}

#pragma mark - 提交
- (void)getDataFromServer:(NSString *)state msg:(NSString *)msg{
    //保存
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message = data[@"message"];
            if (success == 1) {
                [ICRUserUtil sharedInstance].needFresh = YES;
                [self PopViewControllerAnimated:YES];
            }else{
                [IBTLoadingView showTips:message];
            }
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    NSDictionary *dict = @{@"uuid":self.transport.uuid,
                           @"version":self.transport.version,
                           @"billnumber":self.transport.billnumber,
                           @"enterprise":[ICRUserUtil sharedInstance].orgId,
                           @"state":TRANSPORT_STATE_RECEIVED,
                           @"warehouseUuid":[IBTCommon checkString:self.transport.warehouseUuid],
                           @"warehouseCode":[IBTCommon checkString:self.transport.warehouseCode],
                           @"warehouseName":[IBTCommon checkString:self.transport.warehouseName],
                           @"rwarehouseUuid":[IBTCommon checkString:self.transport.rwarehouseUuid],
                           @"rwarehouseCode":[IBTCommon checkString:self.transport.rwarehouseCode],
                           @"rwarehouseName":[IBTCommon checkString:self.transport.rwarehouseName],
                           @"carnumber":[IBTCommon checkString:self.transport.carnumber],
                           @"type":[IBTCommon checkString:self.transport.type],
                           @"carphone":[IBTCommon checkString:self.transport.carphone],
                           @"arriveDate":[IBTCommon checkString:self.transport.arriveDate],
                           @"note":[IBTCommon checkString:self.transport.note],
                           @"pdtDetails":self.transport.pdtDetails,
                           @"accountDetails":self.transport.accountDetails};
    [IBTLoadingView showProgressLabel:msg];
    [[ICRHTTPController sharedController] saveAndSubmitTransportWithData:dict success:succ failure:fail];
    
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
 #pragma mark - Navigation
 
 // In a storyboard-based application, you will often want to do a little preparation before navigation
 - (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
 // Get the new view controller using [segue destinationViewController].
 // Pass the selected object to the new view controller.
 }
 */

@end
