//
//  PassengerHeaderCell.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/8.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "PassengerHeaderCell.h"


#define Sale_Header_Height 35

@interface PassengerHeaderCell ()
{
    BOOL    hasBuildLayout;         // default, NO;
}

@property (nonatomic, strong) UILabel *label;
@property (nonatomic, strong) UILabel *searchLabel;

@property (nonatomic, strong) UIFont *textFont;
@property (nonatomic, strong) UILabel *bszLabel;

@end


@implementation PassengerHeaderCell


+ (CGFloat)viewHeight
{
    return Sale_Header_Height;
}

- (void)buildLayout:(NSString *)titleStr
{
    if(hasBuildLayout) {
        return;
    }
    
    if(self.textFont == nil) {
        self.textFont = [UIFont systemFontOfSize:13];
    }
    
    hasBuildLayout = YES;
    self.contentView.backgroundColor = XXFBgColor;
    
    CGRect rect = CGRectMake(0, 0, ScreenSize.width, 1);
    UILabel *lineLabel = [[UILabel alloc]initWithFrame:rect];
    lineLabel.backgroundColor = GXF_LINE_COLOR;
    [self.contentView addSubview:lineLabel];
    
    rect = CGRectMake(10, 0, 150, Sale_Header_Height);
    UILabel *searLabel = [IBTCommon labelWithTitle:@"" frame:rect textFont:self.textFont];
    searLabel.textColor = ReportTitleColor;
    [self.contentView addSubview:searLabel];
    self.searchLabel = searLabel;

    
    
    CGFloat width = (ScreenSize.width  - searLabel.right - 35)/2;
    
    rect = CGRectMake(self.searchLabel.right, 0, width, Sale_Header_Height);
    UILabel * ksjLabel = [IBTCommon labelWithTitle:titleStr frame:rect textFont:self.textFont];
    ksjLabel.textColor = ReportTitleColor;
    [self.contentView addSubview:ksjLabel];
    
    
    rect = CGRectMake(ksjLabel.right , 0, width, Sale_Header_Height);
    UILabel * bszLabel = [IBTCommon labelWithTitle:@"比上周" frame:rect textFont:self.textFont];
    bszLabel.textColor = ReportTitleColor;
    [self.contentView addSubview:bszLabel];
    self.bszLabel = bszLabel;
    
    rect = CGRectMake(0, Sale_Header_Height-1, ScreenSize.width, 1);
    UILabel *lineTLabel = [[UILabel alloc]initWithFrame:rect];
    lineTLabel.backgroundColor = GXF_LINE_COLOR;
    [self.contentView addSubview:lineTLabel];
}

- (void)setTotalValue:(NSString *)totalValue{
    self.searchLabel.text = totalValue;
}

- (void)changeTypeName:(NSString *)name{
    NSString *typeStr = @"";
    if ([name isEqualToString:SaleEnMonth]) {
        typeStr = LastMonth;
    }else{
        typeStr = LastWeak;
    }
    self.bszLabel.text = typeStr;
}


@end
