//
//  GXFSearchVendorViewController.m
//  XFFruit
//  供应商选择界面
//  Created by freecui on 15/9/1.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "GXFSearchVendorViewController.h"
#import "MaskCell.h"
#import "GXFSearchView.h"

#import "Vendor.h"
#import "Product.h"
#import "Warehouse.h"
#import "GXFProductUnit.h"

@interface GXFSearchVendorViewController ()<UITableViewDataSource,UITableViewDelegate,GXFSearchViewDelegate>
{
   // UITextField *_selectTextFiled;
    NSIndexPath *_currentIndexPath;
    
}
@property (nonatomic, strong) UITableView *f_tableView;
@property (nonatomic, strong) GXFSearchView *c_searchView;
@property (nonatomic,strong)NSMutableArray *dataArr;
@property (nonatomic,strong)NSMutableArray *indexArr;
@property (nonatomic,assign) BOOL d_isMoreChoices;//是否是多选

@end

@implementation GXFSearchVendorViewController

- (instancetype)initWithTitle: (NSString *)title {
    self = [super init];
    if (!self) {
        return nil;
    }
    self.title = title;
    self.d_isMoreChoices = NO;
    return self;
}
- (instancetype) initWithTitle:(NSString *)title isMoreChoices:(BOOL)isMoreChoices {
    self = [super init];
    if (!self) {
        return nil;
    }
    self.title = title;
    self.d_isMoreChoices = isMoreChoices;
    return self;
}
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.

    [self initData];
    [self initSubViews];
    
}

- (void)initData{
    self.dataArr = [NSMutableArray array];
    self.indexArr = [NSMutableArray array];
    [self fetchVendorList];
    
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        if (data) {
            __strong __typeof(weakSelf)strongSelf = weakSelf;
            [strongSelf fetchVendorList];
        }else{
            [IBTLoadingView showTips:data];
        }
    };
    
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    
    
    
    NSInteger pageNumber = 0;
    NSInteger pageSize = 100;
    //判断选择
    if ([self.title isEqualToString:[IBTCommon localizableString:@"ProductTitle"]]) {
        [[ICRHTTPController sharedController] getProductWithStartDate:@"2014-01-01" Page_number:0 page_size:100 success:succ failure:fail];
    } else if ([self.title isEqualToString:[IBTCommon localizableString:@"VendorTitle"]]) {
        
        [[ICRHTTPController sharedController] getVendorWithStartDate:@"2014-01-01"  Page_number:0 page_size:100 success:succ failure:fail];
    } else if ([self.title isEqualToString:[IBTCommon localizableString:@"WarehouseTitle"]]) {
        
        [[ICRHTTPController sharedController] getWarehouseWithStartDate:@"2014-01-01"  Page_number:0 page_size:100 success:succ failure:fail];
    } else if ([self.title isEqualToString:[IBTCommon localizableString:@"ProductUnitTitle"]]) {
        
        [[ICRHTTPController sharedController]getProductunitWithPage_number:pageNumber page_size:pageSize success:succ failure:fail];
    } else {
    
    }

   // [[ICRHTTPController sharedController] getVendorWithPage_number:0 page_size:100 success:succ failure:fail];
}

/*
 
 
 //判断选择
 if ([self.title isEqualToString:[IBTCommon localizableString:@"ProductTitle"]]) {
 
 } else if ([self.title isEqualToString:[IBTCommon localizableString:@"VendorTitle"]]) {
 
 
 } else if ([self.title isEqualToString:[IBTCommon localizableString:@"WarehouseTitle"]]) {
 
 } else {
 
 }

 */
- (void)fetchVendorList{
    
    
    ICRDatabaseFetchBlock fetchBlk = ^FMResultSet *(FMDatabase *db) {
        NSString * sql;
        //判断选择
        if ([self.title isEqualToString:[IBTCommon localizableString:@"ProductTitle"]]) {
            
            sql =  [NSString stringWithFormat:@"SELECT * FROM %@ ORDER BY %@", [Product TableName], @"uuid"];
        } else if ([self.title isEqualToString:[IBTCommon localizableString:@"VendorTitle"]]) {
            
            sql =  [NSString stringWithFormat:@"SELECT * FROM %@ ORDER BY %@", [Vendor TableName], @"uuid"];
        } else if ([self.title isEqualToString:[IBTCommon localizableString:@"WarehouseTitle"]]) {
            
           sql =  [NSString stringWithFormat:@"SELECT * FROM %@ ORDER BY %@", [Warehouse TableName], @"uuid"];
        } else if ([self.title isEqualToString:[IBTCommon localizableString:@"ProductUnitTitle"]]) {
            
            sql =  [NSString stringWithFormat:@"SELECT * FROM %@ ORDER BY %@", [GXFProductUnit TableName], @"uuid"];
        } else {
            
        }

        
      // sql =  [NSString stringWithFormat:@"SELECT * FROM %@ ORDER BY %@", [Vendor TableName], @"uuid"];
        return [db executeQuery:sql];
    };
    
    __weak typeof(self)weakSelf = self;
    ICRDatabaseFetchResultsBlock fetchResultsBlk = ^(NSArray *fetchedObjects) {
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        [strongSelf.dataArr removeAllObjects];
        [strongSelf.dataArr addObjectsFromArray:fetchedObjects];
        [strongSelf.f_tableView reloadData];
    };
    
    ICRDataBaseController *dbCtrl = [ICRDataBaseController sharedController];
    //判断选择
    if ([self.title isEqualToString:[IBTCommon localizableString:@"ProductTitle"]]) {
        
        [dbCtrl runFetchForClass:[Product class]
                      fetchBlock:fetchBlk
               fetchResultsBlock:fetchResultsBlk];
        
    } else if ([self.title isEqualToString:[IBTCommon localizableString:@"VendorTitle"]]) {
        [dbCtrl runFetchForClass:[Vendor class]
                      fetchBlock:fetchBlk
               fetchResultsBlock:fetchResultsBlk];
        
    } else if ([self.title isEqualToString:[IBTCommon localizableString:@"WarehouseTitle"]]) {
        
        [dbCtrl runFetchForClass:[Warehouse class]
                      fetchBlock:fetchBlk
               fetchResultsBlock:fetchResultsBlk];
        
    } else if ([self.title isEqualToString:[IBTCommon localizableString:@"ProductUnitTitle"]]) {
        [dbCtrl runFetchForClass:[GXFProductUnit class]
                      fetchBlock:fetchBlk
               fetchResultsBlock:fetchResultsBlk];
    }else {
        
    }

}
- (void)initSubViews {
    UIBarButtonItem *rightItem = [[UIBarButtonItem alloc]initWithTitle:@"确定" style:UIBarButtonItemStylePlain target:self action:@selector(sureClicked)];
    self.navigationItem.rightBarButtonItem = rightItem;
    
    self.c_searchView = [[GXFSearchView alloc]initWithFrame:CGRectMake(0, 0, self.view.width, TopMargin)];
    self.c_searchView.delegate = self;
    [self.view addSubview:_c_searchView];
    
    self.f_tableView = [[UITableView alloc]initWithFrame:CGRectMake(0, TopMargin, self.view.width, self.view.height - TopMargin - NavigationBarHeight) style:UITableViewStylePlain];
    self.f_tableView.delegate = self;
    self.f_tableView.dataSource = self;
    [self.view addSubview: _f_tableView];
    

}

- (void)sureClicked {
    if (_d_isMoreChoices) {
        NSMutableArray *arr = [[NSMutableArray alloc]init];
        for (NSIndexPath *index in self.indexArr) {
            //Vendor *vendor = self.dataArr[index.row];
           // [arr addObject:vendor];
            [arr addObject:self.dataArr[index.row]];
        }
        self.choseVendor(arr);
        
    }else{
        NSMutableArray *arr = [[NSMutableArray alloc]init];
        if (self.dataArr.count > 0) {
//            Vendor *vendor = self.dataArr[_currentIndexPath.row];
//            [arr addObject:vendor];
            [arr addObject:self.dataArr[_currentIndexPath.row]];
            self.choseVendor(arr);
        }
    }
    [self PopViewControllerAnimated:YES];

}
- (void)searchViewClickedDelegateBtn {
    if (_d_isMoreChoices) {
        [self.indexArr removeAllObjects];
    }else{
        _currentIndexPath = nil;
    }
    self.c_searchView.f_textFiled.text = @"";
    //_selectTextFiled.text = @"";
    [self.f_tableView reloadData];

}
#pragma mark - UITableViewDataSource 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataArr.count;
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return 50;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"MaskCell";
    MaskCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[MaskCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID totalWidth:self.view.width totalHeight:SEARCH_TABLECELL_HEIGHT];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.Commitbtn.hidden = YES;
    }
    if (_d_isMoreChoices) {
        if ([self hasIndexPath:indexPath]) {
            cell.Commitbtn.hidden = NO;
        }else{
            cell.Commitbtn.hidden = YES;
        }
    }else{
        if (_currentIndexPath) {
            if (indexPath.row == _currentIndexPath.row) {
                cell.Commitbtn.hidden = NO;
            }else{
                cell.Commitbtn.hidden = YES;
            }
        }else{
            cell.Commitbtn.hidden = YES;
        }
    }
    
    
    //cell的现实内容
    if (self.dataArr.count > 0) {
        NSString *proStr;
        if ([self.title isEqualToString:[IBTCommon localizableString:@"ProductTitle"]]) {
            Product *product = _dataArr[indexPath.row];
            proStr = [NSString stringWithFormat:@"%@[%@]",product.name,product.code];
        } else if ([self.title isEqualToString:[IBTCommon localizableString:@"VendorTitle"]]) {
            Vendor *vendor =  self.dataArr[indexPath.row];
            proStr = [NSString stringWithFormat:@"%@[%@]",vendor.name,vendor.code];
            
        } else if ([self.title isEqualToString:[IBTCommon localizableString:@"WarehouseTitle"]]) {
            
            Warehouse *warehouse = self.dataArr[indexPath.row];
            proStr = [NSString stringWithFormat:@"%@[%@]",warehouse.name,warehouse.code];
        } else {
            
        }


        [cell setTitleStr:proStr];
    }
    return cell;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    if (_d_isMoreChoices == YES) {
        MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
        cell.Commitbtn.hidden = NO;
        if (![self hasIndexPath:indexPath]) {
            [self.indexArr addObject:indexPath];
        }
        
        NSString *personStr = @"";
        for (NSIndexPath *index in self.indexArr) {
            Vendor *vendor = self.dataArr[index.row];
            if (personStr.length == 0) {
                personStr = [personStr stringByAppendingFormat:@"%@",vendor.name];
            }else{
                personStr = [personStr stringByAppendingFormat:@"、%@",vendor.name];
            }
        }
        self.c_searchView.f_textFiled.text = personStr;
       // _selectTextFiled.text = personStr;
    }else{
        MaskCell *currentCell = (MaskCell *)[tableView cellForRowAtIndexPath:_currentIndexPath];
        currentCell.Commitbtn.hidden = YES;
        MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
        cell.Commitbtn.hidden = NO;
        _currentIndexPath = indexPath;
        
        
        NSString *textStr;
        if ([self.title isEqualToString:[IBTCommon localizableString:@"ProductTitle"]]) {
            Product *product = self.dataArr[indexPath.row];
            textStr = product.name;
        } else if ([self.title isEqualToString:[IBTCommon localizableString:@"VendorTitle"]]) {
             Vendor *vendor = self.dataArr[indexPath.row];
            textStr = vendor.name;
        } else if ([self.title isEqualToString:[IBTCommon localizableString:@"WarehouseTitle"]]) {
            Warehouse *warehouse = self.dataArr[indexPath.row];
            textStr = warehouse .name;
        } else if ([self.title isEqualToString:[IBTCommon localizableString:@"ProductUnitTitle"]]) {
            GXFProductUnit *productunit = self.dataArr[indexPath.row];
            textStr = productunit.name;
        }else {
            
        }

       
        self.c_searchView.f_textFiled.text  = textStr;
        
        
    }
}
- (BOOL)hasIndexPath:(NSIndexPath *)indexPath{
    for (NSIndexPath *path in self.indexArr) {
        if (path.row == indexPath.row) {
            return YES;
        }
    }
    return NO;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}



@end
