//
//  JavenImages.m
//  XFFruit
//
//  Created by Jonathan on 16/3/3.
//  Copyright © 2016年 Xummer. All rights reserved.
//

#import "JavenImages.h"

@implementation JavenImages

static JavenImages *_instance;

+ (instancetype)shareInstance
{
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        _instance = [[JavenImages alloc] init];
        _instance.imageArr = [NSMutableArray array];
    });
    return _instance;
}

- (void)insertImages:(NSArray *)array {
    for (UIImage *image in array) {
        [_instance.imageArr addObject:image];
    }
    
}

- (void)insertAImage:(UIImage *)image {
    [_instance.imageArr addObject:image];
}

- (void)removeAllImage {
    [_instance.imageArr removeAllObjects];
}
@end
