//
//  SaleViewCell.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/8.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "SaleViewCell.h"

#define Sale_Cell_Height  50
#define Left_Width 115
#define Left_margin 0
@interface SaleViewCell ()
{
    BOOL    hasBuildLayout;         // default, NO;
}

@property (nonatomic, strong) UIFont *textFont;
@property (nonatomic, strong) UIFont *titleFont;

@property (nonatomic, strong) NSIndexPath *indexPath;

@end


@implementation SaleViewCell


+ (CGFloat)cellHeight
{
    return Sale_Cell_Height;
}

#pragma mark - build view

- (void)buildLayout
{
    if(hasBuildLayout) {
        return;
    }
    
    hasBuildLayout = YES;
    
    
    if(self.textFont == nil) {
        self.textFont = [UIFont systemFontOfSize:15];
    }
    
    if(self.titleFont == nil) {
        self.titleFont = [UIFont systemFontOfSize:17];
    }
    
    //页面布局
    [self createView];
}

//创建视图
- (void)createView
{

    CGRect rect = CGRectMake(Left_margin,0, Left_Width, Sale_Cell_Height);
    self.dqLabel = [IBTCommon labelWithTitle:@"0101第一片区" frame:rect textFont:self.textFont];
    self.dqLabel.textColor = ReportTitleColor;
    [self.contentView addSubview:self.dqLabel];
    
    CGFloat width = (ScreenSize.width - self.dqLabel.right - 35)/3;
    
    rect = CGRectMake(self.dqLabel.right , 0, width+10, Sale_Cell_Height);
    self.saleLabel = [IBTCommon labelWithTitle:@"56,080" frame:rect textFont:self.textFont];
    self.saleLabel.textAlignment = NSTextAlignmentCenter;
    [self.contentView addSubview:self.saleLabel];
    
    rect = CGRectMake(self.saleLabel.right, 0, width, Sale_Cell_Height);
    self.lastWeekLabel = [IBTCommon labelWithTitle:@"14.20%" frame:rect textFont:self.textFont];
    self.lastWeekLabel.textAlignment = NSTextAlignmentCenter;
    [self.contentView addSubview:self.lastWeekLabel];
    
    rect = CGRectMake(self.lastWeekLabel.right, 0, width-10, Sale_Cell_Height);
    self.rateLabel = [IBTCommon labelWithTitle:@"60%" frame:rect textFont:self.textFont];
    self.rateLabel.textColor = ReportTitleColor;
    self.rateLabel.textAlignment = NSTextAlignmentCenter;
    [self.contentView addSubview:self.rateLabel];

    rect = CGRectMake(self.rateLabel.right, 0, 35, Sale_Cell_Height);
    self.detailBtn = [IBTCommon buttonWithTitle:@"详" Image:nil frame:rect fontSize:20 fontColor:ReportColor];
    self.detailBtn.titleLabel.font = [UIFont boldSystemFontOfSize:15];
    [self.contentView addSubview:self.detailBtn];
    
    
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(0, Sale_Cell_Height - 1, ScreenSize.width, 1))];
    self.lineLabel.backgroundColor = [UIColor lightGrayColor];
    [self.contentView addSubview:self.lineLabel];
    
}


#pragma mark - update view

- (void)updateCellWith:(OrgCompass *)sale index:(NSIndexPath *)indexPath
{
    self.indexPath = indexPath;
    
    [self buildLayout];
    //组织name
    self.dqLabel.text = sale.orgname;
    //销售额
    self.saleLabel.text = sale.sales;
    //销售环比变化率
    if ([sale.salesChainSign isEqualToString:ReportChainSignPlus]) {
        self.lastWeekLabel.textColor = ReportContentColor;
    }else{
        self.lastWeekLabel.textColor = GXF_NAVIGAYION_COLOR;
    }
    NSString *salesYoStr = [NSString stringWithFormat:@"%@%%",sale.salesChainRate];
    self.lastWeekLabel.text = salesYoStr;
    //销售目标达成率
    NSString *salesTargetRateStr = [NSString stringWithFormat:@"%@%%",sale.salesTargetRate];
    self.rateLabel.text = salesTargetRateStr;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
