//
//  RSaleView.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/13.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "RSaleView.h"
#define LeftWidth   50
#define ImageSize 20
#define ContentHeight 30

@interface RSaleView ()
@property (nonatomic,strong)UILabel *centerLabel;
@property (nonatomic,strong)UILabel *dateLabel;
@property (nonatomic,strong)UIButton *lastWeekLabel;
@property (nonatomic,strong)UIButton *lastYearLabel;
@property (nonatomic,strong)UILabel *rateLabel;
@property (nonatomic,strong)UILabel *averageLabel;
@property (nonatomic,strong)UIImageView *lastWeekImage;
@property (nonatomic,strong)UIImageView *lastYearImage;



@end



@implementation RSaleView

- (instancetype)initWithFrame:(CGRect)frame{
    self = [super initWithFrame:frame];
    if (self) {
        [self bulidLayout];
    }
    return self;
}
- (void)bulidLayout{
    
    CGRect rect = CGRectMake(0, 30, LeftWidth, 20);
  
    rect = CGRectMake(LeftWidth, 20, ScreenSize.width - LeftWidth*2 , ContentHeight);
    self.centerLabel = [[UILabel alloc]initWithFrame:rect];
    self.centerLabel.textAlignment = NSTextAlignmentCenter;
    [self addSubview:self.centerLabel];

    
    rect = CGRectMake(0, self.centerLabel.bottom,self.width, 20);
    self.dateLabel = [[UILabel alloc]initWithFrame:rect];
    self.dateLabel.textColor = GXF_CONTENT_COLOR;
    self.dateLabel.font =  GXF_FOURTEENTH_SIZE;
    self.dateLabel.textAlignment = NSTextAlignmentCenter;
    [self addSubview:self.dateLabel];
    
    CGFloat bottomWidth = (ScreenSize.width - 20)/4;
    
    rect = CGRectMake(10, self.dateLabel.bottom + 5,bottomWidth, ContentHeight);
    self.lastWeekLabel = [IBTCommon buttonWithTitle:@"" Image:nil frame:rect fontSize:15 fontColor:ReportContentColor];
    [self addSubview:self.lastWeekLabel];
    
    rect = CGRectMake(self.lastWeekLabel.left, self.lastWeekLabel.bottom,bottomWidth,20);
    UILabel *weekLabel = [[UILabel alloc]initWithFrame:rect];
    weekLabel.textColor = [UIColor lightGrayColor];
    weekLabel.text = @"比上周同期";
    weekLabel.font = GXF_THREETEENTH_SIZE;
    weekLabel.textAlignment = NSTextAlignmentCenter;
    [self addSubview:weekLabel];
    
    rect = CGRectMake(self.lastWeekLabel.right, self.lastWeekLabel.top,bottomWidth, ContentHeight);
     self.lastYearLabel = [IBTCommon buttonWithTitle:@"" Image:nil frame:rect fontSize:15 fontColor:GXF_NAVIGAYION_COLOR];
    [self addSubview:self.lastYearLabel];

    
    rect = CGRectMake(self.lastYearLabel.left, self.lastWeekLabel.bottom,bottomWidth,20);
    UILabel *yearLabel = [[UILabel alloc]initWithFrame:rect];
    yearLabel.textColor = [UIColor lightGrayColor];
    yearLabel.text = @"比去年同期";
    yearLabel.font = GXF_THREETEENTH_SIZE;
    yearLabel.textAlignment = NSTextAlignmentCenter;
    [self addSubview:yearLabel];
    
    rect = CGRectMake(self.lastYearLabel.right,self.lastWeekLabel.top,bottomWidth, ContentHeight);
    self.rateLabel = [[UILabel alloc]initWithFrame:rect];
    self.rateLabel.textColor = ReportColor;
    self.rateLabel.font =  GXF_FIFTEENTEN_SIZE;

    self.rateLabel.textAlignment = NSTextAlignmentCenter;
    [self addSubview:self.rateLabel];
    
    rect = CGRectMake(self.rateLabel.left, self.lastWeekLabel.bottom,bottomWidth,20);
    UILabel *raLabel = [[UILabel alloc]initWithFrame:rect];
    raLabel.textColor = [UIColor lightGrayColor];
    raLabel.text = @"销售达成率";
    raLabel.font = GXF_THREETEENTH_SIZE;
    raLabel.textAlignment = NSTextAlignmentCenter;
    [self addSubview:raLabel];
    
    rect = CGRectMake(self.rateLabel.right, self.lastWeekLabel.top,bottomWidth, ContentHeight);
    self.averageLabel = [[UILabel alloc]initWithFrame:rect];
    self.averageLabel.textColor = ReportColor;
    self.averageLabel.font =  GXF_FIFTEENTEN_SIZE;

    self.averageLabel.textAlignment = NSTextAlignmentCenter;
    [self addSubview:self.averageLabel];
    
    rect = CGRectMake(self.averageLabel.left, self.lastWeekLabel.bottom,bottomWidth,20);
    UILabel *avLabel = [[UILabel alloc]initWithFrame:rect];
    avLabel.textColor = [UIColor lightGrayColor];
    avLabel.text = @"单店日均";
    avLabel.font = GXF_THREETEENTH_SIZE;
    avLabel.textAlignment = NSTextAlignmentCenter;
    [self addSubview:avLabel];

}

- (void)setValueInSaleView:(Compass *)compass{
    //统计时间
    self.dateLabel.text = [NSString stringWithFormat:@"%@累计销售额",compass.dateScope];
    //销售额
    NSMutableAttributedString *attributeStr1 = [IBTCommon setTextViewBoldFontOfString:@"$  " paragraphStyle:8 fontSize:20 color:ReportColor];
    [attributeStr1 appendAttributedString:[IBTCommon setTextViewBoldFontOfString:compass.sales paragraphStyle:8 fontSize:30 color:ReportContentColor]];
    self.centerLabel.attributedText = attributeStr1;
    //销售环比变化率
    if ([compass.salesChainSign isEqualToString:ReportChainSignPlus]) {
        [self.lastWeekLabel setImage:[UIImage imageNamed:ReportChainPlusImage] forState:UIControlStateNormal];
    }else{
        [self.lastWeekLabel setImage:[UIImage imageNamed:ReportChainMinusImage] forState:UIControlStateNormal];
    }
    NSString *salesChainRateStr = [NSString stringWithFormat:@"%@%%",compass.salesChainRate];
    [self.lastWeekLabel setTitle:salesChainRateStr forState:UIControlStateNormal];
    //销售同比变化率
    if ([compass.salesYoYSign isEqualToString:ReportChainSignPlus]) {
        [self.lastYearLabel setImage:[UIImage imageNamed:ReportChainPlusImage] forState:UIControlStateNormal];
    }else{
        [self.lastYearLabel setImage:[UIImage imageNamed:ReportChainMinusImage] forState:UIControlStateNormal];
    }
    NSString *salesYoStr = [NSString stringWithFormat:@"%@%%",compass.salesYoYRate];
    [self.lastYearLabel setTitle:salesYoStr forState:UIControlStateNormal];
    //销售目标达成率
    NSString *salesTargetStr = [NSString stringWithFormat:@"%@%%",compass.salesTargetRate];
    self.rateLabel.text = salesTargetStr;
    //单店日均销售
    NSString *dailysalesPerStr = [NSString stringWithFormat:@"%@%%",compass.dailysalesPerStore];
    self.averageLabel.text = dailysalesPerStr;
    
}

@end
