//
//  RPassgerView.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/13.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "RPassgerView.h"
#define LeftWidth   50
#define ImageSize 20
#define ContentHeight 30
#define TopWidth 200
@interface RPassgerView ()

@end
@implementation RPassgerView
- (instancetype)initWithFrame:(CGRect)frame{
    self = [super initWithFrame:frame];
    if (self) {
        [self bulidLayout];
    }
    return self;
}
- (void)bulidLayout{
    
    CGRect rect = CGRectMake((ScreenSize.width - TopWidth)/2,20, TopWidth, ContentHeight);
    self.centerLabel = [IBTCommon buttonWithTitle:@"" Image:nil frame:rect fontSize:15 fontColor:ReportContentColor];
    self.centerLabel.enabled = NO;
    self.centerLabel.titleLabel.font = [UIFont boldSystemFontOfSize:30];
    [self addSubview:self.centerLabel];
    
    
    rect = CGRectMake(0, self.centerLabel.bottom,ScreenSize.width, 20);
    self.dateLabel = [[UILabel alloc]initWithFrame:rect];
    self.dateLabel.textColor = GXF_CONTENT_COLOR;
    self.dateLabel.font =  GXF_FOURTEENTH_SIZE;
    self.dateLabel.textAlignment = NSTextAlignmentCenter;
    self.dateLabel.text = @"";
    [self addSubview:self.dateLabel];
    
    CGFloat bottomWidth = (ScreenSize.width - 20*2)/2;
    
    rect = CGRectMake(20, self.dateLabel.bottom,bottomWidth, ContentHeight);
    self.lastWeekLabel = [IBTCommon buttonWithTitle:@"" Image:nil frame:rect fontSize:15 fontColor:ReportContentColor];
    self.lastWeekLabel.enabled = NO;
    [self addSubview:self.lastWeekLabel];
    
    
    rect = CGRectMake(self.lastWeekLabel.left, self.lastWeekLabel.bottom,bottomWidth,20);
    UILabel *weekLabel = [[UILabel alloc]initWithFrame:rect];
    weekLabel.textColor = [UIColor lightGrayColor];
    weekLabel.text = @"比上周同期";
    weekLabel.textAlignment = NSTextAlignmentCenter;
    weekLabel.font = GXF_THREETEENTH_SIZE;
    [self addSubview:weekLabel];
    
    
    
    
    
    rect = CGRectMake(self.lastWeekLabel.right,self.dateLabel.bottom,bottomWidth, ContentHeight);
    self.lastYearLabel = [IBTCommon buttonWithTitle:@"" Image:nil frame:rect fontSize:15 fontColor:GXF_NAVIGAYION_COLOR];
    self.lastYearLabel.enabled = NO;
    [self addSubview:self.lastYearLabel];
    
    
    rect = CGRectMake(self.lastWeekLabel.right, self.lastYearLabel.bottom,bottomWidth,20);
    UILabel *yearLabel = [[UILabel alloc]initWithFrame:rect];
    yearLabel.textColor = [UIColor lightGrayColor];
    yearLabel.textAlignment = NSTextAlignmentCenter;
    yearLabel.text = @"比去年同期";
    yearLabel.font = GXF_THREETEENTH_SIZE;
    [self addSubview:yearLabel];
}


//客流
- (void)setPassengerWithCompass:(Compass *)compass{
    //客流数
    [self.centerLabel setImage:[UIImage imageNamed:@"goSale"] forState:UIControlStateDisabled];
    [self.centerLabel setTitle:compass.passenger forState:UIControlStateNormal];
    //客流统计时间
    self.dateLabel.text = [NSString stringWithFormat:@"%@累计客流量",compass.passengerdate];
    //客流数环比变化率
    if ([compass.passengerChainSign isEqualToString:ReportChainSignPlus]) {
        [self.lastWeekLabel setImage:[UIImage imageNamed:ReportChainPlusImage] forState:UIControlStateDisabled];
    }else{
        [self.lastWeekLabel setImage:[UIImage imageNamed:ReportChainMinusImage] forState:UIControlStateDisabled];
    }
    NSString *salesYoStr = [NSString stringWithFormat:@"%@%%",compass.passengerChainRate];
    [self.lastWeekLabel setTitle:salesYoStr forState:UIControlStateNormal];

    //客流数同比变化率
    if ([compass.passengerYoYSign isEqualToString:ReportChainSignPlus]) {
        [self.lastYearLabel setImage:[UIImage imageNamed:ReportChainPlusImage] forState:UIControlStateNormal];
    }else{
        [self.lastYearLabel setImage:[UIImage imageNamed:ReportChainMinusImage] forState:UIControlStateNormal];
    }
    NSString *passengerYoYRateStr = [NSString stringWithFormat:@"%@%%",compass.passengerYoYRate];
    [self.lastYearLabel setTitle:passengerYoYRateStr forState:UIControlStateNormal];
}
//客单价
- (void)setPersalesWithCompass:(Compass *)compass{
    //客单价
    [self.centerLabel setImage:[UIImage imageNamed:@"goSale"] forState:UIControlStateDisabled];
    [self.centerLabel setTitle:compass.persales forState:UIControlStateNormal];
    //客单价统计时间
    self.dateLabel.text = [NSString stringWithFormat:@"%@累计客流量",compass.persalesdate];
    //客单价环比变化率
    if ([compass.persalesChainSign isEqualToString:ReportChainSignPlus]) {
        [self.lastWeekLabel setImage:[UIImage imageNamed:ReportChainPlusImage] forState:UIControlStateDisabled];
    }else{
        [self.lastWeekLabel setImage:[UIImage imageNamed:ReportChainMinusImage] forState:UIControlStateDisabled];
    }
    NSString *salesYoStr = [NSString stringWithFormat:@"%@%%",compass.persalesChainRate];
    [self.lastWeekLabel setTitle:salesYoStr forState:UIControlStateNormal];
    
    //客单价同比变化率
    if ([compass.persalesYoYSign isEqualToString:ReportChainSignPlus]) {
        [self.lastYearLabel setImage:[UIImage imageNamed:ReportChainPlusImage] forState:UIControlStateDisabled];
    }else{
        [self.lastYearLabel setImage:[UIImage imageNamed:ReportChainMinusImage] forState:UIControlStateDisabled];
    }
    NSString *passengerYoYRateStr = [NSString stringWithFormat:@"%@%%",compass.persalesYoYRate];
    [self.lastYearLabel setTitle:passengerYoYRateStr forState:UIControlStateNormal];
}
//毛利率
- (void)setGrossprofitWithCompass:(Compass *)compass{
    //毛利率
    [self.centerLabel setImage:[UIImage imageNamed:@"goSale"] forState:UIControlStateDisabled];
    [self.centerLabel setTitle:compass.persales forState:UIControlStateNormal];
    //毛利率统计时间
    self.dateLabel.text = [NSString stringWithFormat:@"%@累计客流量",compass.persalesdate];
    //毛利率环比变化率
    if ([compass.grossprofitChainSign isEqualToString:ReportChainSignPlus]) {
        [self.lastWeekLabel setImage:[UIImage imageNamed:ReportChainPlusImage] forState:UIControlStateDisabled];
    }else{
        [self.lastWeekLabel setImage:[UIImage imageNamed:ReportChainMinusImage] forState:UIControlStateDisabled];
    }
    NSString *salesYoStr = [NSString stringWithFormat:@"%@%%",compass.grossprofitChainRate];
    [self.lastWeekLabel setTitle:salesYoStr forState:UIControlStateNormal];
    
    //毛利率同比变化率
    if ([compass.grossprofitYoYSign isEqualToString:ReportChainSignPlus]) {
        [self.lastYearLabel setImage:[UIImage imageNamed:ReportChainPlusImage] forState:UIControlStateDisabled];
    }else{
        [self.lastYearLabel setImage:[UIImage imageNamed:ReportChainMinusImage] forState:UIControlStateDisabled];
    }
    NSString *passengerYoYRateStr = [NSString stringWithFormat:@"%@%%",compass.grossprofitYoYRate];
    [self.lastYearLabel setTitle:passengerYoYRateStr forState:UIControlStateNormal];
}


@end
