//
//  PassengerHeaderCell.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/8.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "PassengerHeaderCell.h"


#define Sale_Header_Height 30

@interface PassengerHeaderCell ()
{
    BOOL    hasBuildLayout;         // default, NO;
}

@property (nonatomic, strong) UILabel *label;
@property (nonatomic, strong) UILabel *searchLabel;

@property (nonatomic, strong) UIFont *textFont;


@end


@implementation PassengerHeaderCell


+ (CGFloat)viewHeight
{
    return Sale_Header_Height;
}

- (void)buildLayout:(NSString *)titleStr
{
    if(hasBuildLayout) {
        return;
    }
    
    if(self.textFont == nil) {
        self.textFont = [UIFont systemFontOfSize:13];
    }
    
    hasBuildLayout = YES;
    self.contentView.backgroundColor = ReportTableHeaderColor;
    
    CGRect rect = CGRectMake(10, 0, 150, Sale_Header_Height);
    UILabel *searLabel = [IBTCommon labelWithTitle:@"" frame:rect textFont:self.textFont];
    searLabel.textColor = ReportTitleColor;
    [self.contentView addSubview:searLabel];
    self.searchLabel = searLabel;

    
    
    CGFloat width = (ScreenSize.width  - searLabel.right - 35)/2;
    
    rect = CGRectMake(self.searchLabel.right, 0, width, Sale_Header_Height);
    UILabel * ksjLabel = [IBTCommon labelWithTitle:titleStr frame:rect textFont:self.textFont];
    ksjLabel.textColor = ReportTitleColor;
    ksjLabel.textAlignment = NSTextAlignmentCenter;
    [self.contentView addSubview:ksjLabel];
    
    
    rect = CGRectMake(ksjLabel.right , 0, width, Sale_Header_Height);
    UILabel * bszLabel = [IBTCommon labelWithTitle:@"比上周" frame:rect textFont:self.textFont];
    bszLabel.textColor = ReportTitleColor;
    bszLabel.textAlignment = NSTextAlignmentCenter;
    [self.contentView addSubview:bszLabel];
}

- (void)setTotalValue:(NSString *)totalValue{
    self.searchLabel.text = totalValue;
}
@end
