//
//  SearchReportViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/17.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "SearchReportViewController.h"
#import "RsearchCell.h"
#import "ReportDetailViewController.h"
@interface SearchReportViewController ()<UITextFieldDelegate,UITableViewDataSource,UITableViewDelegate>
@property (nonatomic,strong)UITextField *selectTextFiled;
@property (nonatomic,strong)UITableView *tableView;
@property (nonatomic,strong)NSMutableArray *dataArr;

@end

@implementation SearchReportViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"搜索组织";
    self.view.backgroundColor = [UIColor whiteColor];
    self.dataArr = [NSMutableArray array];
    
    
    self.selectTextFiled = [[UITextField alloc] initWithFrame:CGRectMake(20,5,ScreenSize.width - 100, 30)];
    self.selectTextFiled.textAlignment = NSTextAlignmentLeft;
    self.selectTextFiled.background = [UIImage imageNamed:@"textFiled"];
    self.selectTextFiled.delegate = self;
    self.selectTextFiled.placeholder = @"输入门店或者区域、代码查询";
    self.selectTextFiled.font = GXF_THREETEENTH_SIZE;
    [self.view addSubview:self.selectTextFiled];
    
    
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    btn.frame = CGRectMake(self.selectTextFiled.right + 5,7, 60, 25);
    [btn setTitle:@"开始查询" forState:UIControlStateNormal];
    btn.titleLabel.font = FontSize(13);
    btn.layer.cornerRadius = 5;
    btn.layer.masksToBounds = YES;
    btn.backgroundColor = ReportColor;
    [btn addTarget:self action:@selector(checkWithBillNumber) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:btn];
    
    CGRect rect = CGRectMake(0, 50, ScreenSize.width, ScreenSize.height - 163);
    self.tableView = [[UITableView alloc]initWithFrame:rect style:UITableViewStylePlain];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self.view addSubview:self.tableView];
    
}


#pragma mark - tableViewDelegate
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView{
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section{
    return 2;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    static NSString *cellID = @"SearchCell";
    
    RsearchCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if(cell == nil) {
        cell = [[RsearchCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
    }
    //没有选中风格
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    //取消分割线
    tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
  
    return cell;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    ReportDetailViewController *rvc = [ReportDetailViewController new];
    rvc.title = @"陆金所";
    [self PushViewController:rvc animated:YES];
}


- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return [RsearchCell cellHeight];
}
- (void)checkWithBillNumber{
    
}



- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
