//
//  SaleViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/6.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "SaleViewController.h"
#import "SMPageControl.h"
#import "SaleViewCell.h"
#import "SaleHeaderView.h"
#import "ReportDetailViewController.h"
#import "RSaleView.h"
#import "OrgCompass.h"
static NSString *saleCellIdentify = @"saleCellIdentify";
static NSString *saleHeaderIdentify = @"saleHeaderIdentify";


@interface SaleViewController ()<UITableViewDataSource,UITableViewDelegate>
@property (nonatomic,strong)SMPageControl *pageControl;
@property (nonatomic,strong)RSaleView *rsaleView;

@property (nonatomic,strong)UIView *bgView;



@property (nonatomic,strong)NSIndexPath *currentIndex;
@end

@implementation SaleViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self initData];
    [self bulidLayout];
}
#pragma mark - 初始化数据
- (void)initData{
    if(!self.dataArr){
        self.dataArr = [NSMutableArray array];
    }
}

#pragma mark - 布局
- (void)bulidLayout{
    
    self.view .backgroundColor = [UIColor whiteColor];
    
    CGRect rect = CGRectMake(0, 0, ScreenSize.width, 145);
    self.bgView = [[UIView alloc]initWithFrame:rect];
    
    
    rect = CGRectMake(0, 0, ScreenSize.width, 130);
    self.rsaleView = [[RSaleView alloc]initWithFrame:rect];
    [self.bgView addSubview:self.rsaleView];
    
    self.pageControl = [[SMPageControl alloc]initWithFrame:CGRectMake(0, self.rsaleView.bottom, self.view.width, 10)];
    self.pageControl.currentPage = 0;
    self.pageControl.pageIndicatorTintColor = XXFBgColor;
    self.pageControl.currentPageIndicatorTintColor = ReportColor;
    self.pageControl.numberOfPages = 4;
    self.pageControl.indicatorMargin = 15.0f;
    
    self.pageControl.indicatorDiameter = 10.0f;
    [self.bgView addSubview:self.pageControl];
    
    CLog(@"%f---------",self.view.height);

    
    rect = CGRectMake(0, 0, self.view.width, self.view.height- 158);
    self.tableView = [[UITableView alloc]initWithFrame:rect style:UITableViewStylePlain];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self.tableView registerClass:[SaleViewCell class] forCellReuseIdentifier:saleCellIdentify];
    [self.tableView registerClass:[SaleHeaderView class] forHeaderFooterViewReuseIdentifier:saleHeaderIdentify];
    self.tableView.tableHeaderView = self.bgView;

    [self.view addSubview:self.tableView];

}
- (void)setValueInSale:(Compass *)compass{
    [self.rsaleView setValueInSaleView:compass];
}

#pragma mark - tableViewDelegate
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView{
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section{
    return self.dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
     SaleViewCell *cell = (SaleViewCell *)[tableView dequeueReusableCellWithIdentifier:saleCellIdentify forIndexPath:indexPath];
    
    if(cell == nil) {
        cell = [[SaleViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:saleCellIdentify];
    }
    //没有选中风格
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    //取消分割线
    tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    
    OrgCompass *test = _dataArr[indexPath.row];
    if (test.level == 0) {
        cell.dqLabel.textColor = ReportTitleColor;
        cell.dqLabel.font = GXF_FOURTEENTH_SIZE;
         cell.lineLabel.hidden = NO;
    }else if(test.level == 1)
    {
        cell.dqLabel.textColor = [UIColor blackColor];
        cell.dqLabel.font = GXF_THREETEENTH_SIZE;
        cell.lineLabel.hidden = NO;
    }else {
        cell.lineLabel.hidden = YES;
        cell.dqLabel.textColor = [UIColor lightGrayColor];
        cell.dqLabel.font = GXF_TWELVETEEN_SIZE;

    }
    if(test != nil) {
        [cell updateCellWith:test index:indexPath];
    }
    cell.detailBtn.tag = indexPath.row;
    [cell.detailBtn addTarget:self action:@selector(detailClick:) forControlEvents:UIControlEventTouchUpInside];
    
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return [SaleViewCell cellHeight];
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    [[NSNotificationCenter defaultCenter]postNotificationName:KNOTIFICATION_GetNextDetailData object:nil userInfo:@{@"indexPath":indexPath}];
}


- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    SaleHeaderView *headerView = [tableView dequeueReusableHeaderFooterViewWithIdentifier:saleHeaderIdentify];
    
    if (headerView == nil) {
        headerView = [[SaleHeaderView alloc] initWithReuseIdentifier:saleHeaderIdentify];
    }
    [headerView buildLayout];
    headerView.totalLabel.text = [NSString stringWithFormat:@"共%ld家",(long)self.count];
    return headerView;
}


- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return [SaleHeaderView viewHeight];
}

- (void)detailClick:(UIButton *)btn{
    ReportDetailViewController *rvc = [ReportDetailViewController new];
    rvc.title = @"陆金所";
    [self PushViewController:rvc animated:YES];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

@end
