//
//  ReportDetailViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/11.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "ReportDetailViewController.h"
#import "CustomSegView.h"
#import "RSaleView.h"

#import "FinishTimeView.h"
@interface ReportDetailViewController ()<CustomSegViewDelegate,FinishTimeViewDelegate>
@property (nonatomic,strong)CustomSegView *segView;
@property (nonatomic,strong)RSaleView *rsaleView;
@property (nonatomic,strong)UIWebView *webView;
@property (nonatomic,strong)FinishTimeView *startTimeView;
@property (nonatomic,strong)NSString *scopeType;
@property (nonatomic,strong)NSString *selectDay;
@property (nonatomic,strong)NSString *selectMonth;
@property (nonatomic,strong)NSString *selectWeek;

@end

@implementation ReportDetailViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self bulidLayout];
}

#pragma mark - 布局
- (void)bulidLayout{
    self.view .backgroundColor = [UIColor whiteColor];
    CGRect rect = CGRectMake(10, 10, ScreenSize.width - 10*2, 30);
    NSArray *arr = @[SaleDay,SaleWeek,SaleMonth];
    self.segView = [[CustomSegView alloc]initWithFrame:rect withArr:arr];
    self.segView.delegate = self;
    [self.view addSubview:self.segView];
    
    rect = CGRectMake(0, self.segView.bottom, ScreenSize.width, 130);
    self.rsaleView = [[RSaleView alloc]initWithFrame:rect];
    [self.view addSubview:self.rsaleView];
    
    rect = CGRectMake(0, self.rsaleView.bottom, ScreenSize.width, ScreenSize.height - self.rsaleView.bottom - 64);
   
    self.webView = [[UIWebView alloc]initWithFrame:rect];
    self.webView.scrollView.backgroundColor = [UIColor redColor];
    [self.view addSubview:self.webView];
    
}



#pragma mark -CustomSegViewDelegate
- (void)customSegOneClick:(NSString *)title{
    //日周年切换
    NSString *dayType = @"";
    if ([title isEqualToString:SaleDay]) {
        dayType = @"day";
        self.scopeType = [IBTCommon stringFromDateWithFormat:[NSDate date] format:@"yyyy-MM-dd"];
    }else if ([title isEqualToString:SaleWeek]) {
        dayType = @"week";
        self.scopeType = [IBTCommon getWeekFromDate];
    }else if ([title isEqualToString:SaleMonth]) {
        dayType = @"month";
        self.scopeType = [IBTCommon stringFromDateWithFormat:[NSDate date] format:@"yyyy-MM"];
    }
    CLog(@"-------%@",self.scopeType);
//    self.dayType = dayType;
//    [self getDataFromServer];
}
- (void)customSegTwoClick:(NSString *)title{
    //选择历史查看
    if ([title isEqualToString:SaleDay]) {
        [self startDatePickView:SaleEnDay];
    }else if ([title isEqualToString:SaleWeek]) {
        [self startDatePickView:SaleEnWeek];
    }else if ([title isEqualToString:SaleMonth]) {
        [self startDatePickView:SaleEnMonth];
    }
}

- (void)startDatePickView:(NSString *)type{
    if (!self.startTimeView) {
        
        NSString *currentStr  = @"";
        if ([type isEqualToString:SaleEnDay]) {
            if (self.selectDay) {
                currentStr =  self.selectDay;
            }else{
                currentStr = [IBTCommon stringFromDateWithFormat:[NSDate date] format:@"yyyy-MM-dd"];
            }
            
        }else if([type isEqualToString:SaleEnMonth]){
            if (self.selectMonth) {
                currentStr =  self.selectMonth;
            }else{
                currentStr = [IBTCommon stringFromDateWithFormat:[NSDate date] format:@"yyyy-MM"];
            }
        }else{
            if (self.selectWeek) {
                currentStr =  self.selectWeek;
            }else{
                currentStr = [IBTCommon getWeekFromDate];
            }
        }
        
        self.startTimeView = [[FinishTimeView alloc] initWithFrame:CGRectMake(0, ScreenSize.height, ScreenSize.width, ScreenSize.height - 64) withDate:currentStr type:type];
        self.startTimeView.delegate = self;
        self.startTimeView.backgroundColor        = RGBA(0, 0, 0 ,0.5);
        [AppWindow addSubview:self.startTimeView];
        
        [UIView animateWithDuration:0.15 animations:^{
            CGRect startFrame =  self.startTimeView.frame;
            startFrame.origin.y =  64;
            self.startTimeView.frame = startFrame;
        } completion:^(BOOL finished) {
            
        }];
    }
}
- (void)cancelTimeView{
    [self clearDatePickView];
}
- (void)okTimeView:(NSString *)time withType:(NSString *)type{
    CLog(@"--------%@",time);
    // 关闭选择器
    [self clearDatePickView];
    if ([type isEqualToString:SaleEnDay]) {
        self.selectDay = time;
    }else if ([type isEqualToString:SaleEnWeek]) {
        self.selectWeek = time;
    }else if ([type isEqualToString:SaleEnMonth]) {
        self.selectMonth = time;
    }
    
    self.scopeType = time;
#warning 需要修改的
    //[self getDataFromServer];
}
#pragma mark - 取消
- (void)clearDatePickView{
    [UIView animateWithDuration:0.15 animations:^{
        CGRect startFrame =  self.startTimeView.frame;
        startFrame.origin.y = ScreenSize.height;
        self.startTimeView.frame = startFrame;
    } completion:^(BOOL finished) {
        [self.startTimeView removeFromSuperview];
        self.startTimeView = nil;
    }];
}



- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
