//
//  PassengerViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/8.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "PassengerViewController.h"
#import "RPassgerView.h"
#import "SMPageControl.h"
#import "PasengerCell.h"
#import "PassengerHeaderCell.h"
#import "ReportDetailViewController.h"
#define LeftWidth   50

static NSString *passengerHeaderIdentify = @"PassengerHeaderIdentify";


@interface PassengerViewController ()<UITableViewDataSource,UITableViewDelegate>
@property (nonatomic,strong)SMPageControl *pageControl;
@property (nonatomic,strong)UIView *bgView;
@property (nonatomic,strong)RPassgerView *rpassgerView;




@end

@implementation PassengerViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self bulidLayout];
}


#pragma mark - 布局
- (void)bulidLayout{
    self.view .backgroundColor = [UIColor whiteColor];
    CGRect rect = CGRectMake(0, 0, ScreenSize.width, 145);
    self.bgView = [[UIView alloc]initWithFrame:rect];
    
    rect = CGRectMake(0, 0, ScreenSize.width, 130);
    self.rpassgerView = [[RPassgerView alloc]initWithFrame:rect];
    [self.bgView addSubview:self.rpassgerView];
    
    self.pageControl = [[SMPageControl alloc]initWithFrame:CGRectMake(0, self.rpassgerView.bottom, self.view.width, 10)];
    self.pageControl.numberOfPages = 4;

    self.pageControl.currentPage = 1;
    self.pageControl.pageIndicatorTintColor = XXFBgColor;
    self.pageControl.currentPageIndicatorTintColor = ReportColor;
    self.pageControl.indicatorMargin = 15.0f;
    self.pageControl.indicatorDiameter = 10.0f;
    [self.bgView addSubview:self.pageControl];
    
    rect = CGRectMake(0, 0, self.view.width, self.view.height- 158);
    self.tableView = [[UITableView alloc]initWithFrame:rect style:UITableViewStylePlain];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self.tableView registerClass:[PassengerHeaderCell class] forHeaderFooterViewReuseIdentifier:passengerHeaderIdentify];
    self.tableView.tableHeaderView = self.bgView;
    
    [self.view addSubview:self.tableView];
    
}
- (void)setValueInPassenger:(Compass *)compass{
    [self.rpassgerView setPassengerWithCompass:compass];
}


#pragma mark - tableViewDelegate
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView{
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section{
    return self.dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    
    static NSString *passengerCellIdentify = @"PassengerCellIdentify";

    PasengerCell *cell = [tableView dequeueReusableCellWithIdentifier:passengerCellIdentify];
    
    if(cell == nil) {
        cell = [[PasengerCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:passengerCellIdentify];
    }
    //没有选中风格
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    //取消分割线
    tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    
    OrgCompass *test = _dataArr[indexPath.row];
    if (test.level == 0) {
        cell.dqLabel.textColor = ReportTitleColor;
        cell.dqLabel.font = GXF_FIFTEENTEN_SIZE;
        cell.lineLabel.hidden = NO;
    }else if(test.level == 1)
    {
        cell.dqLabel.textColor = [UIColor blackColor];
        cell.dqLabel.font = GXF_FOURTEENTH_SIZE;
        cell.lineLabel.hidden = NO;
    }else {
        cell.lineLabel.hidden = YES;
        cell.dqLabel.textColor = [UIColor lightGrayColor];
        cell.dqLabel.font = GXF_THREETEENTH_SIZE;
        
    }
    if(test != nil) {
        [cell updateCellWithFlow:test index:indexPath];
    }
    cell.detailBtn.tag = indexPath.row;
    [cell.detailBtn addTarget:self action:@selector(detailClick:) forControlEvents:UIControlEventTouchUpInside];
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return [PasengerCell cellHeight];
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    [[NSNotificationCenter defaultCenter]postNotificationName:KNOTIFICATION_GetNextDetailData object:nil userInfo:@{@"indexPath":indexPath}];
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    PassengerHeaderCell *headerView = [tableView dequeueReusableHeaderFooterViewWithIdentifier:passengerHeaderIdentify];
    
    if (headerView == nil) {
        headerView = [[PassengerHeaderCell alloc] initWithReuseIdentifier:passengerHeaderIdentify];
    }
    
    [headerView buildLayout:@"客流"];
    [headerView setTotalValue:[NSString stringWithFormat:@"共%ld家",(long)self.count]];
    return headerView;
}
- (void)detailClick:(UIButton *)btn{
    ReportDetailViewController *rvc = [ReportDetailViewController new];
    rvc.title = @"陆金所";
    [self PushViewController:rvc animated:YES];
}


- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return [PassengerHeaderCell viewHeight];
}



- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
