//
//  PurchaseCell.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/23.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "GXFProcessCell.h"
#define TitleSize 16
#define ContentSize 14
#define LeftMargin 90
#define TopMargin 10
#define TitleHeight 20
#define TableHeight 120

@implementation  GXFProcessCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout
{
    self.stateBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    self.stateBtn.frame = CGRectMake(TopMargin *2 , TopMargin, LeftMargin - TopMargin*3, 20);
    self.stateBtn.titleLabel.font = FontSize(ContentSize);
    [self.stateBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    self.stateBtn.enabled = NO;
    
    self.billNumberLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, TopMargin, ScreenSize.width - LeftMargin, TitleHeight))];
    self.billNumberLabel.textColor = GXF_CONTENT_COLOR;
    self.billNumberLabel.font = FontSize(TitleSize);
    
    self.titleLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, CGRectGetMaxY(self.billNumberLabel.frame), ScreenSize.width - LeftMargin, TitleHeight*2))];
    self.titleLabel.numberOfLines = 0;
    self.titleLabel.textColor = GXF_CELL_COLOR;
    self.titleLabel.font = FontSize(ContentSize);
    
    self.createOperNameLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, CGRectGetMaxY(self.titleLabel.frame), ScreenSize.width - LeftMargin, TitleHeight))];
    self.createOperNameLabel.textColor = GXF_CELL_COLOR;
    self.createOperNameLabel.font = FontSize(ContentSize);
    
    
    self.createTimeLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, CGRectGetMaxY(self.createOperNameLabel.frame), ScreenSize.width - LeftMargin, TitleHeight))];
    self.createTimeLabel.textColor = GXF_CELL_COLOR;
    self.createTimeLabel.font = FontSize(ContentSize);
    
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin,TableHeight-1, ScreenSize.width - LeftMargin - TopMargin * 2, 1))];;
    self.lineLabel.backgroundColor = GXF_LINE_COLOR;
    
    [self.contentView addSubview:self.stateBtn];
    [self.contentView addSubview:self.billNumberLabel];
    [self.contentView addSubview:self.titleLabel];
    [self.contentView addSubview:self.createOperNameLabel];
    [self.contentView addSubview:self.createTimeLabel];
    [self.contentView addSubview:self.lineLabel];
    
}

- (void)setProcessBill:(GXFProcessBill *)processBill{
    self.billNumberLabel.text = [NSString stringWithFormat:@"单号：%@",processBill.billNumber];
    self.titleLabel.text = [NSString stringWithFormat:@"标题：%@",processBill.title];
    self.createOperNameLabel.text = [NSString stringWithFormat:@"创建人：%@",processBill.create_operName] ;
    self.createTimeLabel.text =[NSString stringWithFormat:@"创建时间：%@",processBill.create_time];
    NSString *stateStr = @"";
    if ([processBill.state isEqualToString:PROCESS_STATE_PROCESSINF]) {
        stateStr = @"进行中";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"insurvey"]  forState:UIControlStateDisabled];
    }else if ([processBill.state isEqualToString:PROCESS_STATE_ABORTED]) {
        stateStr = @"已作废";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"finish"] forState:UIControlStateDisabled];
    }else if ([processBill.state isEqualToString:PURCHASE_STATE_FINISHED]) {
        stateStr = @"已完成";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"initial"] forState:UIControlStateDisabled];
    }
    [self.stateBtn setTitle:stateStr forState:UIControlStateNormal];
}







- (void)awakeFromNib {
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];
    
    // Configure the view for the selected state
}

@end
