//
//  IBTConstants.h
//  AceMTer
//
//  Created by Xummer on 2/27/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#ifndef AceMTer_IBTConstants_h
#define AceMTer_IBTConstants_h

#import "IBTUIKit.h"

/*
 * Clog
 */
#ifdef DEBUG
#define CLog(format, ...) NSLog((@"[Line %d] %s " format), __LINE__, __PRETTY_FUNCTION__, ## __VA_ARGS__)
#else
#define CLog(format, ...)
#endif


/*
 * Defualt Height
 */
#define IBT_STATUSBAR_HEIGHT             (20.0f)
#define IBT_TOPBAR_HEIGHT                (44.0f)
#define IBT_BOTTOMBAR_HEIGHT             (45.0f)
#define IBT_SEARCH_BAR_HEIGHT            (44.0f)
#define IBT_SWITCH_WIDTH                 (51.0f)
#define IBT_SWITCH_HEIGHT                (31.0f)
#define IBT_KEYBOARD_HEIGHT              (216.0f)
#define IBT_KEYBOARD_ANIMATION_DURATION  (0.25f)
#define IBT_KEYBOARD_ANIMATION_CURVE     (7)
#define IBT_CELL_HEIGHT                  (44.0f)

#define IBT_DEFAULT_CELL_HEIGHT          (44.0f)
#define IBT_GROUP_CELL_HEIGHT            (44.0f)
#define IBT_GROUP_CELL_TOP_PADDING       (10.0f)
#define IBT_GROUP_CELL_LEFT_PADDING      (15.0f)
#define IBT_GROUP_CELL_TITLE_HEIGHT      (17.0f)
#define IBT_GROUP_SECTION_HEIGHT         (25.0f)
#define IBT_GROUP_CELL_BUTTON_HEIGHT     (44.0f)

#define IBT_GOLDEN_RATIO                 (0.618f)
#define IBT_BTN_CORNER_RADIUS            (2.0f)
#define IBT_DEFAULT_CORNER_RADIUS        (3.0f)

/*
 * Version
 */
#define IBT_SYSTEM_VERSION_STR       ([[UIDevice currentDevice] systemVersion])
#define IBT_APP_VERSION_STR          ([[NSBundle mainBundle] infoDictionary][ @"CFBundleShortVersionString" ])
#define IBT_APP_BUILD_STR            ([[NSBundle mainBundle] infoDictionary][ @"CFBundleVersion" ])
#define IBT_APP_NAME_STR             ([[NSBundle mainBundle] infoDictionary][ @"CFBundleDisplayName"])
#define IBT_IOS7_OR_LATER            ([[[UIDevice currentDevice] systemVersion] compare:@"7.0"] != NSOrderedAscending)
#define IBT_VERSION_ABOVE(version)   ([[[UIDevice currentDevice] systemVersion] compare:version] != NSOrderedAscending)
#define IBT_IS_IPAD                  ([[UIDevice currentDevice] respondsToSelector:@selector(userInterfaceIdiom)] && \
[[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPad)

/*
 * Size
 */
// 屏幕宽度
#define IBT_MAIN_SCREEN_WIDTH        ([[UIScreen mainScreen] bounds].size.width)

// 屏幕高度
#define IBT_MAIN_SCREEN_HEIGHT       ([[UIScreen mainScreen] bounds].size.height)

#define IBT_IPHONE5                  ([UIScreen instancesRespondToSelector:@selector(currentMode)] ? CGSizeEqualToSize(CGSizeMake(640, 1136), [[UIScreen mainScreen] currentMode].size) : NO)
#define IBT_ROOT_VIEW_WIDTH          ([UIApplication sharedApplication].keyWindow.frame.size.width)
#define IBT_ROOT_VIEW_HEIGHT         ([UIApplication sharedApplication].keyWindow.rootViewController.view.frame.size.height)

// Color
#define IBT_TINTCOLOR                [UIColor colorWithR:63 g:134 b:244 a:1]
#define IBT_CELL_GREY_LINE_COLOR     [UIColor colorWithW:233 a:1]
// Regular Expressions
#define IBT_USER_NAME_REGEX  @"^[A-Za-z][\\w\\.]{2,15}$"
#define IBT_PASSWORD_REGEX   @"^[A-Za-z0-9]+$"

/*
 * Custom
 */
#define IBT_BIN_HIGHLIGHT_ALPHA   (.6f)


#define XXFBgColor              RGBA(246,246,246,1)
#define HexColor(colorStr)      [UIColor colorWithHexString:colorStr]
#define RGBA(R,G,B,A)           [UIColor colorWithRed:R/255.0f green:G/255.0f blue:B/255.0f alpha:A]
#define ScreenSize              ([[UIScreen mainScreen] bounds].size)
#define WidthScale              (ScreenSize.width/320)
#define HeightScale             (ScreenSize.height-64)/(480-64)
#define IOS7                    ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7.0)
#define FontSize(num)           [UIFont systemFontOfSize:num]
#define AppWindow               [[UIApplication sharedApplication].delegate window]
#define GXF_NSUSERFEFTAULTS     [NSUserDefaults standardUserDefaults]

#define GXF_NAVIGAYION_COLOR    HexColor(@"7ebf74")
#define GXF_SAVE_COLOR          HexColor(@"50bd62")
#define GXF_COMMIT_COLOR        HexColor(@"f69100")
#define GXF_PLACEHOLDER_COLOR   HexColor(@"bbbbbb")
#define GXF_CONTENT_COLOR       HexColor(@"444444")
#define GXF_CELL_COLOR          HexColor(@"aaaaaa")
#define GXF_LINE_COLOR          HexColor(@"e5e5e5")
#define GXF_DETAIL_COLOR        HexColor(@"888888")
#define GXF_LEFTSIX_COLOR       HexColor(@"666666")
#define GXF_PopView_COLOR       RGBA(24,164,219,1)

#define GXF_TWELVETEEN_SIZE    FontSize(12)
#define GXF_THREETEENTH_SIZE    FontSize(13)
#define GXF_FOURTEENTH_SIZE     FontSize(14)
#define GXF_FIFTEENTEN_SIZE     FontSize(15)
#define GXF_SIXTEENTEH_SIZE     FontSize(16)
#define GXF_SEVENTEENTH_SIZE    FontSize(17)

//refreshUpdateDate
#define SurveyUpdateDate                @"surveyUpdateDate"
#define ChooseProductUpdateDate         @"chooseProductUpdateDate"
#define ChooseProductUnitUpdateDate     @"chooseProductUnitUpdateDate"
#define ChoosePersonUpdateDate          @"choosePersonUpdateDate"
#define ChooseVendorUpdateDate          @"chooseVendorUpdateDate"
#define ChooseAccountTitleUpdateDate    @"chooseAccountTitleUpdateDate"
#define ChooseWarehouseUpdateDate       @"chooseWarehouseUpdateDate"
#define PurchaseUpdateDate              @"purchaseUpdateDate"
#define TransportUpdateDate             @"TransportUpdateDate"
#define PurchaseNoticeUpdateDate        @"purchaseNoticeUpdateDate"
#define TransferUpdateDate              @"TransferUpdateDate"
#define ChooseTransportUpdateDate       @"ChooseTransportUpdateDate"


//行情调研状态
//initial(未提交)，submitted(已提交)，insurvey(调研中)，finished(已完成)
#define SURVEY_STATE_INITIAL      @"initial"
#define SURVEY_STATE_SUBMITTED    @"submitted"
#define SURVEY_STATE_INSURVEY     @"insurvey"
#define SURVEY_STATE_FINISHED     @"finished"


//采购单状态
#define PURCHASE_STATE_INITIAL      @"initial"  //未提交
#define PURCHASE_STATE_SUBMITTED    @"submitted"//已提交 未审批
#define PURCHASE_STATE_REJECTED     @"rejected" //已拒绝
//#define PURCHASE_STATE_APPROVED     @"approved" //已审批 发运中
#define PURCHASE_STATE_SHIPPING     @"shipping" //已审批  发运中
#define PURCHASE_STATE_FINISHED     @"finished" //已完成
#define PURCHASE_STATE_ABORTED      @"aborted"  //已作废


//采购单操作
#define PURCHASE_ACTION_REJECT              @"reject"
#define PURCHASE_ACTION_APPROVE             @"approve"
#define PURCHASE_ACTION_VENDORCONFIRM       @"vendorConfirm"
#define PURCHASE_ACTION_FINISH              @"finish"
#define PURCHASE_ACTION_ABORT               @"abort"




//加工单状态
#define PROCESS_STATE_PROCESSINF      @"processing"
#define PROCESS_STATE_ABORTED          @"aborted"
#define PROCESS_STATE_FINISHED        @"finished"


#define ShowMessage(msg) [[[UIAlertView alloc] initWithTitle:@"温馨提示" message:msg delegate:nil cancelButtonTitle:@"确定" otherButtonTitles:nil] show]

//类型
#define GXF_Critical                @"critical"//紧急
#define GXF_Normal                  @"normal"//普通

#define GXF_BASECLASS_WAREHOUSE     @"Warehouse"
#define GXF_BASECLASS_VENDOR        @"Vendor"
#define GXF_BASECLASS_PRODUCT       @"Product"
#define GXF_BASECLASS_PRODUCTUNIT   @"GXFProductUnit"
#define GXF_BASECLASS_USER          @"User"
#define GXF_BASECLASS_ACCOUNTTITLE  @"Accounttitle"


//发运单状态
#define TRANSPORT_STATE_INITIAL         @"initial"  //未提交
#define TRANSPORT_STATE_UNRECEIVED      @"unreceived"//未收货
#define TRANSPORT_STATE_RECEIVED        @"received" //已收货
#define TRANSPORT_STATE_ABORTED         @"aborted" //已废用
#define TRANSPORT_STATE_FINISHED         @"finished" //已完成

//采购通知单状态
//initial("未提交"), notAccepted("未接受"), purchasing("采购中"), finished("已完成")
#define PURCHASENOTICE_STATE_INITIAL        @"initial"
#define PURCHASENOTICE_STATE_NOTACCEPTED    @"notAccepted"
#define PURCHASENOTICE_STATE_PURCHASEING    @"purchasing"
#define PURCHASENOTICE_STATE_FINISHED       @"finished"

//转运单状态
#define TRANSFER_STATE_INITIAL         @"initial"   //未提交
#define TRANSFER_STATE_UNRECEIVED      @"unreceived"//待收货
#define TRANSFER_STATE_RECEIVED        @"received"  //已收货
#define TRANSFER_STATE_ABORTED         @"aborted"   //已废用
//收货单
#define RECEIVE_STATE_SAVE             @"save"      //保存
#define RECEIVE_STATE_RECEIVE          @"receive"   //收货



//权限列表vendorapprove 采购单
#define PURCHASE_PERMISSIONS_MANAGEAPPROVE              @"500405"
#define PURCHASE_PERMISSIONS_VENDORAPPROVE              @"500406"
#define PURCHASE_PERMISSIONS_FINISH                     @"500407"
#define PURCHASE_PERMISSIONS_ABORT                      @"500408"

//转运单
#define TRANSFER_ACTION_ABORT          @"500605"    //作废权
#define RECEIVE_ACTION_RECEIVE         @"500803"    //收货权

//采购通知单权限
#define NOTICE_PERMISSIONS_ACCEPTTASK                   @"500304"//接受任务
#define NOTICE_PERMISSIONS_CREATEBILL                   @"500305"//新建权
#define NOTICE_PERMISSIONS_FINISH                       @"500306"//结束
//发运单权限
#define TRANSPORT_ACTION_FINISH         @"500504"  //结束权
#define TRANSPORT_ACTION_ABORT          @"500505"   //作废权

//选中的颜色
#define BASESELECT_COLOR                                RGBA(255, 127, 0, 1)

//销售
#define SaleDay                         @"日"
#define SaleWeek                        @"周"
#define SaleMonth                       @"月"

#define SaleEnDay                         @"day"
#define SaleEnWeek                        @"week"
#define SaleEnMonth                       @"month"


//报表统一颜色
#define ReportColor             RGBA(42, 135, 193, 1)
#define ReportContentColor      RGBA(192, 0, 13, 1)
#define ReportTableHeaderColor  RGBA(207, 207, 207, 1)
#define ReportTitleColor        RGBA(52, 141, 194, 1)

#define ReportChainSignPlus         @"plus"
#define ReportChainSignMinus        @"minus"
#define ReportChainPlusImage        @"goSale"
#define ReportChainMinusImage       @"downSale"

#endif
