//
//  TransferDetailViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/28.
//  Copyright (c) 2015年 Xummer. All rights reserved.
// 转运单详情

#import "TransferDetailViewController.h"
#import "BottomTransferView.h"

#define BottomHeight                                50
#define LeftMargin                                  15
#define LeftWidth                                   100
#define LeftHeight                                  30
#define TopMargin                                   15
typedef enum : NSUInteger {
    AbortTag = 20000,
    EndTag,
    SubmitTag
    
} BtnTag;
@interface TransferDetailViewController (){
    UIScrollView *_scrollView;
    UIView *_transportView;
    UIView *_bottomView;
    UIButton *_firstBtn;
    UIButton *_secondBtn;
    BottomTransferView *_transView;
}
@property (nonatomic,strong)UILabel *billNumberLabel;
@property (nonatomic,strong)UILabel *purchaseLabel;
@property (nonatomic,strong)UILabel *stateLabel;
@property (nonatomic,strong)UILabel *warehouseLabel;
@property (nonatomic,strong)UILabel *rwarehouseLabel;
@property (nonatomic,strong)UILabel *carnumberLabel;
@property (nonatomic,strong)UILabel *carhoneLabel;
@property (nonatomic,strong)UILabel *createOperLabel;
@property (nonatomic,strong)UILabel *arriveDateLabel;
@property (nonatomic,strong)UILabel *noteLabel;
@end

@implementation TransferDetailViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self bulifLayout];
    [self getDataFromServer];
}
- (void)getDataFromServer{
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message  = data[@"message"] ;
            if (success == 1) {
                NSDictionary *dictData = data[@"data"];
                
                Transfer *transfer = [[Transfer alloc]init];
                [transfer setValuesForKeysWithDictionary:dictData];
                self.transfer = transfer;
                [strongSelf fetchtTransportDetail];
            }else{
                [IBTLoadingView showTips:message];
            }
        }else{
            [IBTLoadingView showTips:@"     无记录     "];
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    [[ICRHTTPController sharedController] getTransferResultWithTransferUuid:self.transfer.uuid success:succ failure:fail];
}
- (void)fetchtTransportDetail{
    self.billNumberLabel.text = [IBTCommon checkString:self.transfer.billnumber];
    if ([self.transfer.state isEqualToString:TRANSFER_STATE_UNRECEIVED]) {
        self.stateLabel.textColor = [UIColor redColor];
        self.stateLabel.text = @"待收货";
    }else if ([self.transfer.state isEqualToString:TRANSFER_STATE_RECEIVED]) {
        self.stateLabel.textColor = [UIColor greenColor];
        self.stateLabel.text = @"已收货";
    }else if ([self.transfer.state isEqualToString:TRANSFER_STATE_ABORTED]) {
        self.stateLabel.textColor = [UIColor grayColor];
        self.stateLabel.text = @"已作废";
    }else if ([self.transfer.state isEqualToString:TRANSFER_STATE_PROCESS]) {
        self.stateLabel.textColor = [UIColor blackColor];
        self.stateLabel.text = @"提交系统处理";
    }else if ([self.transfer.state isEqualToString:TRANSFER_STATE_PROCESSFAIL]) {
        self.stateLabel.textColor = [UIColor blackColor];
        self.stateLabel.text = @"系统处理失败";
    }
    self.purchaseLabel.text = [self getPurchaseWith:self.transfer.pdtDetails];
    self.warehouseLabel.text = [IBTCommon checkString:self.transfer.warehouseName];
    self.rwarehouseLabel.text = [IBTCommon checkString:self.transfer.rwarehouseName];
    self.carnumberLabel.text = [IBTCommon checkString:self.transfer.carnumber];
    self.carhoneLabel.text = [IBTCommon checkString:self.transfer.carphone];
    self.noteLabel.text = [NSString stringWithFormat:@"%@",self.transfer.note?self.transfer.note:@"无"];
    self.createOperLabel.text = [NSString stringWithFormat:@"%@%@",[IBTCommon checkString:self.transfer.create_operName],self.transfer.create_time.length > 10 ? [self.transfer.create_time substringToIndex:10] : self.transfer.create_time];
     self.arriveDateLabel.text = [NSString stringWithFormat:@"%@",self.transfer.arriveDate?[[IBTCommon checkString:self.transfer.arriveDate]substringToIndex:10]:@"无"];
    [_transView refreshTranProduct:self.transfer.pdtDetails];
    [_transView refreshCost:self.transfer.accountDetails];
    [self setNoteHeight];
}
- (void)setNoteHeight
{
    CGFloat height =  [self.noteLabel calculateHeight];
    
    CGRect noteFrame = self.noteLabel.frame;
    noteFrame.size.height = height;
    self.noteLabel.frame = noteFrame;
    
    CGFloat totalHeight = height + LeftHeight*9;
    
    CGRect purchaseFrame = _transportView.frame;
    purchaseFrame.size.height = totalHeight + LeftMargin;
    _transportView.frame = purchaseFrame;


    CGRect bottomFrame = _bottomView.frame;
    bottomFrame.origin.y = CGRectGetMaxY(_transportView.frame) + TopMargin;
    _bottomView.frame = bottomFrame;
    
    _scrollView.contentSize = CGSizeMake(ScreenSize.width, totalHeight + CGRectGetHeight(_bottomView.frame) + TopMargin*2);
}
- (NSString *)getPurchaseWith:(NSArray *)purchases{
    NSString *purchseNumber = @"";
    
    NSInteger count = 0;
    for (NSDictionary *billDict in purchases) {
        if (![billDict[@"sourcebillnumber"] isEqual:[NSNull null]]) {
            count ++;
            if (purchseNumber.length == 0) {
                purchseNumber = [purchseNumber stringByAppendingFormat:@"%@",billDict[@"sourcebillnumber"]];
            }else{
                purchseNumber = [purchseNumber stringByAppendingFormat:@",%@" ,billDict[@"sourcebillnumber"]];
            }
        }
    }
    if (count == 0) {
        purchseNumber = @"无";
    }
    return purchseNumber;
}

- (void)createBtnWithArr:(NSArray *)arr{
    CGFloat btnWidth = (ScreenSize.width - LeftMargin * (arr.count+1))/arr.count;
    for (NSInteger i = 0; i < arr.count; i++) {
        NSInteger btnTag = 0;
        if ([arr[i] isEqualToString:@"结束"]) {
            btnTag = EndTag;
        }else if ([arr[i] isEqualToString:@"作废"]) {
            btnTag = AbortTag;
        }else if ([arr[i] isEqualToString:@"提交"]) {
            btnTag = SubmitTag;
        }
        CGRect btnFrame = CGRectMake(LeftMargin + (LeftMargin + btnWidth)*i,  ScreenSize.height  - 64 - BottomHeight +5, btnWidth, 40);
        UIButton *perBtn = [IBTCustomButtom creatButtonWithFrame:btnFrame target:self sel:@selector(btnClick:) tag:btnTag image:nil title:arr[i] titleColor:[UIColor whiteColor] isCorner:YES corner:5 bgColor:GXF_COMMIT_COLOR];
        [self.view addSubview:perBtn];
    }
}



#pragma mark - 视图初始化
- (void)bulifLayout{
    _scrollView = [[UIScrollView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, ScreenSize.height - 64 - BottomHeight)];
    _scrollView.showsHorizontalScrollIndicator  = NO;
    _scrollView.showsVerticalScrollIndicator = NO;
    _scrollView.backgroundColor = XXFBgColor;
    [self.view addSubview:_scrollView];
    if ([self.transfer.state isEqualToString:TRANSFER_STATE_RECEIVED] || [self.transfer.state isEqualToString:TRANSFER_STATE_UNRECEIVED]) {
        if ([IBTCommon checkIsPermission:TRANSFER_ACTION_ABORT]) {
            [self createBtnWithArr:@[@"作废"]];
        }else{
            [self hiddenBottomView];
        }
#warning 测试
    }else if ([self.transfer.state isEqualToString:TRANSFER_STATE_PROCESSFAIL]){
        NSMutableArray *arr = [NSMutableArray array];
        if ([IBTCommon checkIsPermission:TRANSPORT_ACTION_ABORT]) {
            [arr addObject:@"作废"];
        }if ([IBTCommon checkIsPermission:TRANSPORT_ACTION_NEW]) {
            [arr addObject:@"提交"];
        }
        if (arr.count == 0) {
            [self hiddenBottomView];
        }else{
            [self createBtnWithArr:arr];
        }
    }else{
        [self hiddenBottomView];
    }
    NSArray *leftArr = @[@"单号:",@"来源单据:",@"状态:",@"发货仓库:",@"收货仓库:",@"车辆:",@"司机电话:",@"创建:",@"预计到货时间:",@"备注:"];
    
    _transportView= [[UIView alloc]initWithFrame:CGRectMake(0, TopMargin, ScreenSize.width, LeftHeight*leftArr.count +LeftMargin)];
    _transportView.backgroundColor = [UIColor whiteColor];
    [_scrollView addSubview:_transportView];
    
    
    for (NSInteger i = 0 ; i < leftArr.count; i++) {
        UILabel *leftLabel = [[UILabel alloc]initWithFrame:CGRectMake(LeftMargin, 10 + LeftHeight *i, LeftWidth, LeftHeight)];
        leftLabel.font = GXF_SEVENTEENTH_SIZE;
        leftLabel.text = leftArr[i];
        leftLabel.textColor = GXF_DETAIL_COLOR;
        [_transportView addSubview:leftLabel];
        
        UILabel *rightLabel = [[UILabel alloc]initWithFrame:CGRectMake(CGRectGetMaxX(leftLabel.frame), 10 + LeftHeight *i, _transportView.frame.size.width - LeftMargin - LeftWidth, LeftHeight)];
        rightLabel.font = GXF_SEVENTEENTH_SIZE;
        rightLabel.textColor = GXF_DETAIL_COLOR;
        
        if (i == 0) {
            self.billNumberLabel = rightLabel;
        }else if (i == 1) {
            self.purchaseLabel = rightLabel;
        }else if(i == 2){
            self.stateLabel = rightLabel;
        }else if(i == 3){
            self.warehouseLabel = rightLabel;
        }else if(i == 4){
            self.rwarehouseLabel = rightLabel;
        }else if(i == 5){
            self.carnumberLabel = rightLabel;
        }else if(i == 6){
            self.carhoneLabel = rightLabel;
        }else if(i == 7){
            self.createOperLabel = rightLabel;
        }else if(i == 8){
            leftLabel.width = LeftWidth + 10;
            rightLabel.left = leftLabel.right;
            rightLabel.width = ScreenSize.width - leftLabel.width - LeftMargin;
            self.arriveDateLabel = rightLabel;
        }else if(i == leftArr.count - 1){
            rightLabel.numberOfLines = 0;
            self.noteLabel = rightLabel;
        }
        [_transportView addSubview:rightLabel];
    }
    [self createBottomView];
}
- (void)hiddenBottomView{
    CGRect scrollViewFrame = _scrollView.frame;
    scrollViewFrame.size.height = ScreenSize.height - 64;
    _scrollView.frame = scrollViewFrame;
}
- (void)createBottomView{
    _bottomView= [[UIView alloc]initWithFrame:CGRectMake(0, CGRectGetMaxY(_transportView.frame) + TopMargin, ScreenSize.width, 300)];
    _bottomView.backgroundColor = [UIColor whiteColor];
    
    [_scrollView addSubview:_bottomView];
    
    _transView = [[BottomTransferView alloc]initWithFrame:_bottomView.bounds withHidden:YES];
    [_bottomView addSubview:_transView];
}

- (void)btnClick:(UIButton *)btn{
    CLog(@"%ld",(long)btn.tag);
    switch (btn.tag) {
        case AbortTag:
        {
            CLog(@"作废");
            UIAlertView *alertView = [[UIAlertView alloc]initWithTitle:@"温馨提示" message:@"请确认作废" delegate:self cancelButtonTitle:@"取消" otherButtonTitles:@"确认", nil];
            alertView.delegate = self;
            alertView.tag = AbortTag;
            [alertView show];
        }
            break;
        case EndTag:
        {
            CLog(@"结束");
            UIAlertView *alertView = [[UIAlertView alloc]initWithTitle:@"温馨提示" message:@"请确认结束" delegate:self cancelButtonTitle:@"取消" otherButtonTitles:@"确认", nil];
            alertView.delegate = self;
            alertView.tag = EndTag;
            [alertView show];
        }
            break;
        case SubmitTag:
        {
            CLog(@"提交");
            UIAlertView *alertView = [[UIAlertView alloc]initWithTitle:@"温馨提示" message:@"请确认提交" delegate:self cancelButtonTitle:@"取消" otherButtonTitles:@"确认", nil];
            alertView.delegate = self;
            alertView.tag = SubmitTag;
            [alertView show];
        }
            break;
            
        default:
            break;
    }
}


- (void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex{
    if (alertView.tag == AbortTag) {
        if (buttonIndex == 1) {
            [self dealByAction:TRANSFER_STATE_ABORTED];//作废
        }
    }else if (alertView.tag == EndTag){
        if (buttonIndex == 1) {
            [self dealByAction:TRANSFER_STATE_RECEIVED];//结束
        }
    }else if (alertView.tag == SubmitTag){
        if (buttonIndex == 1) { //提交
            [self getDataFromServer:TRANSFER_STATE_PROCESSFAIL msg:@"正在提交..."];
        }
    }
}
- (void)dealByAction:(NSString *)action{
    //保存
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message = data[@"message"];
            if (success == 1) {
                [ICRUserUtil sharedInstance].needFresh = YES;
                [self PopViewControllerAnimated:YES];
            }else{
                [IBTLoadingView showTips:message];
            }
        }else{
            [IBTLoadingView showTips:@"操作异常"];
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    if ([action isEqualToString:TRANSFER_STATE_ABORTED]) {
        [[ICRHTTPController sharedController] abortTransferWithTransferUuid:self.transfer.uuid version:self.transfer.version success:succ failure:fail];
    }else{
        [[ICRHTTPController sharedController] endTransferWithTransferUuid:self.transfer.uuid version:self.transfer.version success:succ failure:fail];
    }
}
#pragma mark - 提交数据
- (void)getDataFromServer:(NSString *)state msg:(NSString *)msg{
    //保存
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message = data[@"message"];
            if (success == 1) {
                [ICRUserUtil sharedInstance].needFresh = YES;
                [self PopViewControllerAnimated:YES];
            }else{
                [IBTLoadingView showTips:message];
            }
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    
    NSDictionary *dict = @{@"uuid":self.transfer.uuid,
                           @"version":self.transfer.version,
                           @"billnumber":self.transfer.billnumber,
                           @"enterprise":[ICRUserUtil sharedInstance].orgId,
                           @"state":TRANSFER_STATE_UNRECEIVED,
                           @"warehouseUuid":[IBTCommon checkString:self.transfer.warehouseUuid],
                           @"warehouseCode":[IBTCommon checkString:self.transfer.warehouseCode],
                           @"warehouseName":[IBTCommon checkString:self.transfer.warehouseName],
                           @"rwarehouseUuid":[IBTCommon checkString:self.transfer.rwarehouseUuid],
                           @"rwarehouseCode":[IBTCommon checkString:self.transfer.rwarehouseCode],
                           @"rwarehouseName":[IBTCommon checkString:self.transfer.rwarehouseName],
                           @"carnumber":[IBTCommon checkString:self.transfer.carnumber],
                           @"type":[IBTCommon checkString:self.transfer.type],
                           @"carphone":[IBTCommon checkString:self.transfer.carphone],
                           @"arriveDate":[IBTCommon checkString:self.transfer.arriveDate],
                           @"note":[IBTCommon checkString:self.transfer.note],
                           @"pdtDetails":self.transfer.pdtDetails,
                           @"accountDetails":self.transfer.accountDetails
                           };
    [IBTLoadingView showProgressLabel:msg];
    [[ICRHTTPController sharedController] saveTransferWithData:dict success:succ failure:fail];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
