//
//  SurveyCell.m
//  XFFurit
//
//  Created by 陈俊俊 on 15/8/1.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "SurveyCell.h"
#define TitleSize 15
#define LeftMargin 15
@implementation SurveyCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout
{
    
    self.titleLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, 0, 100, 44))];
    self.titleLabel.textAlignment= NSTextAlignmentLeft;
    self.titleLabel.textColor = HexColor(@"666666");
    self.titleLabel.font = FontSize(TitleSize);
    
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, 44-1, ScreenSize.width - LeftMargin * 2, 1))];
    self.lineLabel.backgroundColor = HexColor(@"e5e5e5");
    self.lineLabel.font = FontSize(TitleSize);
    [self.contentView addSubview:self.titleLabel];
    [self.contentView addSubview:self.lineLabel];
}
- (void)setTitleStr:(NSString *)str
{
    self.titleLabel.text = str;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
