//
//  SortMaskView.m
//  XFFurit
//
//  Created by 陈俊俊 on 15/8/1.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "SortMaskView.h"
#import "MaskCell.h"
#define TableHeight 45

@interface SortMaskView ()
{
    NSIndexPath *_currentIndexPath;
    NSString *_orderDirection;
}
@end

@implementation SortMaskView
- (instancetype)initWithFrame:(CGRect)frame withOrderDirection:(NSString *)orderDirection{
    self = [super initWithFrame:frame];
    if (self) {
        self.tableView = [[UITableView alloc]initWithFrame:self.bounds style:(UITableViewStylePlain)];
        self.tableView.delegate = self;
        self.tableView.dataSource = self;
        [self addSubview:self.tableView];
        if (orderDirection.length >0) {
            if ([orderDirection isEqualToString:@"asc"]) {
                _currentIndexPath = [NSIndexPath indexPathForRow:0 inSection:0];
            }else if ([orderDirection isEqualToString:@"des"]){
                _currentIndexPath = [NSIndexPath indexPathForRow:1 inSection:0];
            }else{
                _currentIndexPath = [NSIndexPath indexPathForRow:2 inSection:0];
            }
        }
    }
    return self;
}

#pragma mark - 协议
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"MaskID";
    MaskCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[MaskCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID totalWidth:ScreenSize.width totalHeight:TableHeight];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    if (_dataArr.count > 0) {
        [cell setTitleStr:self.dataArr[indexPath.row]];
        cell.Commitbtn.hidden = YES;
    }
    if (_currentIndexPath) {
        if (indexPath.row == _currentIndexPath.row) {
            cell.Commitbtn.hidden = NO;
        }else{
            cell.Commitbtn.hidden = YES;
        }
    }
    return cell;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    //获取选中的cell
    MaskCell *currentCell = (MaskCell *)[tableView cellForRowAtIndexPath:_currentIndexPath];
    currentCell.Commitbtn.hidden = YES;
    MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
    cell.Commitbtn.hidden = NO;
    _currentIndexPath = indexPath;
    if (indexPath.row == 0) {
        [self.delegate getSortValueSelectRow:@"asc"];
    }else if(indexPath.row == 1){
        [self.delegate getSortValueSelectRow:@"desc"];
    }else{
        [self.delegate getSortValueSelectRow:@"none"];
    }
}



- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return TableHeight;
}

@end
