//
//  PurchaseCell.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/23.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "PurchaseCell.h"
#define TitleSize 16
#define ContentSize 14
#define TitleColor @"444444"
#define ContentColor @"aaaaaa"
#define LeftMargin 90
#define TopMargin 10
#define TitleHeight 20
#define TableHeight 120

@implementation PurchaseCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout
{
    self.stateBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    self.stateBtn.frame = CGRectMake(TopMargin *2 , TopMargin, LeftMargin - TopMargin*3, 20);
    self.stateBtn.titleLabel.font = FontSize(ContentSize);
    [self.stateBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    self.stateBtn.enabled = NO;
    
    self.billNumberLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, TopMargin, ScreenSize.width - LeftMargin, TitleHeight))];
    self.billNumberLabel.textColor = HexColor(TitleColor);
    self.billNumberLabel.font = FontSize(TitleSize);
    
    self.noticeNumberLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, CGRectGetMaxY(self.billNumberLabel.frame), ScreenSize.width - LeftMargin, TitleHeight*2))];
    self.noticeNumberLabel.numberOfLines = 0;
    self.noticeNumberLabel.textColor = HexColor(ContentColor);
    self.noticeNumberLabel.font = FontSize(ContentSize);
    
    self.createOperNameLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, CGRectGetMaxY(self.noticeNumberLabel.frame), ScreenSize.width - LeftMargin, TitleHeight))];
    self.createOperNameLabel.textColor = HexColor(ContentColor);
    self.createOperNameLabel.font = FontSize(ContentSize);
    
    
    self.createTimeLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, CGRectGetMaxY(self.createOperNameLabel.frame), ScreenSize.width - LeftMargin, TitleHeight))];
    self.createTimeLabel.textColor = HexColor(ContentColor);
    self.createTimeLabel.font = FontSize(ContentSize);
    
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin,TableHeight-1, ScreenSize.width - LeftMargin - TopMargin * 2, 1))];;
    self.lineLabel.backgroundColor = HexColor(@"e5e5e5");
    
    [self.contentView addSubview:self.stateBtn];
    [self.contentView addSubview:self.billNumberLabel];
    [self.contentView addSubview:self.noticeNumberLabel];
    [self.contentView addSubview:self.createOperNameLabel];
    [self.contentView addSubview:self.createTimeLabel];
    [self.contentView addSubview:self.lineLabel];
    
}

- (void)setPurchaseBill:(PurchaseBill *)purchaseBill{
    self.billNumberLabel.text = [NSString stringWithFormat:@"单号：%@",purchaseBill.billNumber];
    self.noticeNumberLabel.text = [NSString stringWithFormat:@"采购通知单：%@",purchaseBill.noticeNumber];
    self.createOperNameLabel.text = [NSString stringWithFormat:@"创建人：%@",purchaseBill.create_operName] ;
    self.createTimeLabel.text =[NSString stringWithFormat:@"创建时间：%@",purchaseBill.create_time];
    NSString *stateStr = @"";
    if ([purchaseBill.state isEqualToString:@"initial"]) {
        stateStr = @"未提交";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"initial"]  forState:UIControlStateDisabled];
    }else if ([purchaseBill.state isEqualToString:@"submitted"]) {
        stateStr = @"已提交";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"insurvey"] forState:UIControlStateDisabled];
    }else if ([purchaseBill.state isEqualToString:@"rejected"]) {
        stateStr = @"已拒绝";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"insurvey"] forState:UIControlStateDisabled];
        
    }else if ([purchaseBill.state isEqualToString:@"approved"]) {
        stateStr = @"已审批";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"insurvey"] forState:UIControlStateDisabled];
        
    }else if ([purchaseBill.state isEqualToString:@"shipping"]) {
        stateStr = @"发运中";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"insurvey"] forState:UIControlStateDisabled];
        
    }else if ([purchaseBill.state isEqualToString:@"finished"]) {
        stateStr = @"已完成";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"finish"] forState:UIControlStateDisabled];
    }
    [self.stateBtn setTitle:stateStr forState:UIControlStateNormal];
}







- (void)awakeFromNib {
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
