//
//  PurchaseViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/23.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "PurchaseViewController.h"
#import "PurchaseCell.h"
#import "PurchaseBill.h"
#import "PurchaseDetailViewController.h"

#define TopMargin 44
#define TableHeight 120
#define LeftMargin 20
#define BtnWidth 60
#define BtnHeight 24
#define BtnSize 16

typedef enum : NSUInteger {
    SortTag = 3000,
    BoltTag
    
} BtnTag;
@interface PurchaseViewController ()<UITableViewDataSource,UITableViewDelegate>
{
    UIView *_maskView;
    UIButton *currentBtn;
    UIBarButtonItem  *_sureBtn;
    UIButton *_sortBtn;
    UIButton *_boltBtn;
}
@property (nonatomic,strong)NSMutableArray *dataArr;
@property (nonatomic,strong)UITableView *tableView;
@end

@implementation PurchaseViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor  = XXFBgColor;
    [self initData];
    [self createTableView];
}
- (void)initData{
    self.dataArr = [NSMutableArray array];
    for (NSInteger i = 0; i < 6; i++) {
        PurchaseBill *bill = [PurchaseBill new];
        bill.billNumber = @"222222222";
        bill.noticeNumber = @"134594059654 0504门店补货0002";
        bill.create_operName = @"张三";
        bill.create_time = @"2013-03-04";
        bill.vendor_name  = @"haha";
        bill.total = @"200元";
        bill.remark = @"hahahah";
        if (i == 0) {
            bill.state = @"initial";
        }else if(i == 1){
            bill.state = @"submitted";
        }else if(i == 2){
            bill.state = @"rejected";
        }else if(i == 3){
            bill.state = @"approved";
        }else if(i == 4){
            bill.state = @"shipping";
        }else if(i == 5){
            bill.state = @"finished";
        }
        [self.dataArr addObject:bill];
    }
    
}
- (void)createTableView
{
    _sureBtn = [[UIBarButtonItem alloc]initWithTitle:@"确定" style:UIBarButtonItemStylePlain target:self action:@selector(sureClick)];
    
    _sortBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(LeftMargin, 10, BtnWidth, BtnHeight) target:self sel:@selector(sortClick:) tag:SortTag image:@"black_arrow_down_with_text" title:nil titleColor:HexColor(@"888888") isCorner:NO corner:0 bgColor:nil];
    _sortBtn.titleLabel.font = FontSize(BtnSize);
    [self.view addSubview:_sortBtn];
    
    _boltBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(ScreenSize.width-BtnWidth - LeftMargin,10,BtnWidth, BtnHeight) target:self sel:@selector(sortClick:) tag:BoltTag image:@"black_filter_with_text" title:nil titleColor:HexColor(@"888888") isCorner:NO corner:0 bgColor:nil];
    _boltBtn.titleLabel.font = FontSize(BtnSize);
    [self.view addSubview:_boltBtn];
    
    
    self.tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, TopMargin,ScreenSize.width, ScreenSize.height - 64 - TopMargin)) style:(UITableViewStylePlain)];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self.view addSubview:self.tableView];
    
    _maskView = [[UIView alloc]initWithFrame:CGRectMake(0, TopMargin, ScreenSize.width, ScreenSize.height - 64- TopMargin)];
    _maskView.backgroundColor = RGBA(0, 0, 0, 0.5);
    _maskView.hidden = YES;
    [self.view addSubview:_maskView];
}

#pragma mark -按钮事件
- (void)sortClick:(UIButton *)btn{
}
#pragma mark - 确定
- (void)sureClick{
}
#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"SurveyID";
    PurchaseCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[PurchaseCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    if (self.dataArr.count > 0) {
        PurchaseBill *bill = self.dataArr[indexPath.row];
        [cell setPurchaseBill:bill];
    }
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    PurchaseDetailViewController *pvc = [PurchaseDetailViewController new];
    pvc.title = @"查看采购单";
    pvc.bill = _dataArr[indexPath.row];
    [self PushViewController:pvc animated:YES];
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return TableHeight;
}



- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
