//
//  IBTAudioRecorder.h
//  XFFruit
//
//  Created by Xummer on 4/17/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTObject.h"

@interface IBTAudioRecorder : IBTObject

@property (nonatomic, copy) void (^finishRecordingBlock)(IBTAudioRecorder *recorder,BOOL success);
@property (nonatomic, copy) void (^encodeErrorRecordingBlock)(IBTAudioRecorder *recorder,NSError *error);
@property (nonatomic, copy) void (^receivedRecordingBlock)(IBTAudioRecorder *recorder,float peakPower,float averagePower,float currentTime);

@property (nonatomic, readonly) BOOL m_bIsRecording;

- (NSString *)recorderingPath;
- (NSDictionary *)recordingSettings;

- (BOOL)startRecord;
- (BOOL)startRecordForDuration: (NSTimeInterval) duration;
+ (void)checkMicrophonePermissionAndRunAction:(void (^)(void))action;

- (void)stopRecord;
- (void)stopAndDeleteRecord;
- (void)stopAndDeleteAllRecords;

+ (NSString *)recordFilePath;

@end
