//
//  TopTransportView.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/6.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "TopTransportView.h"
#import "SurveyCell.h"
#import "Warehouse.h"
#import "ChooseWarehouseViewController.h"
#import "ChooseTypeViewController.h"
#define LeftMargin 15
#define TopMargin 20
#define LeftWidth 80
#define TableHeight 44
#define SpaceHeight 10

@interface TopTransportView ()<UITableViewDataSource,UITableViewDelegate,HPGrowingTextViewDelegate,UITextFieldDelegate,FinishTimeViewDelegate>
{
    UITableView *_tableView;
    NSMutableArray *_dataArr;
}
@property (nonatomic,strong)NSString *selectType;
@property (nonatomic,strong)NSString *selectRwarehouse;
@property (nonatomic,strong)NSString *selectWarehouse;
@end


@implementation TopTransportView
- (instancetype)initWithFrame:(CGRect)frame{
    self = [super initWithFrame:frame];
    if (self) {
        //界面
        [self bulidLayout];
    }
    return self;
}

#pragma mark - 布局
- (void)bulidLayout
{
    self.backgroundColor  = XXFBgColor;
    _dataArr = [NSMutableArray array];
    NSArray *arr = @[@"发货仓库:",@"收货仓库:",@"运输类型:",@"车辆:",@"司机电话:",@"预计到货时间:",@"备注:"];
    [_dataArr addObjectsFromArray:arr];
    
    _tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, TopMargin,self.frame.size.width, self.frame.size.height - TopMargin)) style:(UITableViewStylePlain)];
    _tableView.backgroundColor = [UIColor whiteColor];
    _tableView.bounces = NO;
    _tableView.delegate = self;
    _tableView.dataSource = self;
    [self addSubview:_tableView];
}
#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"cellID";
    SurveyCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[SurveyCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        if (indexPath.row ==0 || indexPath.row == 1 || indexPath.row == 2 || indexPath.row == 5) {
            cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
        }
        
        [self createViewInCell:cell indexPath:indexPath];
    }
    [cell setTitleStr:_dataArr[indexPath.row]];
    return cell;
}
-  (void)createViewInCell:(SurveyCell *)cell indexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == 3 || indexPath.row == 4) {
        UITextField *textField = [[UITextField alloc] initWithFrame:CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-10, TableHeight)];
        textField.textAlignment = NSTextAlignmentRight;
        textField.textColor = GXF_CONTENT_COLOR;
        textField.font = GXF_FIFTEENTEN_SIZE;
        textField.returnKeyType = UIReturnKeyDone;
        textField.delegate = self;
        [cell.contentView addSubview:textField];
        if (indexPath.row == 3) {
            self.carTextFiled = textField;
            self.carTextFiled.placeholder = @"请输入车辆";
        }else if(indexPath.row == 4){
            textField.keyboardType = UIKeyboardTypeNumbersAndPunctuation;
            textField.returnKeyType = UIReturnKeyDone;
            self.phoneTextFiled = textField;
            self.phoneTextFiled.placeholder = @"请输入司机电话";
        }
        
    }else if (indexPath.row == _dataArr.count -1){
        self.remarkTextView = [[HPGrowingTextView alloc] initWithFrame:CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-10, TableHeight)];
        self.remarkTextView.contentInset = UIEdgeInsetsMake(5, 5, 5, 0);
        self.remarkTextView.minNumberOfLines = 1;
        self.remarkTextView.maxNumberOfLines = 1;
        self.remarkTextView.isScrollable = YES;
        self.remarkTextView.font = GXF_FIFTEENTEN_SIZE;
        self.remarkTextView.textAlignment = NSTextAlignmentRight;
        self.remarkTextView.delegate = self;
        self.remarkTextView.returnKeyType = UIReturnKeyDone;
        self.remarkTextView.placeholder = @"输入备注内容";
        [cell.contentView addSubview:self.remarkTextView];
    }else{
        UILabel *contentLabel = [[UILabel alloc]initWithFrame:(CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-10, TableHeight))];
        contentLabel.textAlignment= NSTextAlignmentRight;
        contentLabel.textColor = GXF_PLACEHOLDER_COLOR;
        contentLabel.font = GXF_FIFTEENTEN_SIZE;
        [cell.contentView addSubview:contentLabel];
        if (indexPath.row == 0) {
            contentLabel.text = @"选择发货仓库";
            self.warehouseLabel = contentLabel;
            
        }else if(indexPath.row == 1){
            contentLabel.text = @"选择收货仓库";
            self.rwarehouseLabel = contentLabel;
            
        }else if(indexPath.row == 2){
            contentLabel.text = @"选择类型";
            self.typeLabel = contentLabel;
            
        }else if(indexPath.row == 5){
            contentLabel.text = @"选择预计到货时间";
            self.arriveDateLabel = contentLabel;
        }
    }
}
- (void)setTransport:(Transport *)transport{
    if (transport) {
        if (transport.warehouseName.length > 0) {
            self.warehouseLabel.text = transport.warehouseName;
            self.warehouseLabel.textColor = GXF_CONTENT_COLOR;
            self.warehouseCode = transport.warehouseCode;
            self.warehouseName = transport.warehouseName;
            self.warehouseUuid = transport.warehouseUuid;
            self.selectWarehouse = transport.warehouseUuid;
        }
        if (transport.type.length > 0) {
            NSString *type = [transport.type isEqualToString:GXF_Critical] ? @"紧急" : @"普通";
            self.typeLabel.text = type;
            self.typeLabel.textColor = GXF_CONTENT_COLOR;
            self.type = transport.type;
            self.selectType = transport.type;
        }
        if (transport.rwarehouseName.length > 0) {
            self.rwarehouseLabel.text = transport.rwarehouseName;
            self.rwarehouseLabel.textColor = GXF_CONTENT_COLOR;
            self.rwarehouseCode = transport.rwarehouseCode;
            self.rwarehouseName = transport.rwarehouseName;
            self.rwarehouseUuid = transport.rwarehouseUuid;
            self.selectRwarehouse = transport.rwarehouseUuid;
        }
        if (transport.carnumber.length > 0) {
            self.carTextFiled.text = transport.carnumber;
            self.carnumber = transport.carnumber;
        }
        if (transport.carphone) {
            self.phoneTextFiled.text = transport.carphone;
            self.carphone = transport.carphone;
        }
        if (transport.arriveDate) {
            if (transport.arriveDate.length > 15) {
                _arriveDateLabel.text = [[IBTCommon checkString:transport.arriveDate]substringToIndex:16];
            }
            _arriveDateLabel.textColor = GXF_CONTENT_COLOR;
            self.arriveDate = [IBTCommon checkString:transport.arriveDate];
        }

        if (transport.note) {
            self.remarkTextView.text = transport.note;
            self.note = transport.note;
        }
    }
}

-(void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    if(indexPath.row == 0){
        ChooseWarehouseViewController *cvc = [ChooseWarehouseViewController new];
        if (self.selectWarehouse.length > 0) {
            cvc.selectStr = self.selectWarehouse;
        }
        cvc.choseBaseInfo = ^(NSArray *warehouses){
            if (warehouses.count > 0) {
                Warehouse *warehouse = warehouses[0];
                self.warehouseLabel.text = [NSString stringWithFormat:@"%@[%@]",warehouse.name,warehouse.code];
                self.warehouseLabel.textColor = GXF_CONTENT_COLOR;
                self.warehouseUuid = warehouse.uuid;
                self.warehouseCode = warehouse.code;
                self.warehouseName = warehouse.name;
                self.selectWarehouse = warehouse.uuid;
            }
            
        };
        cvc.isMoreChose = NO;
        [self.delegate pushNextViewController:cvc];
    }else if(indexPath.row == 1){
        ChooseWarehouseViewController *tvc = [[ChooseWarehouseViewController alloc]init];
        if (self.selectRwarehouse.length > 0) {
            tvc.selectStr = self.selectRwarehouse;
        }
        tvc.choseBaseInfo = ^(NSArray *warehouses){
            if (warehouses.count > 0) {
                Warehouse *warehouse = warehouses[0];
                self.rwarehouseLabel.text = [NSString stringWithFormat:@"%@[%@]",warehouse.name,warehouse.code];
                self.rwarehouseLabel.textColor = GXF_CONTENT_COLOR;
                self.rwarehouseUuid = warehouse.uuid;
                self.rwarehouseCode = warehouse.code;
                self.rwarehouseName = warehouse.name;
                self.selectRwarehouse = warehouse.uuid;

            }
            
        };
        [self.delegate pushNextViewController:tvc];
    }else if(indexPath.row == 2){
        ChooseTypeViewController *tvc = [[ChooseTypeViewController alloc]init];
        if (self.selectType.length > 0) {
            tvc.selectStr = self.selectType;
        }
        tvc.choseBaseInfo = ^(NSArray *types){
            if (types.count > 0) {
                NSString *type = types[0];
                self.typeLabel.text = type;
                self.selectType = type;
                self.typeLabel.textColor = GXF_CONTENT_COLOR;
                if ([type isEqualToString:@"紧急"]) {
                    self.type = GXF_Critical;
                }else{
                    self.type = GXF_Normal;
                }
            }
            
        };
        [self.delegate pushNextViewController:tvc];
    }else if(indexPath.row == 5){
        [self startDatePickView];
    }

}
- (void)startDatePickView{
    if (!self.startTimeView) {
        NSString *currentStr  = @"";
        if ([self.arriveDateLabel.text isEqualToString:@"选择预计到货时间"] || self.arriveDateLabel.text.length < 1) {
            currentStr = [IBTCommon stringFromDateWithFormat:[NSDate date] format:@"yyyy-MM-dd HH:mm:ss"];
        }else{
            currentStr = self.arriveDateLabel.text;
        }
        self.startTimeView = [[FinishTimeView alloc] initWithFrame:CGRectMake(0, ScreenSize.height, ScreenSize.width, ScreenSize.height - 64) withDate:currentStr];
        self.startTimeView.delegate = self;
        self.startTimeView.backgroundColor        = RGBA(0, 0, 0 ,0.5);
        [AppWindow addSubview:self.startTimeView];
        
        [UIView animateWithDuration:0.15 animations:^{
            CGRect startFrame =  self.startTimeView.frame;
            startFrame.origin.y =  64;
            self.startTimeView.frame = startFrame;
        } completion:^(BOOL finished) {
            
        }];
    }
}
- (void)cancelTimeView{
    [self clearDatePickView];
}
- (void)okTimeView:(NSString *)time withType:(NSString *)type{
    
    _arriveDateLabel.textColor = GXF_CONTENT_COLOR;
    if (time.length > 15) {
        _arriveDateLabel.text = [time substringToIndex:16];
    }
    self.arriveDate = time;
    // 关闭选择器
    [self clearDatePickView];
}
#pragma mark - 取消
- (void)clearDatePickView{
    [UIView animateWithDuration:0.15 animations:^{
        CGRect startFrame =  self.startTimeView.frame;
        startFrame.origin.y = ScreenSize.height;
        self.startTimeView.frame = startFrame;
    } completion:^(BOOL finished) {
        [self.startTimeView removeFromSuperview];
        self.startTimeView = nil;
    }];
}

- (BOOL)growingTextViewShouldReturn:(HPGrowingTextView *)growingTextView{
    [self.remarkTextView resignFirstResponder];
    return YES;
}
- (BOOL)textFieldShouldReturn:(UITextField *)textField{
    [self.delegate hiddenKeyBoard];
    return YES;
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
