//
//  ICRQSingleSelectViewController.m
//  XFFruit
//
//  Created by Xummer on 6/7/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "ICRQSingleSelectViewController.h"
#import "ICRQuestionManager.h"

static NSString *kCellID = @"cellID";

@interface ICRQSingleSelectViewController ()
<
    UITableViewDataSource,
    UITableViewDelegate
>

@property (strong, nonatomic) IBTTableView *m_tableView;
@property (strong, nonatomic) NSIndexPath *m_currentIndexP;

@end

@implementation ICRQSingleSelectViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    for (NSDictionary *dict in self.m_answer.details) {
        NSIndexPath *indexP =
        [NSIndexPath indexPathForRow:[dict[ @"answer" ] unsignedIntegerValue] inSection:0];
        self.m_currentIndexP = indexP;
        [_m_tableView selectRowAtIndexPath:indexP animated:NO scrollPosition:UITableViewScrollPositionNone];
    }
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private Method

- (void)initScrollViewWithRect:(CGRect)rect {
    
    self.m_tableView = [[IBTTableView alloc] initWithFrame:rect style:UITableViewStylePlain];
    _m_tableView.bHandleKeyboard = YES;
    _m_tableView.backgroundColor = [UIColor clearColor];
    _m_tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    [_m_tableView registerClass:[IBTTableViewCell class] forCellReuseIdentifier:kCellID];
    _m_tableView.dataSource = self;
    _m_tableView.delegate = self;
    
    self.m_contentScrollView = _m_tableView;
    [self.view addSubview:_m_tableView];
}

#pragma mark - UITableViewDataSource

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView
 numberOfRowsInSection:(NSInteger)section
{
    return self.m_question.details.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView
         cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:kCellID forIndexPath:indexPath];
    cell.backgroundColor = [UIColor clearColor];
    [self configureCell:cell forRowAtIndexPath:indexPath];
    
    if (self.m_currentIndexP && self.m_currentIndexP.row == indexPath.row) {
        cell.accessoryType = UITableViewCellAccessoryCheckmark;
    }
    else {
        cell.accessoryType = UITableViewCellAccessoryNone;
    }
    
    return cell;
}

- (void)configureCell:(UITableViewCell *)cell
    forRowAtIndexPath:(NSIndexPath *)indexPath
{

    NSDictionary *dicOptionItem = self.m_question.details [ indexPath.row ];
    cell.textLabel.text = dicOptionItem[ @"content" ];
}

#pragma mark - UITableViewDelegate

- (void)tableView:(UITableView *)tableView
didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [tableView cellForRowAtIndexPath:self.m_currentIndexP];
    cell.accessoryType = UITableViewCellAccessoryNone;
    
    self.m_currentIndexP = indexPath;
    
    cell = [tableView cellForRowAtIndexPath:self.m_currentIndexP];
    cell.accessoryType = UITableViewCellAccessoryCheckmark;

    NSDictionary *dicOptionItem = self.m_arrOptions[ indexPath.row ];
    
    ICRAnswerDetail *dE = [ICRAnswerDetail DBObject];
    dE.numberValue = [dicOptionItem[ @"index" ] unsignedIntegerValue];
    dE.uuid = [[ICRUserUtil sharedInstance] mobileID];
    
    self.m_answer.details = @[ [dE dictForCommit] ];
}

#pragma mark - Actions
- (void)onNextBtnAction:(__unused id)sender {
    
    if ([self.m_answer.details count] <= 0) {
        self.m_answer.bIsAnswered = NO;
        return;
    }
    
    self.m_answer.bIsAnswered = YES;
    
    ICRQuestionManager *mgr = [ICRQuestionManager sharedManager];
    UIViewController *qVC = [mgr questionViewControlAtIndex:self.m_uiIndex + 1];
    if (qVC) {
        [self PushViewController:qVC animated:YES];
    }
    else {
        [self openResultView];
    }
}

@end
