//
//  ReceiveProductViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/10/15.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ReceiveProductViewController.h"
#import "HeaderCell.h"
#import "ReceiveProductCell.h"
#import "PurchaseBillProduct.h"
#define TableHeight 44
#define ShowHeight  130

@interface ReceiveProductViewController ()<UITableViewDataSource,UITableViewDelegate,HeaderCellDelegate>
{
    CGRect _tableFrame;
    NSMutableArray *_selectRowArr;//记录当前选中的cell
}
@end

@implementation ReceiveProductViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor  = XXFBgColor;
    [super viewDidLoad];
    [self initData];
    [self createView];
}
- (void)initData{
    _selectRowArr = [[NSMutableArray alloc]init];
    if (!self.productArr) {
        self.productArr = [NSMutableArray array];
    }
}

- (void)setViewFrame:(CGRect)viewFrame{
    _tableFrame = viewFrame;
}
- (void)createView{
    self.tableView = [[UITableView alloc]initWithFrame:_tableFrame style:(UITableViewStylePlain)];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    self.tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    [self.view addSubview:self.tableView];
    
    NSArray *arr = @[@"商品",@"待收包装量",@"已收包装量"];
    
    HeaderCell *headCell = [[HeaderCell alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 38) withArr:arr withHiddenEdit:self.isHiddenAdd];
    [self.view addSubview:headCell];
    headCell.delegate = self;
    self.tableView.tableHeaderView = headCell;
}

- (void)editClick:(UIButton *)btn{
    TransferPdtDetail *billProduct = self.productArr[btn.tag];
    [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_EditReceiveProduct object:nil userInfo:@{@"transferPdtDetail":billProduct,@"indexPath":@(btn.tag)}];
}
#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.productArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"ReceiveProductCell";
    ReceiveProductCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[ReceiveProductCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        if (self.isHiddenEdit) {
            cell.editBtn.hidden = YES;
        }
    }
    if ([self isHaveIndexPath:indexPath]) {
        cell.smallImageView.image = [UIImage imageNamed:@"arrowdown"];
        CGRect Linefrmame = cell.lineLabel.frame;
        Linefrmame.origin.y = ShowHeight + TableHeight -1;
        cell.lineLabel.frame = Linefrmame;
        CGRect showfrmame = cell.showView.frame;
        showfrmame.size.height = ShowHeight;
        cell.showView.frame = showfrmame;
        cell.backgroundColor = XXFBgColor;
    }else{
        cell.smallImageView.image = [UIImage imageNamed:@"arrowright"];
        CGRect Linefrmame = cell.lineLabel.frame;
        Linefrmame.origin.y = TableHeight-1;
        cell.lineLabel.frame = Linefrmame;
        CGRect showfrmame = cell.showView.frame;
        showfrmame.size.height = 0;
        cell.showView.frame = showfrmame;
        cell.backgroundColor = [UIColor whiteColor];
    }
    cell.editBtn.tag = indexPath.row;
    [cell.editBtn addTarget:self action:@selector(editClick:) forControlEvents:UIControlEventTouchUpInside];
    
    if (self.productArr.count > 0) {
        TransferPdtDetail *billP = self.productArr[indexPath.row];
        [cell setBillProduct:billP row:indexPath.row defaultState:self.defaultState[indexPath.row]];
    }
    return cell;
}
- (BOOL)isHaveIndexPath:(NSIndexPath *)indexPath{
    for (NSIndexPath *path in _selectRowArr) {
        if (path.row == indexPath.row) {
            return YES;
        }
    }
    return NO;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    ReceiveProductCell *cell = (ReceiveProductCell *)[tableView cellForRowAtIndexPath:indexPath];
    CGRect Linefrmame = cell.lineLabel.frame;
    CGRect showfrmame = cell.showView.frame;
    if (Linefrmame.origin.y == TableHeight - 1) {
        cell.smallImageView.image = [UIImage imageNamed:@"arrowdown"];
        
        Linefrmame.origin.y = ShowHeight + TableHeight - 1;
        showfrmame.size.height = ShowHeight;
        cell.backgroundColor = [UIColor whiteColor];
        [_selectRowArr addObject:indexPath];
    }else{
        cell.smallImageView.image = [UIImage imageNamed:@"arrowright"];
        Linefrmame.origin.y = TableHeight -1;
        showfrmame.size.height = 0;
        cell.backgroundColor = [UIColor whiteColor];
        [_selectRowArr removeObject:indexPath];
    }
    cell.lineLabel.frame = Linefrmame;
    cell.showView.frame = showfrmame;
    [self.tableView reloadData];
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    if ([self isHaveIndexPath:indexPath]) {
        return ShowHeight + TableHeight;
    }
    return TableHeight;
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
