//
//  GXFPopNewMaterialView.m
//  XFFruit
//
//  Created by freecui on 15/9/3.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//


//#define GXF_LEFT_MARGIIN 0
//#define GXF_TABLEVIEW_HEADER_HEITHT 50
//#define GXF_TABLEVIEW_FOOT_HEITHT 50


#import "GXFPopNewMaterialViewController.h"
#import "GXFBottomView.h"
#import "GXFTableViewCell.h"
#import "StartTimeView.h"
#import "GXFProcessMaterial.h"
#import "GXFSearchVendorViewController.h"
#import "Product.h"

@interface GXFPopNewMaterialViewController ()<UITableViewDataSource,UITableViewDelegate,UITextFieldDelegate,StartTimeViewDelegate,GXFBottomViewDelegate>
{
    
    StartTimeView *_startTimeView;
}
@property (nonatomic, strong) UIView *c_bgView;
@property (nonatomic, strong) UITableView *c_tableView;
@property (nonatomic, strong) NSArray *d_leftArr;//uitableView左边显示的提示
@property (nonatomic, strong) NSArray *d_rightArr;//右边placeholder提示
@property (nonatomic, strong) NSArray *d_lableTextArr;
@property (nonatomic, strong) GXFProcessMaterial *d_processMaterial;
@property (nonatomic, strong) NSIndexPath *d_dateIndexPath;
@property (nonatomic, assign) BOOL d_hasSaved;
@property (nonatomic, strong) GXFBottomView *c_bottomV;
@property (nonatomic, assign) BOOL d_isEdited;

@end
@implementation GXFPopNewMaterialViewController

- (instancetype)initWithProcessMaterial: (GXFProcessMaterial *)processMaterial
                                 isEdit: (BOOL) isEdited {
    self = [super init];
    if (!self) {
        return nil;
    }
    self.d_processMaterial = processMaterial;
    self.d_isEdited = isEdited;
    return self;
}
- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"新增原料明细";
    [self initData];
    [self initSubViews];
}



- (void)initData {
    self.d_leftArr = @[@"原料商品：",@"入库日期：",@"产地：",@"品质描述：",@"基础数量",@"基础单价：",@"总金额：",@"备注：",];
    self.d_rightArr = @[@"选择商品",@"",@"输入产地",@"输入品质描述",@"基础数量",@"基础单价",@"总金额",@"输入备注内容"];
    self.d_lableTextArr = @[@"斤",@"元",@"元"];
    if (!_d_processMaterial) {
        self.d_processMaterial = [[GXFProcessMaterial alloc]init];
    }
    
}
- (void)initSubViews {
    //self.view.backgroundColor =  RGBA(0, 0, 0, 0.5);
    
//    CGFloat tableVH =  GXF_TABLEVIEW_FOOT_HEITHT + GXF_TABLEVIEW_HEADER_HEITHT + GXF_TABLEVIEW_NOMALCELL_HEIGHT * _d_leftArr.count;
    self.c_tableView = [[UITableView alloc]initWithFrame:CGRectMake(0, 0, self.view.width , GXF_TABLEVIEW_NOMALCELL_HEIGHT * _d_leftArr.count) style:UITableViewStylePlain];

    self.c_tableView.delegate = self;
    self.c_tableView.dataSource = self;
    
    [self.view addSubview:_c_tableView];
    
    
    GXFBottomView *bottomV = [[GXFBottomView alloc]initWithFrame:CGRectMake(0, _c_tableView.bottom, self.view.width, BottomViewHeight) leftButtonColor:GXF_ORIGIN_COLOR rightButtonColor:GXF_GREEN_COLOR LeftBtnTitle:@"删除" rightBtnTitle:@"保存"];// [[GXFBottomView alloc]initWithFrame:CGRectMake(0, _c_tableView.bottom, self.view.width, BottomViewHeight) LeftBtnTitle:@"删除" rightBtnTitle:@"保存"];
    bottomV.delegate = self;
    self.c_bottomV = bottomV;
    [self.view addSubview:_c_bottomV];

    
    
    
}

- (void)viewDidAppear:(BOOL)animated {
   // [self registerForKeyboardNotifications];
}
- (void)viewWillDisappear:(BOOL)animated {
   [[NSNotificationCenter defaultCenter] removeObserver:self];
}
#pragma UITableViewDataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _d_leftArr.count;
}

//- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section {
//    return GXF_TABLEVIEW_HEADER_HEITHT;
//}
//- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section {
//    return GXF_TABLEVIEW_FOOT_HEITHT;
//}
//- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section {
//    UIView *headerView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, _c_tableView.width, GXF_TABLEVIEW_HEADER_HEITHT)];
//    IBTUILabel *lbl = [[IBTUILabel alloc]initWithFrame:headerView.frame Text:@"新增原料明细" textAligment:NSTextAlignmentCenter backgroundColor:GXF_LABLE_BG_COLOR textColor:GXF_LABLE_TINT_COLOR font:GXF_LABLE_FONT];
//    UIButton *btn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(_c_tableView.width - GXF_TABLEVIEW_HEADER_HEITHT, 0, GXF_TABLEVIEW_HEADER_HEITHT, GXF_TABLEVIEW_HEADER_HEITHT) target:self sel:@selector(closeClicked) tag:0 image:nil title:@"关闭" titleColor:[UIColor blackColor] isCorner:NO corner:0 bgColor:nil];
//   
//    [headerView addSubview:lbl];
//     [headerView addSubview:btn];
//    return headerView;
//}
//- (UIView *)tableView:(UITableView *)tableView viewForFooterInSection:(NSInteger)section {
//    UIView *footView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, _c_tableView.width, GXF_TABLEVIEW_HEADER_HEITHT )];
//    GXFBottomView *bottomV = [[GXFBottomView alloc]initWithFrame:footView.frame LeftBtnTitle:@"删除" rightBtnTitle:@"保存"];
//    [footView addSubview:bottomV];
//    return footView;
//}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    GXFTableViewCell *xfCell ;
        xfCell.width = _c_tableView.width;
    if (indexPath.row == 0 || indexPath.row == 1) {
        xfCell = [tableView dequeueReusableCellWithIdentifier:arrowCell];
        if (!xfCell) {
            xfCell = [[GXFTableViewCell alloc]initWithWidth:_c_tableView.width Style:UITableViewCellStyleDefault reuseIdentifier:arrowCell textFieldPlaceholder:_d_rightArr[indexPath.row] isEdit:NO];
            xfCell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
       
        }
    } else if ( indexPath.row == 2 || indexPath.row == 3 || indexPath.row == 7) {
        xfCell = [tableView dequeueReusableCellWithIdentifier:noLblCell];//-
        if (!xfCell) {
            xfCell = [[GXFTableViewCell alloc]initWithWidth:_c_tableView.width Style:UITableViewCellStyleDefault reuseIdentifier:arrowCell textFieldPlaceholder:_d_rightArr[indexPath.row] isEdit:YES];
        }
    
    }else if (indexPath.row == 4 || indexPath.row == 5 || indexPath.row == 6) {
        xfCell = [tableView dequeueReusableCellWithIdentifier:lblCell];  //
        if (!xfCell) {
            xfCell = [[GXFTableViewCell alloc]initWithWidth:_c_tableView.width Style:UITableViewCellStyleDefault reuseIdentifier:lblCell textFieldPlaceholder:_d_rightArr[indexPath.row] hasLable:YES backLableText:_d_lableTextArr[indexPath.row - 4]];
            xfCell.f_textField.keyboardType = UIKeyboardTypeNumbersAndPunctuation;
        }
        
    }
    if (xfCell.f_textField) {
        xfCell.f_textField.delegate = self;
    }

    xfCell.selectionStyle = UITableViewCellAccessoryNone;
    xfCell.f_textField.tag = indexPath.row;
    xfCell.textLabel.text = _d_leftArr[indexPath.row];
    if (_d_isEdited) {
        switch (indexPath.row) {
            case 0:
                xfCell.f_textField.text = [IBTCommon checkNull:_d_processMaterial.productName];
                break;
            case 1:
                
                xfCell.f_textField.text = [IBTCommon checkNull:_d_processMaterial.instockDate];//[NSString stringWithFormat:@"%@",_d_processProduct.outstockDate];
                break;
            case 2:
                xfCell.f_textField.text = [IBTCommon checkNull:_d_processMaterial.place];//_d_processProduct.unit;
                break;
            case 3:
                xfCell.f_textField.text = [IBTCommon checkNull:_d_processMaterial.quality];//[NSString stringWithFormat:@"%@",_d_processProduct.qpc];
                break;
            case 4:
                xfCell.f_textField.text = [IBTCommon checkNull:_d_processMaterial.baseQty];//[NSString stringWithFormat:@"%@",_d_processProduct.quantity];
                break;
            case 5:
                xfCell.f_textField.text = [IBTCommon checkNull:_d_processMaterial.basePrice];//[NSString stringWithFormat:@"%@",_d_processProduct.baseQty];
                break;
            case 6:
                xfCell.f_textField.text = [IBTCommon checkNull:_d_processMaterial.total];//_d_processProduct.remark;
                break;
            case 7:
                xfCell.f_textField.text = [IBTCommon checkNull:_d_processMaterial.remark];//_d_processProduct.remark;
                break;
            default:
                break;
        }
        
    }

    return xfCell;

}
#pragma UITableViewDelegate
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
     GXFTableViewCell *xfCell = (GXFTableViewCell *)[_c_tableView cellForRowAtIndexPath:indexPath];
    if (indexPath.row == 0) {
        GXFSearchVendorViewController *vc = [[GXFSearchVendorViewController alloc]initWithTitle:[IBTCommon localizableString:@"ProductTitle"]];
        vc.choseVendor = ^(NSArray *vendors){
            if (vendors.count > 0) {
                Product *product = vendors[0];
                xfCell.f_textField.text = [NSString stringWithFormat:@"%@[%@]",product.name,product.code];
                _d_processMaterial.productUuid = product.uuid;
                _d_processMaterial.productCode = product.code;
                _d_processMaterial.productName = product.name;
            }
        };
        [self PushViewController:vc animated:YES];
    }
    if (indexPath.row == 1) {
        [self startDatePickView];
        self.d_dateIndexPath = indexPath;
        
    }
}


#pragma StartTimeViewDelegate
- (void)cancelTimeView{
    [self clearDatePickView];
}
- (void)okTimeView:(NSDate *)time{
    GXFTableViewCell *xfCell = (GXFTableViewCell *)[_c_tableView cellForRowAtIndexPath:_d_dateIndexPath];
    xfCell.f_textField.text = [IBTCommon stringFromDate:time]; ;
    self.d_processMaterial.instockDate = time;
    // 关闭选择器
    [self clearDatePickView];
}
#pragma mark - 取消
- (void)clearDatePickView{
    [UIView animateWithDuration:0.15 animations:^{
        CGRect startFrame =  _startTimeView.frame;
        startFrame.origin.y = ScreenSize.height;
        _startTimeView.frame = startFrame;
    } completion:^(BOOL finished) {
        [_startTimeView removeFromSuperview];
        _startTimeView = nil;
    }];
}

- (void)startDatePickView{
    if (!_startTimeView) {
        _startTimeView = [[StartTimeView alloc] initWithFrame:CGRectMake(0, ScreenSize.height, ScreenSize.width, ScreenSize.height - 64)];
        _startTimeView.delegate = self;
        _startTimeView.backgroundColor        = RGBA(0, 0, 0 ,0.5);
        [self.view addSubview:_startTimeView];
        
        [UIView animateWithDuration:0.15 animations:^{
            CGRect startFrame =  _startTimeView.frame;
            startFrame.origin.y =  0;
            _startTimeView.frame = startFrame;
        } completion:^(BOOL finished) {
            
        }];
    }
}

//- (void)textFieldDidBeginEditing:(UITextField *)textField {
//    if (textField.tag == 1) {
//        [textField resignFirstResponder];
//    }
//    CGFloat texfFiledH = GXF_TABLEVIEW_NOMALCELL_HEIGHT * (textField.tag + 1) + 64;
//    CGFloat offset = KeyboardHeight - (ScreenSize.height - texfFiledH) ;
//    if (offset > 0) {
//        [self setTableFrame: offset];
//        
//    }
//  
//}
- (void)textFieldDidEndEditing:(UITextField *)textField {
    [self textFieldShouldReturn:textField];
}
- (BOOL)textFieldShouldReturn:(UITextField *)textField {
   // [self recoverTableViewFrame];
    [textField resignFirstResponder];
    switch (textField.tag) {
        case 0:
            self.d_processMaterial.productName = textField.text;
            break;
        case 1:
           // self.d_processMaterial.productName = textField.text;
            break;
        case 2:
            self.d_processMaterial.place = textField.text;
            break;
        case 3:
            self.d_processMaterial.quality = textField.text;
            break;
        case 4:
            self.d_processMaterial.baseQty = [NSNumber numberWithFloat:[textField.text floatValue]];
            break;
        case 5:
            self.d_processMaterial.basePrice = [NSNumber numberWithFloat:[textField.text floatValue]];;
            break;
        case 6:
            self.d_processMaterial.total = [NSNumber numberWithFloat:[textField.text floatValue]];;
            break;
        case 7:
            self.d_processMaterial.remark = textField.text;
            break;
        default:
            break;
    }
    return YES;
}


#pragma GXFBottomViewDelegate
- (void)bottomViewleftButtonClicked:(UIButton *)leftBtn {
    if (_d_isEdited) {
        [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_deleteMaterial object:_d_processMaterial];
    }
}
- (void)bottomViewRightButtonClicked:(UIButton *)rightBtn {
    self.d_hasSaved = YES;
    [self.c_bottomV.f_rightBtn setBackgroundColor:GXF_GRAY_COLOR];
    if (_d_isEdited) {
        [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_editMaterial object:_d_processMaterial];
    } else {
        [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_saveMaterial object:_d_processMaterial];
    }
    
    

}
//- (void)setTableFrame: (CGFloat)tableOffset {
//    [UIView animateWithDuration:0.25 animations:^{
//        CGRect tableFrame = _c_tableView.frame;
//        tableFrame.origin.y -=  tableOffset;
//        self.c_tableView.frame = tableFrame;
//    }];
//}
//- (void)recoverTableViewFrame {
//    [UIView animateWithDuration:0.25 animations:^{
//        CGRect tableFrame = _c_tableView.frame;
//        tableFrame.origin.y = 0;
//        self.c_tableView.frame = tableFrame;
//    }];
//}

////注册通知观察者
//- (void)registerForKeyboardNotifications {
//    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(keyboardWasShown:) name:UIKeyboardDidShowNotification object:nil];
//    
//    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(keyboardWillBeHidden:) name:UIKeyboardWillHideNotification object:nil];
//}
//
//- (void)keyboardWasShown: (NSNotification *)aNotification {
//    NSDictionary *info = [aNotification userInfo];
//    CGSize kbSize = [[info objectForKey:UIKeyboardFrameBeginUserInfoKey] CGRectValue].size;
//    
//    [UIView animateWithDuration:0.25 animations:^{
//        CGRect tableFrame = _c_tableView.frame;
//        tableFrame.origin.y = kbSize.height;
//    }];
//}
@end
