//
//  ChooseStoreViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/26.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ChooseWarehouseViewController.h"
#define TopMargin 50
#define TableHeight 50
@interface ChooseWarehouseViewController ()

@end

@implementation ChooseWarehouseViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.currentPage = 0;
    self.tableStr = GXF_BASECLASS_WAREHOUSE;
    //记录更新时间
    self.tableView.header.lastUpdatedTimeKey = ChooseWarehouseUpdateDate;
    self.title = @"选择仓库";
    [self fetchDataList:@"" tableStr:GXF_BASECLASS_UserWAREHOUSE];
}

-(void)getBaseDataFromServerWithStartDate:(NSString *)startDate{
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        //请求成功之后
        strongSelf.startDate = startDate;
        [strongSelf getLastDateFromServer:data];
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
        [self endRefreshing];
    };
    if (self.currentPage == 0) {
        [IBTLoadingView showProgressLabel:@"正在加载..."];
    }
    [[ICRHTTPController sharedController] getWarehouseWithStartDate:startDate  Page_number:self.currentPage page_size:100 success:succ failure:fail];
}
- (void)getLastDateFromServer:(id)data
{
    if (data) {
        NSDictionary *pageDict = data[ @"data" ][ @"paging" ];
        NSInteger pageCount = [pageDict[@"pageCount"] integerValue];
        if (pageCount <= self.currentPage) {
            [self endRefreshing];
            [IBTLoadingView hideHUDWithText:nil];
//            [self fetchDataList:@"" tableStr:GXF_BASECLASS_WAREHOUSE];
            self.currentPage = 0;
            [self getUserWareHouseFromServer:self.startDate];
        }else{
            self.currentPage++;
            [self getBaseDataFromServerWithStartDate:self.startDate];
        }
    }else{
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    }
}

- (void)getUserWareHouseFromServer:(NSString *)startDate{
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        //请求成功之后
        strongSelf.startDate = startDate;
        [strongSelf getLastUWDataFromServer:data];
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
        [self endRefreshing];
    };
    [[ICRHTTPController sharedController] downloadUserWarehouseWithStartDate:startDate  Page_number:self.currentPage page_size:100 success:succ failure:fail];
}

- (void)getLastUWDataFromServer:(id)data
{
    if (data) {
        NSDictionary *pageDict = data[ @"data" ][ @"paging" ];
        NSInteger pageCount = [pageDict[@"pageCount"] integerValue];
        if (pageCount <= self.currentPage) {
            [self endRefreshing];
            [IBTLoadingView hideHUDWithText:nil];
            [self fetchDataList:@"" tableStr:GXF_BASECLASS_UserWAREHOUSE];
        }else{
            self.currentPage++;
            [self getUserWareHouseFromServer:self.startDate];
        }
    }else{
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    }
}
#pragma mark - 协议方法
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"MaskCell";
    MaskCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[MaskCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID totalWidth:ScreenSize.width totalHeight:TableHeight];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.Commitbtn.hidden = YES;
    }
    
    if (self.currentIndexPath) {
        if (indexPath.row == self.currentIndexPath.row) {
            cell.Commitbtn.hidden = NO;
            cell.titleLabel.textColor = BASESELECT_COLOR;

        }else{
            cell.Commitbtn.hidden = YES;
            cell.titleLabel.textColor = [UIColor blackColor];

        }
    }else{
        cell.Commitbtn.hidden = YES;
        cell.titleLabel.textColor = [UIColor blackColor];

    }
    if (self.dataArr.count > 0) {
        if (indexPath.row == 0) {
            NSString *dateStr = [self.dataArr[indexPath.row] httpParameterString];
            cell.titleLabel.textColor = GXF_CONTENT_COLOR;
            [cell setTitleStr:[NSString stringWithFormat:@"上次更新时间:%@",dateStr]];
        }else{
            Warehouse *warehouse = self.dataArr[indexPath.row];
            NSString *proStr = [NSString stringWithFormat:@"%@[%@]",warehouse.name,warehouse.code];
            
            [cell setTitleStr:proStr];
        }
    }
    return cell;
}

- (void)boxValueChanged:(NSNotification *)fication{
    NSString *tilkeStr = [IBTCommon trimmingCharacters:self.selectTextFiled.text];
    [self fetchDataList:tilkeStr tableStr:GXF_BASECLASS_WAREHOUSE];
}

- (void)tableViewRefresh:(NSString *)titltstr{
    if (titltstr.length > 0) {
        [super tableViewRefresh:titltstr];
    }else{
        if (self.selectStr.length>0) {
            if (!self.isMoreChose) {
                for (NSInteger i = 1;i< self.dataArr.count; i++) {
                    Warehouse *type = self.dataArr[i];
                    if ([type.uuid isEqualToString:self.selectStr]) {
                        NSIndexPath *indexPath = [NSIndexPath indexPathForRow:i inSection:0];
                        self.currentIndexPath = indexPath;
                        break;
                    }
                }
                [self.tableView reloadData];
            }
        }else{
            [super tableViewRefresh:titltstr];
        }
    }
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
