//
//  IBTUIControl.m
//  XFFruit
//
//  Created by Xummer on 15/4/15.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "IBTUIControl.h"

#define IBT_BTN_HIGHLIGHT_ALPHA      (.6f)

@implementation IBTUIControl

#pragma mark - Life Cycle
- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // Initialization code
    }
    return self;
}

- (void)setHighlighted:(BOOL)highlighted {
    [super setHighlighted: highlighted];
    
    if (_highLightWhenTapped) {
        self.alpha = highlighted ? IBT_BTN_HIGHLIGHT_ALPHA : 1.0f;
    }
}

#pragma mark - Public Method
+ (IBTUIControl *)highLightControl {
    IBTUIControl *control = [[IBTUIControl alloc] init];
    control.highLightWhenTapped = YES;
    return control;
}


@end
