//
//  IBTTableView.h
//  IBTTableViewKit
//
//  Created by Xummer on 15/1/5.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import <UIKit/UIKit.h>

#define IBT_GROUP_CELL_HEIGHT            (44.0f)
#define IBT_GROUP_CELL_TOP_PADDING       (10.0f)
#define IBT_GROUP_CELL_LEFT_PADDING      (15.0f)
#define IBT_GROUP_CELL_TITLE_HEIGHT      (17.0f)
#define IBT_GROUP_SECTION_HEIGHT         (25.0f)
#define IBT_GROUP_CELL_BUTTON_HEIGHT     (44.0f)

@protocol IBTInputViewHandleDelegate;
@interface IBTTableView : UITableView

@property (assign, nonatomic) BOOL bHandleKeyboard;
@property (weak, nonatomic) id <IBTInputViewHandleDelegate> m_inputHandleDelegate;

- (void)setContentInsetTop:(CGFloat)top andBottom:(CGFloat)bottom;

@end

@interface IBTTableView (TableHeaderFooter)

+ (IBTUIView *)headerWithTitle:(NSString *)title
                       topGap:(CGFloat)fTopGap
               containerWidth:(CGFloat)fWidth;

- (IBTUIView *)groupedSectionHeaderWithTitle:(NSString *)title;

- (IBTUIView *)buttonViewWithTitle:(NSString *)title
                             color:(UIColor *)color
                           topGap:(CGFloat)topGap
                          pointer:(UIButton * __autoreleasing *)buttonPointer
                           target:(id)target
                           action:(SEL)selector;

@end