//
//  ICRAttachmentUnit.h
//  XFFruit
//
//  Created by Xummer on 4/19/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTUIControl.h"

typedef NS_ENUM(NSUInteger, AttachmentContentType) {
    kICRTypeUnknow = 0,
    kICRTypeImage,
    kICRTypeVideo,
    kICRTypeAudio,
    
    kICRTypeCustom,
};


typedef NS_ENUM(NSUInteger, AttachmentUnitType) {
    kATTNormal = 0,
    kATTCloseBtn,
};

typedef NS_ENUM(NSUInteger, AttachmentDisplayType) {
    kATTDisplayOutTitle = 0,
    kATTDisplayInnerTitle,
};

#define IBT_ATTACH_UNIT_DEFAULT_WIDTH       (40)
#define IBT_ATTACH_UNIT_TITLE_HEIGHT        (30)
#define IBT_ATTACH_UNIT_DEFAULT_HEIGHT      (IBT_ATTACH_UNIT_DEFAULT_WIDTH + IBT_ATTACH_UNIT_TITLE_HEIGHT)

@interface ICRAttachmentUnit : IBTUIControl
@property (assign, nonatomic) NSUInteger m_uiAttachIndex;
@property (strong, nonatomic) UIButton *m_closeButton;

@property (assign, nonatomic) AttachmentDisplayType m_eCurDisplayType;
@property (assign, nonatomic) AttachmentContentType m_eCurFileType;

@property (strong, nonatomic) id m_oAttachmentWrap;

- (void)updateWithType:(AttachmentUnitType)type
                masker:(UIImage *)masker
           placeHolder:(UIImage *)phImage
                 image:(id)image
                 title:(NSString *)title;

@end
