//
//  UIApplication+CheckFirstRun.m
//  XFFruit
//
//  Created by Xummer on 3/26/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "UIApplication+CheckFirstRun.h"

@implementation UIApplication (CheckFirstRun)

- (BOOL)isFirstRun{
    return [[NSUserDefaults standardUserDefaults] valueForKey:@"version"] == nil;
}

- (BOOL)isFirstRunCurrentVersion {
    if ([self isFirstRun]) {
        return YES;
    }
    else {
        return [[NSUserDefaults standardUserDefaults] floatForKey:@"version"] == [[[[NSBundle mainBundle] infoDictionary] objectForKey:@"CFBundleVersion"] floatValue];
    }
}

- (void)setFirstRun {
    [[NSUserDefaults standardUserDefaults] setFloat:-1 forKey:@"version"];
    [[NSUserDefaults standardUserDefaults] synchronize];
}

- (void)setNotFirstRun {
    [[NSUserDefaults standardUserDefaults] setFloat:[self version] forKey:@"version"];
    [[NSUserDefaults standardUserDefaults] synchronize];
}

- (float)version {
    return [[[[NSBundle mainBundle] infoDictionary] objectForKey:@"CFBundleVersion"] floatValue];
}

@end
