//
//  IBTCustomButtom.m
//  XFFruit
//
//  Created by Xummer on 4/13/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTCustomButtom.h"

@implementation IBTCustomButtom

+ (IBTUIView *)buttonViewWithTitle:(NSString *)title
                             color:(UIColor *)color
                            topGap:(CGFloat)fTopGap
                    containerWidth:(CGFloat)fWidth
                           pointer:(UIButton * __autoreleasing *)buttonPointer
                            target:(id)target
                            action:(SEL)selector
{
    CGFloat fPadding = IBT_GROUP_CELL_LEFT_PADDING;
    
    CGRect rect = CGRectMake(0, 0, fWidth, 0);
    rect.size.height = IBT_GROUP_CELL_BUTTON_HEIGHT + fPadding + (fTopGap > 0 ? fTopGap : fPadding);
    IBTUIView *view = [[IBTUIView alloc] initWithFrame:rect];
    view.backgroundColor = [UIColor clearColor];
    
    rect = view.bounds;
    if (fTopGap > 0) {
        rect.origin.y = fTopGap - fPadding;
        rect.size.height -= CGRectGetMinY(rect);
    }
    
    UIButton *button =
    [[self class] buttonWithTitle:title color:color target:target action:selector];
    button.frame = CGRectInset(rect, fPadding, fPadding);

    [view addSubview:button];
    
    if (buttonPointer) {
        *buttonPointer = button;
    }
    
    return view;
}

+ (UIButton *)buttonWithTitle:(NSString *)title
                        color:(UIColor *)color
                       target:(id)target
                       action:(SEL)selector
{
    IBTCustomButtom *button = [IBTCustomButtom buttonWithType:UIButtonTypeCustom];
    [button setTitle:title forState:UIControlStateNormal];
    [button setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    button.layer.cornerRadius = IBT_BTN_CORNER_RADIUS;
    button.layer.masksToBounds = YES;
    [button setBackgroundImage:[UIImage imageWithColor:color ? : ICR_TINTCOLOR]
                      forState:UIControlStateNormal];
    [button setBackgroundImage:[UIImage imageWithColor:ICR_DISABLE_BTN_COLOR]
                      forState:UIControlStateDisabled];
    button.titleLabel.font = [UIFont boldSystemFontOfSize:17];
    [button addTarget:target action:selector forControlEvents:UIControlEventTouchUpInside];
    
    return button;
}


+ (UIButton *)creatButtonWithFrame:(CGRect)frame target:(id)target sel:(SEL)sel tag:(NSInteger)tag image:(NSString *)name title:(NSString *)title titleColor:(UIColor *)titleCorlor isCorner:(BOOL)isCornor corner:(CGFloat)corner bgColor:(UIColor *)bgcolor{
    
    UIButton *button = nil;
    button = [UIButton buttonWithType:UIButtonTypeCustom];
    if (name) {//创建图片按钮
        [button setImage:[UIImage imageNamed:name] forState:UIControlStateNormal];
        if (title) {
            //创建 图片 和 标题按钮
            [button setTitle:title forState:UIControlStateNormal];
            [button setTitleColor:titleCorlor forState:UIControlStateNormal];
        }
    }else if(title){//创建标题按钮
        [button setBackgroundColor:bgcolor];
        [button setTitle:title forState:UIControlStateNormal];
        [button setTitleColor:titleCorlor forState:UIControlStateNormal];
    }
    
    button.frame = frame;
    button.tag = tag;
    if (isCornor) {
        button.layer.cornerRadius = corner;
        button.layer.masksToBounds = YES;
    }
    [button addTarget:target action:sel forControlEvents:UIControlEventTouchUpInside];
    return button;
}


@end
