//
//  BusinessViewController.m
//  XFFruit
//
//  Created by mac on 15/8/13.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "BusinessViewController.h"

#import "ICRAnnouncementViewController.h"
#import "NewSurveyViewController.h"
#import "SurveyViewController.h"

#import "ICRFunctionBaseView.h"
#import "ICRFunctionEntity.h"
#import "ICRFunctionBaseView.h"

#import "NewPurchaseNoticeViewController.h"
#import "SeePurchaseNoticeViewController.h"


#import "NewPurchaseViewController.h"
#import "PurchaseViewController.h"
#import "NewTransportViewController.h"
#import "TransportViewController.h"
#import"PurchaseNoticeViewController.h"

#import "NewTransferViewController.h"
#import "TransferViewController.h"
#import "ReceiveViewController.h"

#import "GXFFunctionDB.h"
#import "GXFNewProcessViewController.h"
#import "GXFListProcessViewController.h"
@interface BusinessViewController ()<ICRFunctionBaseViewDelegate,UITableViewDataSource,UITableViewDelegate>
@property (nonatomic, strong) ICRFunctionBaseView *c_functionBaseView;
@property (nonatomic, strong) UITableView *c_tableView;

@end

@implementation BusinessViewController

- (void)viewDidLoad {
    [super viewDidLoad];

    [self setupSubviews];
//    self.navigationItem.leftBarButtonItem = [[UIBarButtonItem alloc]initWithTitle:@"收货单" style:UIBarButtonItemStylePlain target:self action:@selector(receiveClick:)];
    
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)setupFunctionBaseView {
    NSMutableArray *funtionEntitlesArr = [NSMutableArray array];
    
    NSArray *arrFunctions = [NSArray arrayWithArray:[[GXFFunctionDB sharedInstance] displayFunctionsHasPermission]];
    for (GXFDisplayFunction *displayFunction in arrFunctions) {
        ICRFunctionEntity *functionEntity = [[ICRFunctionEntity alloc]init];
        functionEntity.functionName = displayFunction.functionName;
        functionEntity.iconName = displayFunction.functionImgName;
        functionEntity.functionItemTag = displayFunction.functionItemTag;
        [funtionEntitlesArr addObject:functionEntity];
    }
    
    self.c_functionBaseView = [ICRFunctionBaseView initWithFunctionData:funtionEntitlesArr];
    _c_functionBaseView.frame = (CGRect){
        .origin.x = 0,
        .origin.y =0,
        .size.width = CGRectGetWidth(self.view.frame),
        .size.height = _c_functionBaseView.height};//CGRectGetHeight(self.view.frame),};
    _c_functionBaseView.backgroundColor = [UIColor clearColor];
    _c_functionBaseView.m_delegate = self;
    
}

-(void)setupSubviews
{
    
    self.c_tableView = [[UITableView alloc]initWithFrame:CGRectMake(0, 0, self.view.width, self.view.height - 64) style:UITableViewStyleGrouped];
    self.c_tableView.delegate = self;
    self.c_tableView.dataSource = self;
    [self.view addSubview:_c_tableView];
    
    [self setupFunctionBaseView];
    

}

#pragma UITableViewDataSource 
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return 1;
}
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section {
    return 1;
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return _c_functionBaseView.height + 44 ;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellId = @"cellId";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellId];
    if (!cell) {
        cell = [[UITableViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellId];
    }
    [cell.contentView addSubview:_c_functionBaseView];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    return cell;
}
#pragma mark - ICRFunctionBaseViewDelegate
- (void)ICRFunctionBaseView:(ICRFunctionItemControl *)imageView {
    /*
     kFunctionAnnouncement = 0,
     kFunctionTaskManagement,
     kFunctionPatrolPlan,
     kFunctionMyShop,
     */
    switch (imageView.tag) {
        case kFunctionNotice://公告
        {
            ICRAnnouncementViewController *aVC = [[ICRAnnouncementViewController alloc] init];
            [self PushViewController:aVC animated:YES];
        }
            break;
        case kFunctionNewSurvey://新建行情
        {
            NewSurveyViewController *svc = [[NewSurveyViewController alloc] init];
            svc.navTitle = @"新建行情调研";
            [self PushViewController:svc animated:YES];
        }
            break;
        case kFunctionSeeSurvey://查看行情
        {
            SurveyViewController *svc = [[SurveyViewController alloc] init];
            svc.title = [IBTCommon localizableString:@"Survey"];
            svc.navigationItem.hidesBackButton = YES;
            [self PushViewController:svc animated:YES];
        }
            break;
        case kFunctionNewPurchaseNotice://新建采购通知单
        {
            NewPurchaseNoticeViewController *svc = [[NewPurchaseNoticeViewController alloc] init];
            svc.title = [IBTCommon localizableString:@"Survey2"];
            [self PushViewController:svc animated:YES];
        }
            break;
        case kFunctionSeePurchaseNotice://查看采购通知单
        {
            PurchaseNoticeViewController *svc =
            [[PurchaseNoticeViewController alloc] init];
            svc.title = [IBTCommon localizableString:@"Survey3"];
            [self PushViewController:svc animated:YES];
        }
            break;
            
        case kFunctionNewPurchase://新建采购单
        {
            NewPurchaseViewController *nvc = [[NewPurchaseViewController alloc]init];
            nvc.title = @"新建采购单";
            [self PushViewController:nvc animated:YES];
            
        }
            break;
        case kFunctionSeePurchase:{
            PurchaseViewController *pvc = [[PurchaseViewController alloc]init];
            pvc.title = @"采购单";
            [self PushViewController:pvc animated:YES];
        }
            break;
            
        case kFunctionNewShipment://任务管理
        {
            NewTransportViewController *tVC = [[NewTransportViewController alloc] init];
            tVC.title = @"新建发运单";
            [self PushViewController:tVC animated:YES];
        }
            break;
        case kFunctionSeeShipment://任务管理
        {
            TransportViewController *tVC = [[TransportViewController alloc] init];
            tVC.title = @"发运单";
            [self PushViewController:tVC animated:YES];
        }
            break;
        case kFunctionExaminePurchase:
        {
            PurchaseViewController *tVC = [[PurchaseViewController alloc] init];
            tVC.title = @"供应商确认采购单";
            tVC.assessorVendor = [ICRUserUtil sharedInstance].userId;
            [self PushViewController:tVC animated:YES];
        }
            break;
            
        case kFunctionNewTransfer://新建转运单
        {
            NewTransferViewController *tVC = [[NewTransferViewController alloc] init];
            tVC.title = @"新建转运单";
            [self PushViewController:tVC animated:YES];
        }
            break;
        case kFunctionSeeTransfer://转运单列表
        {
            TransferViewController *tVC = [[TransferViewController alloc] init];
            tVC.title = @"转运单";
            [self PushViewController:tVC animated:YES];
        }
            break;
 
        case kFunctionNewProcessing:{
            GXFNewProcessViewController *pvc = [[GXFNewProcessViewController alloc]init];
            //pvc.title = @"采购单";
            [self PushViewController:pvc animated:YES];
        }
            break;
        case kFunctionSeeProcessing:{
            GXFListProcessViewController *seeProcessVC= [[GXFListProcessViewController alloc]init];
            [self PushViewController:seeProcessVC animated:YES];
        }
            break;

        case kFunctionSeeReceive://收货单
        {
            ReceiveViewController *tVC = [[ReceiveViewController alloc] init];
            tVC.title = @"收货单";
            [self PushViewController:tVC animated:YES];
        }
            break;
            

        default:
            return;
            break;
    }
}
- (void)receiveClick:(UIBarButtonItem *)item{
    ReceiveViewController *tVC = [[ReceiveViewController alloc] init];
    tVC.title = @"收货单";
    [self PushViewController:tVC animated:YES];
}

//-(void)initView
//{
//    NSArray *butArray=[[NSArray alloc]initWithObjects:@"公告", @"新建行情调研",@"查看行情调研",@"填写行情反馈",@"新建采购通知",@"查看采购通知",@"新建采购单",@"查看采购单",@"审核采购单",@"新建发运单",@"查看发运单",@"新建加工单",nil];
//    for (int i=0; i<butArray.count; i++) {
//        UIButton *but=[UIButton buttonWithType:UIButtonTypeCustom];
//        but.frame=CGRectMake(15+i%3*(90+10),10+(i/3)*(100+10) , 90, 90) ;
//        //        but.titleLabel.text=[NSString stringWithFormat:@"%@",[butArray objectAtIndex:i]];
//        NSString *str=[butArray objectAtIndex:i];
//        [but setTitle:str forState:UIControlStateNormal];
//        but.backgroundColor=[UIColor redColor];
//        [self .view addSubview:but];
//        
//    }
//    
//}

@end
