//
//  SurveyListCell.m
//  XFFurit
//
//  Created by 陈俊俊 on 15/8/1.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "SurveyListCell.h"

#define TitleSize 16
#define ContentSize 14
#define TitleColor @"444444"
#define ContentColor @"aaaaaa"
#define LeftMargin 90
#define TopMargin 10
#define TitleHeight 20
#define TableHeight 120
@implementation SurveyListCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout
{
    self.stateBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    self.stateBtn.frame = CGRectMake(TopMargin *2 , TopMargin, LeftMargin - TopMargin*3, 20);
    self.stateBtn.titleLabel.font = FontSize(ContentSize);
    [self.stateBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    self.stateBtn.enabled = NO;
    
    self.titleLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, TopMargin, ScreenSize.width - LeftMargin, TitleHeight))];
    self.titleLabel.textColor = HexColor(TitleColor);
    self.titleLabel.font = FontSize(TitleSize);
    
    self.billnumberLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, CGRectGetMaxY(self.titleLabel.frame), ScreenSize.width - LeftMargin, TitleHeight))];
    self.billnumberLabel.textColor = HexColor(ContentColor);
    self.billnumberLabel.font = FontSize(ContentSize);
    
    self.productnameLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, CGRectGetMaxY(self.billnumberLabel.frame), ScreenSize.width - LeftMargin, TitleHeight))];
    self.productnameLabel.textColor = HexColor(ContentColor);
    self.productnameLabel.font = FontSize(ContentSize);
    
    
    self.begindateLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, CGRectGetMaxY(self.productnameLabel.frame), ScreenSize.width - LeftMargin, TitleHeight))];
    self.begindateLabel.textColor = HexColor(ContentColor);
    self.begindateLabel.font = FontSize(ContentSize);
    
    self.enddateLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, CGRectGetMaxY(self.begindateLabel.frame), ScreenSize.width - LeftMargin, TitleHeight))];
    self.enddateLabel.textColor = HexColor(ContentColor);
    self.enddateLabel.font = FontSize(ContentSize);
    
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin,TableHeight-1, ScreenSize.width - LeftMargin - TopMargin * 2, 1))];;
    self.lineLabel.backgroundColor = HexColor(@"e5e5e5");
    
    [self.contentView addSubview:self.stateBtn];
    [self.contentView addSubview:self.titleLabel];
    [self.contentView addSubview:self.billnumberLabel];
    [self.contentView addSubview:self.productnameLabel];
    [self.contentView addSubview:self.begindateLabel];
    [self.contentView addSubview:self.enddateLabel];
    [self.contentView addSubview:self.lineLabel];

}


- (void)setSurvey:(Survey *)survey{
    self.titleLabel.text = survey.title;
    self.billnumberLabel.text = [NSString stringWithFormat:@"单号：%@",survey.billNumber];
    self.productnameLabel.text = [NSString stringWithFormat:@"商品：%@[%@]",survey.productName,survey.productCode];
    self.begindateLabel.text = [NSString stringWithFormat:@"开始时间：%@",[survey.beginDate substringToIndex:10]];
    self.enddateLabel.text = [NSString stringWithFormat:@"结束时间：%@",[survey.endDate substringToIndex:10]];
    NSString *stateStr = @"";
    if ([survey.state isEqualToString:@"initial"]) {
        stateStr = @"未提交";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"initial"]  forState:UIControlStateDisabled];
    }else if ([survey.state isEqualToString:@"submitted"]) {
        stateStr = @"已提交";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"insurvey"] forState:UIControlStateDisabled];
    }else if ([survey.state isEqualToString:@"insurvey"]) {
        stateStr = @"调研中";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"insurvey"] forState:UIControlStateDisabled];
        
    }else if ([survey.state isEqualToString:@"finished"]) {
        stateStr = @"已完成";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"finish"] forState:UIControlStateDisabled];
    }
    [self.stateBtn setTitle:stateStr forState:UIControlStateNormal];
    
}
- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];
}

@end
