//
//  IBTConstants.h
//  AceMTer
//
//  Created by Xummer on 2/27/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#ifndef AceMTer_IBTConstants_h
#define AceMTer_IBTConstants_h

#import "IBTUIKit.h"

/*
 * Clog
 */
#ifdef DEBUG
#define CLog(format, ...) NSLog((@"[Line %d] %s " format), __LINE__, __PRETTY_FUNCTION__, ## __VA_ARGS__)
#else
#define CLog(format, ...)
#endif


/*
 * Defualt Height
 */
#define IBT_STATUSBAR_HEIGHT             (20.0f)
#define IBT_TOPBAR_HEIGHT                (44.0f)
#define IBT_BOTTOMBAR_HEIGHT             (45.0f)
#define IBT_SEARCH_BAR_HEIGHT            (44.0f)
#define IBT_SWITCH_WIDTH                 (51.0f)
#define IBT_SWITCH_HEIGHT                (31.0f)
#define IBT_KEYBOARD_HEIGHT              (216.0f)
#define IBT_KEYBOARD_ANIMATION_DURATION  (0.25f)
#define IBT_KEYBOARD_ANIMATION_CURVE     (7)
#define IBT_CELL_HEIGHT                  (44.0f)

#define IBT_DEFAULT_CELL_HEIGHT          (44.0f)
#define IBT_GROUP_CELL_HEIGHT            (44.0f)
#define IBT_GROUP_CELL_TOP_PADDING       (10.0f)
#define IBT_GROUP_CELL_LEFT_PADDING      (15.0f)
#define IBT_GROUP_CELL_TITLE_HEIGHT      (17.0f)
#define IBT_GROUP_SECTION_HEIGHT         (25.0f)
#define IBT_GROUP_CELL_BUTTON_HEIGHT     (44.0f)

#define IBT_GOLDEN_RATIO                 (0.618f)
#define IBT_BTN_CORNER_RADIUS            (2.0f)
#define IBT_DEFAULT_CORNER_RADIUS        (3.0f)

/*
 * Version
 */
#define IBT_SYSTEM_VERSION_STR       ([[UIDevice currentDevice] systemVersion])
#define IBT_APP_VERSION_STR          ([[NSBundle mainBundle] infoDictionary][ @"CFBundleShortVersionString" ])
#define IBT_APP_BUILD_STR            ([[NSBundle mainBundle] infoDictionary][ @"CFBundleVersion" ])
#define IBT_APP_NAME_STR             ([[NSBundle mainBundle] infoDictionary][ @"CFBundleDisplayName"])
#define IBT_IOS7_OR_LATER            ([[[UIDevice currentDevice] systemVersion] compare:@"7.0"] != NSOrderedAscending)
#define IBT_VERSION_ABOVE(version)   ([[[UIDevice currentDevice] systemVersion] compare:version] != NSOrderedAscending)
#define IBT_IS_IPAD                  ([[UIDevice currentDevice] respondsToSelector:@selector(userInterfaceIdiom)] && \
[[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPad)

/*
 * Size
 */
// 屏幕宽度
#define IBT_MAIN_SCREEN_WIDTH        ([[UIScreen mainScreen] bounds].size.width)

// 屏幕高度
#define IBT_MAIN_SCREEN_HEIGHT       ([[UIScreen mainScreen] bounds].size.height)

#define IBT_IPHONE5                  ([UIScreen instancesRespondToSelector:@selector(currentMode)] ? CGSizeEqualToSize(CGSizeMake(640, 1136), [[UIScreen mainScreen] currentMode].size) : NO)
#define IBT_ROOT_VIEW_WIDTH          ([UIApplication sharedApplication].keyWindow.frame.size.width)
#define IBT_ROOT_VIEW_HEIGHT         ([UIApplication sharedApplication].keyWindow.rootViewController.view.frame.size.height)

// Color
#define IBT_TINTCOLOR                [UIColor colorWithR:63 g:134 b:244 a:1]
#define IBT_CELL_GREY_LINE_COLOR     [UIColor colorWithW:233 a:1]
// Regular Expressions
#define IBT_USER_NAME_REGEX  @"^[A-Za-z][\\w\\.]{2,15}$"
#define IBT_PASSWORD_REGEX   @"^[A-Za-z0-9]+$"

/*
 * Custom
 */
#define IBT_BIN_HIGHLIGHT_ALPHA   (.6f)


#define XXFBgColor  RGBA(246,246,246,1)
#define HexColor(colorStr)  [UIColor colorWithHexString:colorStr]
#define RGBA(R,G,B,A) [UIColor colorWithRed:R/255.0f green:G/255.0f blue:B/255.0f alpha:A]
#define ScreenSize ([[UIScreen mainScreen] bounds].size)
#define IOS7 ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7.0)
#define FontSize(num) [UIFont systemFontOfSize:num]
#define AppWindow [[UIApplication sharedApplication].delegate window]



#endif
