//
//  UITableViewCell+Helper.m
//  CXA
//
//  Created by Xummer on 14-3-19.
//  Copyright (c) 2014年 Xummer. All rights reserved.
//

#import "UITableViewCell+Helper.h"

@implementation UITableViewCell (Helper)

+ (UINib *)nib {
    return [UINib nibWithNibName:NSStringFromClass([self class]) bundle:nil];
}

+ (id)cellFromNib {
    NSArray *array =
    [[NSBundle mainBundle] loadNibNamed:NSStringFromClass([self class])
                                  owner:self
                                options:nil];
    return [array firstObject];
}

+ (CGFloat)getCellHeight {
    UITableViewCell *cell = [[self class] cellFromNib];
    return CGRectGetHeight(cell.frame);
}

+ (NSString *)reuseIdentifier {
    return NSStringFromClass([self class]);
}

@end
