//
//  RPassgerView.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/13.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "RPassgerView.h"
#import "SMPageControl.h"
#define LeftWidth   50
#define ImageSize 20
#define ContentHeight 25
#define TopWidth 200
#define CenImageSize 40

@interface RPassgerView ()
@property (nonatomic,strong)SMPageControl *pageControl;
@property (nonatomic,assign)NSInteger currentPage;
@end
@implementation RPassgerView
- (instancetype)initWithFrame:(CGRect)frame{
    self = [super initWithFrame:frame];
    if (self) {
        [self bulidLayout];
    }
    return self;
}
- (instancetype)initWithFrame:(CGRect)frame withPage:(NSInteger)currentPage{
    self = [super initWithFrame:frame];
    if (self) {
        self.currentPage = currentPage;
        [self bulidLayout];
    }
    return self;
}
- (void)bulidLayout{
    
    CGRect rect = CGRectMake(0, 0, self.width, self.height);
    
    self.bgImage = [[UIImageView alloc]initWithFrame:rect];
    [self addSubview:self.bgImage];
    
    rect = CGRectMake(self.width/4, 20, CenImageSize, CenImageSize);
    
    self.cenImage = [[UIImageView alloc]initWithFrame:rect];
    self.cenImage.contentMode = UIViewContentModeScaleAspectFit;
    [self addSubview:self.cenImage];
    
    
    rect = CGRectMake(self.cenImage.right+5, 20, ScreenSize.width - self.cenImage.right, ContentHeight);
    self.centerLabel = [[UILabel alloc]initWithFrame:rect];
    self.centerLabel.textColor = ReportContentColor;
    self.centerLabel.font = FontSize(28);
    [self addSubview:self.centerLabel];
    
    
    rect = CGRectMake(self.centerLabel.left, self.centerLabel.bottom,self.width-self.centerLabel.left, ContentHeight);
    self.dateLabel = [[UILabel alloc]initWithFrame:rect];
    self.dateLabel.textColor = [UIColor lightGrayColor];
    self.dateLabel.font =  GXF_THREETEENTH_SIZE;
    self.dateLabel.textAlignment = NSTextAlignmentLeft;
    [self addSubview:self.dateLabel];


    
    CGFloat bottomWidth = (ScreenSize.width - 20*2)/2;
    
    rect = CGRectMake(20, self.dateLabel.bottom,bottomWidth, ContentHeight);
    self.lastWeekLabel = [IBTCommon buttonWithTitle:@"" Image:nil frame:rect fontSize:15 fontColor:[UIColor lightGrayColor]];
    self.lastWeekLabel.enabled = NO;
    [self addSubview:self.lastWeekLabel];
    
    
    rect = CGRectMake(self.lastWeekLabel.left, self.lastWeekLabel.bottom,bottomWidth,20);
    UILabel *weekLabel = [[UILabel alloc]initWithFrame:rect];
    weekLabel.textColor = [UIColor lightGrayColor];
    weekLabel.text = @"比上周同期";
    weekLabel.textAlignment = NSTextAlignmentCenter;
    weekLabel.font = GXF_THREETEENTH_SIZE;
    [self addSubview:weekLabel];
    
    
    rect = CGRectMake(self.lastWeekLabel.right,self.dateLabel.bottom,bottomWidth, ContentHeight);
    self.lastYearLabel = [IBTCommon buttonWithTitle:@"" Image:nil frame:rect fontSize:15 fontColor:[UIColor lightGrayColor]];
    self.lastYearLabel.enabled = NO;
    [self addSubview:self.lastYearLabel];
    
    
    rect = CGRectMake(self.lastWeekLabel.right, self.lastYearLabel.bottom,bottomWidth,20);
    UILabel *yearLabel = [[UILabel alloc]initWithFrame:rect];
    yearLabel.textColor = [UIColor lightGrayColor];
    yearLabel.textAlignment = NSTextAlignmentCenter;
    yearLabel.text = @"比去年同期";
    yearLabel.font = GXF_THREETEENTH_SIZE;
    [self addSubview:yearLabel];
    
    self.pageControl = [[SMPageControl alloc]initWithFrame:CGRectMake(0, yearLabel.bottom+5, ScreenSize.width, 10)];
    self.pageControl.numberOfPages = 4;

    self.pageControl.currentPage = self.currentPage;
    self.pageControl.pageIndicatorImage = [UIImage imageNamed:@"white_point"];
    self.pageControl.currentPageIndicatorImage = [UIImage imageNamed:@"yellow_point"];
    self.pageControl.indicatorMargin = 5.0f;
    self.pageControl.indicatorDiameter = 10.0f;
    [self addSubview:self.pageControl];
}


//客流
- (void)setPassengerWithCompass:(Compass *)compass{

    //客流数
    self.centerLabel.text = compass.passenger?[compass.passenger stringValue]:@"---" ;

    //客流统计时间
    NSString *weekday = @"";
    if ([IBTCommon convertToDateFrom:compass.passengerdate]) {
        weekday = [IBTCommon weekdayStringFromDate:[IBTCommon convertToDateFrom:compass.passengerdate]];
    }
    self.dateLabel.text = compass.passengerdate?[NSString stringWithFormat:@"%@%@累计客流量",compass.passengerdate,weekday]:@"无";
    //客流数环比变化率
    if ([compass.passengerChainSign isEqualToString:ReportChainSignPlus]) {
        [self.lastWeekLabel setImage:[UIImage imageNamed:ReportChainPlusImage] forState:UIControlStateDisabled];
         [self.lastWeekLabel setTitleColor:ReportContentColor forState:UIControlStateDisabled];
    }else if ([compass.passengerChainSign isEqualToString:ReportChainSignMinus]){
        [self.lastWeekLabel setImage:[UIImage imageNamed:ReportChainMinusImage] forState:UIControlStateDisabled];
         [self.lastWeekLabel setTitleColor:GXF_SAVE_COLOR forState:UIControlStateDisabled];
    }
    NSString *salesYoStr = compass.passengerChainRate?[NSString stringWithFormat:@"%@%%",compass.passengerChainRate]:@"---";
    [self.lastWeekLabel setTitle:salesYoStr forState:UIControlStateNormal];

    //客流数同比变化率
    if ([compass.passengerYoYSign isEqualToString:ReportChainSignPlus]) {
        [self.lastYearLabel setImage:[UIImage imageNamed:ReportChainPlusImage] forState:UIControlStateDisabled];
         [self.lastYearLabel setTitleColor:ReportContentColor forState:UIControlStateDisabled];
    }else if ([compass.passengerYoYSign isEqualToString:ReportChainSignMinus]){
        [self.lastYearLabel setImage:[UIImage imageNamed:ReportChainMinusImage] forState:UIControlStateDisabled];
         [self.lastYearLabel setTitleColor:GXF_SAVE_COLOR forState:UIControlStateDisabled];
    }
    NSString *passengerYoYRateStr = compass.passengerYoYRate?[NSString stringWithFormat:@"%@%%",compass.passengerYoYRate]:@"---";
    [self.lastYearLabel setTitle:passengerYoYRateStr forState:UIControlStateNormal];
}
//客单价
- (void)setPersalesWithCompass:(Compass *)compass{
    //客单价
    self.centerLabel.text = compass.persales?[compass.persales stringValue]:@"---";

    //客单价统计时间
    NSString *weekday = @"";
    if ([IBTCommon convertToDateFrom:compass.persalesdate]) {
        weekday = [IBTCommon weekdayStringFromDate:[IBTCommon convertToDateFrom:compass.persalesdate]];
    }
    self.dateLabel.text = compass.persalesdate?[NSString stringWithFormat:@"%@%@累计客单价",compass.persalesdate,weekday]:@"无";
    //客单价环比变化率
    if ([compass.persalesChainSign isEqualToString:ReportChainSignPlus]) {
        [self.lastWeekLabel setImage:[UIImage imageNamed:ReportChainPlusImage] forState:UIControlStateDisabled];
        [self.lastWeekLabel setTitleColor:ReportContentColor forState:UIControlStateDisabled];
    }else if ([compass.persalesChainSign isEqualToString:ReportChainSignMinus]){
        [self.lastWeekLabel setImage:[UIImage imageNamed:ReportChainMinusImage] forState:UIControlStateDisabled];
        [self.lastWeekLabel setTitleColor:GXF_SAVE_COLOR forState:UIControlStateDisabled];
    }
    NSString *salesYoStr = compass.persalesChainRate?[NSString stringWithFormat:@"%@%%",compass.persalesChainRate]:@"---";
    [self.lastWeekLabel setTitle:salesYoStr forState:UIControlStateNormal];
    
    //客单价同比变化率
    if ([compass.persalesYoYSign isEqualToString:ReportChainSignPlus]) {
        [self.lastYearLabel setImage:[UIImage imageNamed:ReportChainPlusImage] forState:UIControlStateDisabled];
        [self.lastYearLabel setTitleColor:ReportContentColor forState:UIControlStateDisabled];
    }else if ([compass.persalesYoYSign isEqualToString:ReportChainSignMinus]){
        [self.lastYearLabel setImage:[UIImage imageNamed:ReportChainMinusImage] forState:UIControlStateDisabled];
        [self.lastYearLabel setTitleColor:GXF_SAVE_COLOR forState:UIControlStateDisabled];
    }
    NSString *passengerYoYRateStr = compass.persalesYoYRate?[NSString stringWithFormat:@"%@%%",compass.persalesYoYRate]:@"---";
    [self.lastYearLabel setTitle:passengerYoYRateStr forState:UIControlStateNormal];
}
//毛利率
- (void)setGrossprofitWithCompass:(Compass *)compass{
    //毛利率
    self.centerLabel.text = compass.grossprofit?[compass.grossprofit stringValue]:@"---";

    //毛利率统计时间
    NSString *weekday = @"";
    if ([IBTCommon convertToDateFrom:compass.grossprofitdate]) {
        weekday = [IBTCommon weekdayStringFromDate:[IBTCommon convertToDateFrom:compass.grossprofitdate]];
    }
    self.dateLabel.text = compass.grossprofitdate?[NSString stringWithFormat:@"%@%@累计毛利率",compass.grossprofitdate,weekday]:@"无";
    //毛利率环比变化率
    if ([compass.grossprofitChainSign isEqualToString:ReportChainSignPlus]) {
        [self.lastWeekLabel setImage:[UIImage imageNamed:ReportChainPlusImage] forState:UIControlStateDisabled];
        [self.lastWeekLabel setTitleColor:ReportContentColor forState:UIControlStateDisabled];
    }else if([compass.grossprofitChainSign isEqualToString:ReportChainSignMinus]){
        [self.lastWeekLabel setImage:[UIImage imageNamed:ReportChainMinusImage] forState:UIControlStateDisabled];
        [self.lastWeekLabel setTitleColor:GXF_SAVE_COLOR forState:UIControlStateDisabled];
    }
    NSString *salesYoStr = compass.grossprofitChainRate?[NSString stringWithFormat:@"%@%%",compass.grossprofitChainRate]:@"---";
    [self.lastWeekLabel setTitle:salesYoStr forState:UIControlStateNormal];
    
    //毛利率同比变化率
    if ([compass.grossprofitYoYSign isEqualToString:ReportChainSignPlus]) {
        [self.lastYearLabel setImage:[UIImage imageNamed:ReportChainPlusImage] forState:UIControlStateDisabled];
        [self.lastYearLabel setTitleColor:ReportContentColor forState:UIControlStateDisabled];
    }else if ([compass.grossprofitYoYSign isEqualToString:ReportChainSignMinus]){
        [self.lastYearLabel setImage:[UIImage imageNamed:ReportChainMinusImage] forState:UIControlStateDisabled];
        [self.lastYearLabel setTitleColor:GXF_SAVE_COLOR forState:UIControlStateDisabled];
    }
    NSString *passengerYoYRateStr = compass.grossprofitYoYRate?[NSString stringWithFormat:@"%@%%",compass.grossprofitYoYRate]:@"---";
    [self.lastYearLabel setTitle:passengerYoYRateStr forState:UIControlStateNormal];
}


@end
