//
//  GXFProcessViewController.m
//  XFFruit
//
//  Created by freecui on 15/9/1.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//



#import "GXFNewProcessViewController.h"
#import "GXFBottomView.h"
#import "GXFTableViewCell.h"
#import "GXFButtonAndLineView.h"
#import "GXFSearchVendorViewController.h"
#import "Vendor.h"
#import "Warehouse.h"
#import "GXFProcessBill.h"
#import "GXFProcessMaterial.h"
#import "GXFProcessProduct.h"
#import "GXFPopNewMaterialViewController.h"
#import "GXFPopNewProductViewController.h"

#import "GXFProcessMaterialTableViewCell.h"
#import "GXFProcessProductTableViewCell.h"
#import "ProductBillCell.h"
typedef NS_ENUM(NSUInteger, processType){
    kMaterial = 0,
    kProduct
};
typedef NS_ENUM(NSInteger, cellRow) {
    kTitle = 0,
    kVendor,
    kContact,
    kContactPhone,
    kWarehouse,
    kTotal,
    kRemark,
};

@interface GXFNewProcessViewController ()<UITableViewDataSource,UITableViewDelegate,UITextFieldDelegate,GXFBottomViewDelegate>
{
    NSMutableArray *_selectRowArr;//记录当前选中的cell
}
@property (nonatomic, strong) UIScrollView *c_scrollView;
@property (nonatomic, strong) UITableView *c_tableView;
@property (nonatomic, strong) IBTSegmentContainer *c_segContainer;
@property (nonatomic, strong) IBTSegmentedControl *c_segmentControl;
@property (nonatomic, strong) GXFPopNewMaterialViewController *c_materialVC;
@property (nonatomic, strong) GXFButtonAndLineView *c_materialView;
@property (nonatomic, strong) GXFButtonAndLineView *c_productView;

@property (nonatomic, strong) NSArray *d_arrRightTableV;
@property (nonatomic, strong) NSArray *d_arrLeftTableV;
@property (nonatomic, strong) NSMutableArray *d_materialMuArr;
@property (nonatomic, strong) NSMutableArray *d_productMuArr;
@property (nonatomic, strong) GXFProcessBill *d_processBill;
@property (nonatomic, assign) BOOL d_isProduct;
@property (nonatomic, strong) NSArray *d_meteilHeaderArr;
@property (nonatomic, strong) NSArray *d_productHeaderArr;
//@property (nonatomic, strong) NSMutableArray *d_meteilArr;
//@property (nonatomic, strong) NSMutableArray *d_productArr;

@property (nonatomic, assign) NSInteger d_editOrDelete;


@property (nonatomic,assign)BOOL isHiddenEdit;
@property (nonatomic, copy) NSString *d_processUuid;
@property (nonatomic, assign) BOOL isProccessing;
@end

@implementation GXFNewProcessViewController

- (instancetype)initWithProcessUuid:(NSString *)processUuid {
    
    self = [super init];
    if (!self) {
        return nil;
    }
    self.d_processUuid = processUuid;
    self.isProccessing = YES;
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    self.title = @"添加加工单";
    [self http];
    [self initData];
    [self initSubViews];
    
    //原料明细
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(addNewMaterail:) name:KNOTIFICATION_saveMaterial object:nil];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(editMaterail:) name:KNOTIFICATION_editMaterial object:nil];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(deleteMaterail:) name:KNOTIFICATION_deleteMaterial object:nil];
    //货物明细
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(addNewProduct:) name:KNOTIFICATION_saveProduct object:nil];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(editProduct:) name:KNOTIFICATION_editProduct object:nil];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(deleteProduct:) name:KNOTIFICATION_deleteProduct object:nil];
}
- (void)http{
    if (!self.d_materialMuArr) {
        self.d_materialMuArr = [NSMutableArray array];
    }
    
    if (!self.d_productMuArr) {
        self.d_productMuArr = [NSMutableArray array];
    }

    __weak typeof(self)weakSelf = self;
    void (^success)(id) = ^(id data){
        [IBTLoadingView hideHUDWithText:nil];
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        [strongSelf fetchDataWithData:data];
    };
    void (^fail)(id) = ^(id data){
        [IBTLoadingView hideHUDWithText:nil];
        
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    [[ICRHTTPController sharedController] getResultWithProcessUuid:_d_processUuid success:success failure:fail];
}
- (void)fetchDataWithData: (id)data {
    if (data) {
        NSInteger success = [data[@"success"] integerValue];
        NSString *message = data[@"message"];
        if (success == 1) {
            NSDictionary *dict = (NSDictionary *)data[@"data"];
            self.d_processBill = [[GXFProcessBill alloc]initWithDict:dict];
            NSArray *arrMaterials = dict[@"materials"];
            if (arrMaterials.count > 0) {
                for (int i = 0; i < arrMaterials.count; i++) {
                    GXFProcessMaterial *material = [[GXFProcessMaterial alloc]initWithDict:arrMaterials[i]];
                    [self.d_materialMuArr addObject:material];
                }
            }
            
            NSArray *arrProducts = dict[@"products"];
            if (arrProducts.count > 0) {
                for (int i = 0; i < arrMaterials.count; i++) {
                    GXFProcessProduct *product = [[GXFProcessProduct alloc]initWithDict:arrProducts[i]];
                    [self.d_productMuArr addObject:product];
                }
            }
            
            
        }
        
    }
    [self.c_tableView reloadData];
}

//刷新数据
- (void)p_refreshData {
    NSIndexSet *indexSet = [[NSIndexSet alloc]initWithIndex:1];
    [self.c_tableView reloadSections:indexSet withRowAnimation:UITableViewRowAnimationAutomatic];
}

//原料明细
- (void)addNewMaterail: (NSNotification *)aNotification {
    GXFProcessMaterial *material = aNotification.object;
    if (_d_materialMuArr ) {
        [_d_materialMuArr addObject:material];
        [self p_refreshData];
    }
}
- (void)editMaterail: (NSNotification *)aNotification {
    GXFProcessMaterial *material = aNotification.object;
    if (_d_materialMuArr ) {
        [_d_materialMuArr replaceObjectAtIndex:_d_editOrDelete withObject:material];
        [self p_refreshData];
    }
}
- (void)deleteMaterail: (NSNotification *)aNotification {
    GXFProcessMaterial *material = aNotification.object;
    if (_d_materialMuArr) {
        [_d_materialMuArr removeObject:material];////待做：优化为刷新这一条
        [self p_refreshData];
    }
}
//产品明细
- (void)addNewProduct: (NSNotification *)aNotification {
    GXFProcessProduct *product = aNotification.object;
    if (_d_productMuArr) {
        [_d_productMuArr addObject:product];
        [self p_refreshData];
    }
}
- (void)editProduct: (NSNotification *)aNotification {
    GXFProcessProduct *product = aNotification.object;
    if (_d_productMuArr) {
        [_d_productMuArr replaceObjectAtIndex:_d_editOrDelete withObject:product];//待做：优化为刷新这一条
        [self p_refreshData];
    }
}
- (void)deleteProduct: (NSNotification *)aNotification {
    GXFProcessProduct *product = aNotification.object;
    if (_d_productMuArr) {
        [_d_productMuArr removeObject:product];////待做：优化为刷新这一条
        [self p_refreshData];
    }
}
- (void)viewWillAppear:(BOOL)animated {

}

- (void)initData {
    self.d_arrLeftTableV =@[@"标题：",@"供应商：",@"联系人：",@"联系电话：",@"加工工厂：",@"总费用：",@"备注："];
    self.d_arrRightTableV = @[@"请输入标题",@"选择供应商",@"请输入联系人姓名",@"请输入联系电话",@"选择加工工厂",@"",@"请输入备注"];
    self.d_meteilHeaderArr = @[@"原料",@"基础数量",@"入库时间"];
    self.d_productHeaderArr = @[@"原料",@"基础数量",@"出库时间"];
     _selectRowArr = [[NSMutableArray alloc]init];
    if (!_d_processBill) {
        self.d_processBill = [[GXFProcessBill alloc]init];
    }
    self.d_processBill = [[GXFProcessBill alloc]init];
    
    if (!self.d_materialMuArr) {
        self.d_materialMuArr = [NSMutableArray array];
    }
    
    if (!self.d_productMuArr) {
        self.d_productMuArr = [NSMutableArray array];
    }
    
}
- (void)initSubViews {
    self.view.backgroundColor = XXFBgColor;
    self.c_tableView = [[UITableView alloc]initWithFrame:CGRectMake(0, 0, self.view.width, self.view.height - BottomViewHeight - NavigationBarHeight) style:UITableViewStyleGrouped];
    self.c_tableView.dataSource = self;
    self.c_tableView.delegate = self;
    [self.view addSubview:_c_tableView];
    [_c_tableView reloadData];
    
    GXFBottomView *bottomV = [[GXFBottomView alloc]initWithFrame:CGRectMake(0, _c_tableView.bottom, self.view.width, BottomViewHeight) LeftBtnTitle:@"结束" rightBtnTitle:@"保存"];
    bottomV.delegate = self;
    [self.view addSubview:bottomV];

}

#pragma UITableViewDataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    
    if (section == 0) {
        return _d_arrLeftTableV.count;
    } else {
        if (_d_isProduct) {
            return 2 + _d_productMuArr.count;
        }
        return 2 + _d_materialMuArr.count;
    }
}
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 2;
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    if (indexPath.section == 1) {
        if (indexPath.row > 1) {
            if ([self isHaveIndexPath:indexPath]) {
                return 200;
            } else {
                return GXF_TABLEVIEW_NOMALCELL_HEIGHT;
            }
        } else {
            return GXF_TABLEVIEW_NOMALCELL_HEIGHT;
        }
    } else {
        return GXF_TABLEVIEW_NOMALCELL_HEIGHT;
    }
}
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section {
    if (section == 0) {
        return nil;
    } else {
        UIView * headV = [[UIView alloc]initWithFrame:CGRectMake(0, 0, self.view.width, 44)];
        headV.backgroundColor = [UIColor whiteColor];

        GXFButtonAndLineView *materialView = [[GXFButtonAndLineView alloc]initViewLineAndButtonWithFrame:CGRectMake(0, 0, self.view.width * 0.5, headV.height )  isSeleted:!_d_isProduct buttonTitle: @"原料明细" selectColor:GXF_GREEN_COLOR];        [materialView.f_btn addTarget:self action:@selector(selecNewMaterial) forControlEvents:UIControlEventTouchUpInside];
        self.c_materialView = materialView;
       GXFButtonAndLineView *productView = [[GXFButtonAndLineView alloc]initViewLineAndButtonWithFrame:CGRectMake(self.view.width * 0.5, 0, materialView.width, materialView.height)   isSeleted:_d_isProduct buttonTitle: @"成品明细" selectColor:GXF_GREEN_COLOR];
        [productView.f_btn addTarget:self action:@selector(selecNewMaterial) forControlEvents:UIControlEventTouchUpInside];
        self.c_productView= productView;

        [headV addSubview:_c_materialView];
        [headV addSubview:_c_productView];
        [headV addSubview:productView];
        return headV;

    }
        
}


- (UIView *)viewLineAndButtonWithFrame: (CGRect)frame
                             isSeleted: (BOOL)isSelected
                           buttonTitle: (NSString *)title
                           selectColor: (UIColor *)color
                               // target: (id)target
                                action:(SEL)action
                      forControlEvents:(UIControlEvents)controlEvents
{
    UIView *view = [[UIView alloc]initWithFrame:frame];

    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    btn.frame = CGRectMake(0, 0, view.width, view.height - 1);
    [btn setTitle:title forState:UIControlStateNormal];
    [btn addTarget:self action:action forControlEvents:controlEvents];
    
    CGSize labelSize = [btn.titleLabel.text sizeWithAttributes:@{NSFontAttributeName: btn.titleLabel.font}];
    UIView *line = [[UIView alloc]initWithFrame:CGRectMake((view.width - labelSize.width ) * 0.5, btn.bottom, labelSize.width, 1)];
    if (isSelected) {
        [btn setTitleColor:GXF_GREEN_COLOR forState:UIControlStateNormal];
         line.backgroundColor = GXF_GREEN_COLOR;
        
    } else {
        [btn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
        line.backgroundColor = [UIColor whiteColor];
    }

    [view addSubview:line];
    [view addSubview:btn];
    
    return view;
    
    
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section {
    if (section == 0) {
        return 0.1;
    } else {
        return 44;
    }
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    GXFTableViewCell *xfCell ;
    if (indexPath.section == 0) {
        if (indexPath.row == kTitle || indexPath.row == kContact ||
            indexPath.row == kContactPhone ||indexPath.row == kRemark) {
            xfCell = [tableView dequeueReusableCellWithIdentifier:noLblCell];
            if (!xfCell ) {
                xfCell = [[GXFTableViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:noLblCell textFieldPlaceholder:_d_arrRightTableV[indexPath.row] isEdit:YES];
            }
            if (_isProccessing) {
                switch (indexPath.row) {
                    case kTitle:
                        xfCell.f_textField.text =  _d_processBill.title;
                        break;
                    case kContact:
                        xfCell.f_textField.text =  _d_processBill.contact;
                        break;
                    case kContactPhone:
                        xfCell.f_textField.text =  _d_processBill.contactPhone;
                        break;
                    case kRemark:
                        xfCell.f_textField.text =  _d_processBill.remark;
                        break;
                    default:
                        break;
                }
            }
        } else if (indexPath.row == kVendor || indexPath.row ==kWarehouse ) {
            xfCell = [tableView dequeueReusableCellWithIdentifier:arrowCell];
                    if ( !xfCell) {
                                    xfCell = [[GXFTableViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:arrowCell textFieldPlaceholder:_d_arrRightTableV[indexPath.row] isEdit:NO];
                        //xfCell = [[GXFTableViewCell alloc]initWithStyle:UITableVie<#(NSString *)#>wCellStyleDefault reuseIdentifier:arrowCell];
                    }
            xfCell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
            if (_isProccessing) {
                switch (indexPath.row) {
                    case kVendor:
                        xfCell.f_textField.text =  _d_processBill.vendor_name;
                        break;
                    case kWarehouse:
                        xfCell.f_textField.text = [NSString stringWithFormat:@"%@[%@]",_d_processBill.warehouse_name,_d_processBill.warehouse_uuid];// _d_processBill.warehouse_name;
                        break;
                    default:
                        break;
                }
            }

        } else if (indexPath.row == kTotal ){
            xfCell = [tableView dequeueReusableCellWithIdentifier:lblCell];
            if (!xfCell ) {
                xfCell = [[GXFTableViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:lblCell textFieldPlaceholder:_d_arrRightTableV[indexPath.row] hasLable:YES backLableText:@"元"];
            }
            if (_isProccessing) {
                xfCell.f_textField.text = [NSString stringWithFormat:@"%@",_d_processBill.total];
            }
        } else {
            xfCell = [tableView dequeueReusableCellWithIdentifier:noLblCell];
            if (!xfCell ) {
                xfCell = [[GXFTableViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:noLblCell textFieldPlaceholder:_d_arrRightTableV[indexPath.row] isEdit:YES];
            }
        }

        if (xfCell.f_textField) {
            xfCell.f_textField.delegate = self;
        }
        xfCell.f_textField.tag = indexPath.row;
        xfCell.textLabel.text = _d_arrLeftTableV[indexPath.row];
        xfCell.textLabel.textColor = [UIColor blackColor];
        xfCell.selectionStyle = UITableViewCellAccessoryNone;
        return xfCell;
    } else {
        if (indexPath.row == 0) {
            xfCell = [tableView dequeueReusableCellWithIdentifier:addDetailCell];
            xfCell = [[GXFTableViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:addDetailCell];
            UIButton *addDetailedButton=[UIButton  buttonWithType: UIButtonTypeCustom];
            [addDetailedButton  setFrame:CGRectMake(xfCell.width * 0.5, 0, xfCell.width * 0.5, xfCell.height)];
            
            [addDetailedButton addTarget:self action:@selector(addNewInfoDetailed) forControlEvents:UIControlEventTouchUpInside];
            [addDetailedButton setTitleColor:HexColor(@"444444") forState:UIControlStateNormal];
            [xfCell.contentView addSubview:addDetailedButton];
            //if (!xfCell) {
            if (_d_isProduct) {
                [addDetailedButton setTitle:@"+ 点击添加商品明细" forState:UIControlStateNormal];
            } else {
                [addDetailedButton setTitle:@"+ 点击添加原料明细" forState:UIControlStateNormal];
            }
            
              //  }
            
            xfCell.selectionStyle = UITableViewCellAccessoryNone;
            return xfCell;
            } else if ( indexPath.row == 1){
                 xfCell = [tableView dequeueReusableCellWithIdentifier:addHeaderCell];
                if (!xfCell) {
                    NSArray *arr = [NSArray arrayWithArray: _d_isProduct ? _d_productHeaderArr :_d_meteilHeaderArr] ;
                    if (arr) {
                        xfCell = [[GXFTableViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:addHeaderCell contentArray:arr];
                    } else {
                        xfCell = [[GXFTableViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:addHeaderCell];
                    }
                    
   
                }
            
                xfCell.selectionStyle = UITableViewCellAccessoryNone;
                return xfCell;

            }else  {
                static NSString *cellIDProduct = @"ProductCell";
                static NSString *cellIDMaterial = @"materialCell";
                if(_d_isProduct){
                
                     //GXFProcessProductTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellIDProduct];
                    //if (cell == nil) {
                        
                            GXFProcessProduct *processP = (GXFProcessProduct *)_d_productMuArr[indexPath.row - 2];
                            GXFProcessProductTableViewCell *cell = [[GXFProcessProductTableViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellIDProduct processProduct:processP];
                        
//                    } else {
//                        while (cell.contentView.subviews.lastObject != nil) {
//                            [(UIView *)[cell.contentView.subviews lastObject] removeFromSuperview];
//                        }
//                    }
                    cell.selectionStyle = UITableViewCellSelectionStyleNone;
                    if (self.isHiddenEdit) {
                        cell.editBtn.hidden = YES;
                    }
                    if ([self isHaveIndexPath:indexPath]) {
                        cell.smallImageView.image = [UIImage imageNamed:@"arrowdown"];
                        CGRect Linefrmame = cell.lineLabel.frame;
                        Linefrmame.origin.y = 200-1;
                        cell.lineLabel.frame = Linefrmame;
                        CGRect showfrmame = cell.showView.frame;
                        showfrmame.size.height = 150;
                        cell.showView.frame = showfrmame;
                        cell.backgroundColor = XXFBgColor;
                    }else{
                        cell.smallImageView.image = [UIImage imageNamed:@"arrowright"];
                        CGRect Linefrmame = cell.lineLabel.frame;
                        Linefrmame.origin.y = GXF_TABLEVIEW_NOMALCELL_HEIGHT-1;
                        cell.lineLabel.frame = Linefrmame;
                        CGRect showfrmame = cell.showView.frame;
                        showfrmame.size.height = 0;
                        cell.showView.frame = showfrmame;
                        cell.backgroundColor = [UIColor whiteColor];
                    }
                    cell.editBtn.tag = indexPath.row;
                    [cell.editBtn addTarget:self action:@selector(editClick:) forControlEvents:UIControlEventTouchUpInside];
                    return cell;

                } else {
                   // GXFProcessMaterialTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellIDProduct];
                    //if (cell == nil) {
                        
                        GXFProcessMaterial *processM = (GXFProcessMaterial *)_d_materialMuArr[indexPath.row - 2];
                      GXFProcessMaterialTableViewCell * cell = [[ GXFProcessMaterialTableViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellIDMaterial processMaterial:processM];
                        
                   // }
                    cell.selectionStyle = UITableViewCellSelectionStyleNone;
                    if (self.isHiddenEdit) {
                        cell.editBtn.hidden = YES;
                    }
                    if ([self isHaveIndexPath:indexPath]) {
                        cell.smallImageView.image = [UIImage imageNamed:@"arrowdown"];
                        CGRect Linefrmame = cell.lineLabel.frame;
                        Linefrmame.origin.y = 200-1;
                        cell.lineLabel.frame = Linefrmame;
                        CGRect showfrmame = cell.showView.frame;
                        showfrmame.size.height = 150;
                        cell.showView.frame = showfrmame;
                        cell.backgroundColor = XXFBgColor;
                    }else{
                        cell.smallImageView.image = [UIImage imageNamed:@"arrowright"];
                        CGRect Linefrmame = cell.lineLabel.frame;
                        Linefrmame.origin.y = GXF_TABLEVIEW_NOMALCELL_HEIGHT-1;
                        cell.lineLabel.frame = Linefrmame;
                        CGRect showfrmame = cell.showView.frame;
                        showfrmame.size.height = 0;
                        cell.showView.frame = showfrmame;
                        cell.backgroundColor = [UIColor whiteColor];
                    }
                    cell.editBtn.tag = indexPath.row;
                    [cell.editBtn addTarget:self action:@selector(editClick:) forControlEvents:UIControlEventTouchUpInside];
                    return cell;

                
                
                }
                
            }
           
    }
}

#pragma UITableViewDelegate
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.section == 0) {
        GXFTableViewCell *xfCell = (GXFTableViewCell *)[_c_tableView cellForRowAtIndexPath:indexPath];
        switch (indexPath.row) {
            case kVendor:
            {
                GXFSearchVendorViewController *vc = [[GXFSearchVendorViewController alloc]initWithTitle:[IBTCommon localizableString:@"VendorTitle"]];
                vc.choseVendor = ^(NSArray *vendors){
                    if (vendors.count > 0) {
                        Vendor *vendor = vendors[0];
                        xfCell.f_textField.text = [NSString stringWithFormat:@"%@[%@]",vendor.name,vendor.code];
                        _d_processBill.vendor_uuid = vendor.uuid;
                        _d_processBill.vendor_code = vendor.code;
                        _d_processBill.vendor_name = vendor.name;
                    }
                };
                [self PushViewController:vc animated:YES];
            }
                break;
            case kWarehouse:
            {
                GXFSearchVendorViewController *vc = [[GXFSearchVendorViewController alloc]initWithTitle:[IBTCommon localizableString:@"WarehouseTitle"]];
                vc.choseVendor = ^(NSArray *vendors){
                    if (vendors.count > 0) {
                        Warehouse *warehouse = vendors[0];
                        xfCell.f_textField.text = [NSString stringWithFormat:@"%@[%@]",warehouse.name,warehouse.code];
                        _d_processBill.warehouse_uuid = warehouse.uuid;
                        _d_processBill.warehouse_code = warehouse.code;
                        _d_processBill.warehouse_name = warehouse.name;
                    }
                };
                [self PushViewController:vc animated:YES];
            }
                
                break;
                
            default:
                break;
        }

    } else {
    
    ProductBillCell *cell = (ProductBillCell *)[tableView cellForRowAtIndexPath:indexPath];
       // ProductCell *cell = (ProductCell *)[tableView cellForRowAtIndexPath:indexPath];
        CGRect Linefrmame = cell.lineLabel.frame;
        CGRect showfrmame = cell.showView.frame;
        if (Linefrmame.origin.y == GXF_TABLEVIEW_NOMALCELL_HEIGHT - 1) {
            cell.smallImageView.image = [UIImage imageNamed:@"arrowdown"];
            
            Linefrmame.origin.y = 200-1;
            showfrmame.size.height = 150;
            cell.backgroundColor = [UIColor whiteColor];
            [_selectRowArr addObject:indexPath];
        }else{
            cell.smallImageView.image = [UIImage imageNamed:@"arrowright"];
            Linefrmame.origin.y = GXF_TABLEVIEW_NOMALCELL_HEIGHT -1;
            showfrmame.size.height = 0;
            cell.backgroundColor = [UIColor whiteColor];
            [_selectRowArr removeObject:indexPath];
        }
        cell.lineLabel.frame = Linefrmame;
        cell.showView.frame = showfrmame;
        [self p_refreshData];
//        NSIndexSet *indexSet = [[NSIndexSet alloc]initWithIndex:1];
//        [self.c_tableView reloadSections:indexSet withRowAnimation:UITableViewRowAnimationAutomatic];

    
    }
}

- (BOOL)isHaveIndexPath:(NSIndexPath *)indexPath{
    for (NSIndexPath *path in _selectRowArr) {
        if (path.row == indexPath.row) {
            return YES;
        }
    }
    return NO;
}
#pragma buttonAction 
- (void)addNewInfoDetailed {

    if (_d_isProduct) {
        GXFPopNewProductViewController *productVC = [[GXFPopNewProductViewController alloc]init];
        [self PushViewController:productVC animated:NO];
    } else {
    GXFPopNewMaterialViewController *materialVC = [[GXFPopNewMaterialViewController alloc]init];
    [self PushViewController:materialVC animated:YES];
    }
  
}
- (void)editClick: (UIButton *)btn{
    if (_d_isProduct) {
        self.d_editOrDelete = btn.tag - 2;
        GXFProcessProduct *product = _d_productMuArr[btn.tag - 2];
        GXFPopNewProductViewController *productVC = [[GXFPopNewProductViewController alloc]initWithProcessProduct:product isEdit: YES];
        [self PushViewController:productVC animated:NO];
    } else {
        self.d_editOrDelete = btn.tag - 2;
        GXFProcessMaterial *material = _d_materialMuArr[btn.tag - 2];
        GXFPopNewMaterialViewController *materialVC = [[GXFPopNewMaterialViewController alloc]initWithProcessMaterial:material isEdit:YES];
        [self PushViewController:materialVC animated:NO];
    }
}
- (void)selecNewMaterial {
    self.d_isProduct = !_d_isProduct;
    if (!_d_isProduct) {
        [self.c_materialView.f_btn setTitleColor:GXF_GREEN_COLOR forState:UIControlStateNormal];
        self.c_materialView.f_line.backgroundColor = GXF_GREEN_COLOR;
        
        [self.c_productView.f_btn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
        self.c_productView.f_line.backgroundColor = [UIColor whiteColor];
        
    } else {
        [self.c_materialView.f_btn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
        self.c_materialView.f_line.backgroundColor = [UIColor whiteColor];
        
        [self.c_productView.f_btn setTitleColor:GXF_GREEN_COLOR forState:UIControlStateNormal];
        self.c_productView.f_line.backgroundColor = GXF_GREEN_COLOR;
    }

    [self p_refreshData];
//    NSIndexSet *indexSet = [[NSIndexSet alloc]initWithIndex:1];
//     [self.c_tableView reloadSections:indexSet withRowAnimation:UITableViewRowAnimationAutomatic];
}

#pragma GXFBottomViewDelegate
- (void)bottomViewleftButtonClicked:(UIButton *)leftBtn {
    [self p_processBillSaveOrFinishWithIsSave:NO];
//    void(^succ)(id) = ^(id data) {
//        [IBTLoadingView hideHUDWithText:nil];
//        CLog(@"%@",data[@"message"]);};
//    void(^fail)(id) = ^(id data) {
//        [IBTLoadingView hideHUDWithText:nil];
//        [IBTLoadingView showTips:data];
//    };
//    
//    NSDictionary *material = @{@"basePrice":@"222",@"baseQty":@"3434",@"instockDate":@"2015-09-08 10:24:23",@"place":@"测试",
//                               @"productCode":@"100101",@"productName":@"可比克薯片紫色",@"productUuid":@"5a7417014e29bb2c014e351643f70032",@"quality":@"123",
//                               @"remark":@"",@"total":@"4",@"uuid":[NSNull null]};
//    NSDictionary *product =  @{@"baseQty":@"2344",@"outstockDate":@"2015-09-08 10:24:42",@"productCode":@"农夫山泉",@"productName":@"dd",
//                                @"productUuid":@"402880e64e287fe2014e28895b8a0032",@"qpc":@"123",@"qpcStr":@"1 X123.0",@"quantity":@"234",
//                              @"remark":@"",@"unit":@"篮",@"uuid":[NSNull null]};
//    NSDictionary *para = @{//@"uuid":@"",
//                           @"contact":@"222",
//                           @"contactPhone":@"3434",
//                           @"materials":@[material],
//                           @"products":@[product],
//                           @"remark":@"100101",@"title":@"可色",@"total":@"32",@"vendor_code":@"0001",
//                           @"vendor_name":@"卖香蕉的",@"vendor_uuid":@"297e48a24f0e3750014f0e3850a60001",@"version":@"0",@"warehouse_code":@"4028e4284f6e3ce5014f6e41a01b0001",@"warehouse_name":@"123",@"warehouse_uuid":@"123"};
// [[ICRHTTPController sharedController] saveProcessWithAuthenticode:para success:succ failure:fail];
}
- (void)bottomViewRightButtonClicked:(UIButton *)rightBtn {
    [self p_processBillSaveOrFinishWithIsSave:YES];
}

- (void)p_processBillSaveOrFinishWithIsSave: (BOOL)isSave {
    CLog(@"ffff");
    //[IBTCommon checkString:_d_processBill.title]
    //    if ([IBTCommon checkStringIsNilOrSpance:_d_processBill.title]) {
    //        UIAlertView *alert = [[UIAlertView alloc]initWithTitle:@"提示信息" message:@"标题不能为空" delegate:nil cancelButtonTitle:@"确定" otherButtonTitles:nil, nil];
    //        [alert show];
    //        return;
    //    }
    //    if ([IBTCommon checkStringIsNilOrSpance:_d_processBill.vendor_name]) {
    //        UIAlertView *alert = [[UIAlertView alloc]initWithTitle:@"提示信息" message:@"请选择供应商" delegate:nil cancelButtonTitle:@"确定" otherButtonTitles:nil, nil];
    //        [alert show];
    //        return;
    //    }
    
    if ([IBTCommon checkStringIsNilOrSpance:_d_processBill.warehouse_name]) {
        UIAlertView *alert = [[UIAlertView alloc]initWithTitle:@"提示信息" message:@"请选择加工工厂" delegate:nil cancelButtonTitle:@"确定" otherButtonTitles:nil, nil];
        [alert show];
        return;
    }
    
    
    
    
    //保存
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        CLog(@"%@",data[@"message"]);
        //        if (data) {
        //            NSInteger success = [data[@"success"] integerValue];
        //            NSString *message = data[@"message"];
        //            if (success == 1) {
        //                //成功
        //                if ([state isEqualToString:@"initial"]) {//保存成功
        //                    [IBTLoadingView showTips:@"操作成功"];
        //                }else{//提交成功
        //                    SurveyViewController *svc = [SurveyViewController new];
        //                    [self PushViewController:svc animated:YES];
        //                }
        //            }else{
        //                [IBTLoadingView showTips:message];
        //            }
        //        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    
    //    if(self.survey.uuid.length > 0 && uuidObject == [NSNull null]){
    //        uuidObject = self.survey.uuid;
    //    }
    //    if (self.survey.billNumber > 0 && billNumberObject == [NSNull null]) {
    //        billNumberObject = self.survey.billNumber;
    //    }
    //    if (self.survey && [version integerValue] == 0) {
    //        version = self.survey.version;
    //    }
    
    NSMutableArray *productMuArr = [NSMutableArray array];
    for (int count = 0; count < _d_productMuArr.count; count ++) {
        GXFProcessProduct *product = (GXFProcessProduct *)_d_productMuArr[count];
        NSMutableDictionary *dic = [product mutableDictDateToStringForCommit];
        
        //       NSDictionary *materialdict = @{@"uuid":@"11",@"productUuid":@"402880e64e287fe2014e28895b8a0032",@"productCode":@"农夫山泉",@"productName":@"dd",@"outstockDate":@"2015-09-05 13:36:16 +0000",@"unit":@"",@"qpc":@"kk",@"qpcStr":@"ll",@"quality":@"9",@"baseQty":@"8",@"remark":@""};
        [productMuArr addObject:dic];//productdict];
    }
    
    NSMutableArray *materialMuArr = [NSMutableArray array];
    for (int count = 0; count < _d_materialMuArr.count; count ++) {
        GXFProcessMaterial *material = (GXFProcessMaterial *)_d_materialMuArr[count];
        NSMutableDictionary *dic = [material mutableDictDateToStringForCommit];
        
        //        NSDictionary *productdict = @{@"uuid":@"",@"productUuid":@"402880e64e287fe2014e28895b8a0032",@"productCode":@"农夫山泉",@"productName":@"dd",@"outstockDate":@"2015-09-05 13:36:16 +0000",@"place":@"",@"quality":@"",@"baseQty":@"1",@"basePrice":@"2",@"total":@"2",@"remark":@""};
        [materialMuArr addObject:dic];//materialdict];
    }
    
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    NSDictionary *dict = @{
                           @"uuid":_isProccessing?[IBTCommon checkString:_d_processBill.uuid]:[NSNull null],
                           @"version":_isProccessing?_d_processBill.version:@(0),
                           @"billNumber":_isProccessing?[IBTCommon checkString:_d_processBill.billNumber]:[NSNull null],
                           @"title":[IBTCommon checkString:_d_processBill.title],
                           @"vendor_uuid": _d_processBill.vendor_uuid,
                           @"vendor_code": _d_processBill.vendor_code,
                           @"vendor_name": _d_processBill.vendor_name,
                           @"warehouse_uuid":_d_processBill.warehouse_uuid,
                           @"warehouse_code":_d_processBill.warehouse_code,
                           @"warehouse_name":_d_processBill.warehouse_name,
                           @"contact":[IBTCommon checkString: _d_processBill.contact],
                           @"contactPhone":[IBTCommon checkString:_d_processBill.contactPhone],
                           @"total":_d_processBill.total,
                           @"remark":[IBTCommon checkString:_d_processBill.remark],
                           @"materials":materialMuArr,
                           @"products":productMuArr};
    //[IBTLoadingView showProgressLabel:msg];
    if (isSave) {
         [[ICRHTTPController sharedController] saveProcessWithAuthenticode:dict success:succ failure:fail];
    } else {
        [[ICRHTTPController sharedController] finishProcessWithAuthenticode:dict success:succ failure:fail];
    }
   
 
}
/*
 kTitle = 0, 不为空
 kVendor, 不为空
 kContact,
 kContactPhone,
 kWarehouse, 不为空
 kTotal,
 kRemark,
 */

- (BOOL)textFieldShouldReturn:(UITextField *)textField {
    switch (textField.tag) {
        case kTitle:
            self.d_processBill.title = textField.text;
            break;
        case kVendor:
           // self.d_processBill.title = textField.text;
            break;
        case kContact:
            self.d_processBill.contact = textField.text;
            break;
        case kContactPhone:
            self.d_processBill.contactPhone = textField.text;
            break;
        case kTotal:
            self.d_processBill.total = @([textField.text floatValue]);
            break;
        case kRemark:
            self.d_processBill.remark = textField.text;
            break;
        default:
            break;
    }
    [textField resignFirstResponder];
    
    return YES;
}
- (void)textFieldDidEndEditing:(UITextField *)textField {
    [self textFieldShouldReturn:textField];
    
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}



@end
