//
//  HGPhWViewController.m
//  Cruiser
//  图片预览
//  Created by freecui on 15/7/24.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "HGPhWViewController.h"
#import "HGPhotoWall.h"
#import "HGPhoto.h"
#import "ZYQAssetPickerController.h"
#import "XFDB.h"
#import "XFPhoto.h"

@interface HGPhWViewController ()<HGPhotoWallDelegate,UIActionSheetDelegate,ZYQAssetPickerControllerDelegate,UINavigationControllerDelegate,UIScrollViewDelegate,UIImagePickerControllerDelegate>

@property (strong, nonatomic) UIView *coverV;
@property (strong, nonatomic) NSMutableArray *imgesMuArr;//每次从相册中选择的照片
//@property (strong, nonatomic) NSMutableArray *allImgsMuArr;
@property (strong, nonatomic) IBTUIButton *sureBtn;
@property (strong, nonatomic) UIScrollView *scrollV;

#define kImagCount 3
#define kPadding (20.0 / 320.0 * self.view.width)/(kImagCount + 1)
#define kImagWH ((self.view.width - (kImagCount + 1.0) * kPadding) / kImagCount)

#define KpaddingPhonto  kPadding + kImagWH
@end

@implementation HGPhWViewController
static HGPhWViewController *_instance = nil;

+ (instancetype) shareInstance {
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        _instance = [[self alloc]init];
    });
    
    return _instance;
}

//// 重写init方法
//- (id)init {
//    self = [super init];
//    if (!self) {
//        return nil;
//    }
//     //self.photoWall = [[HGPhotoWall alloc]init];
//   // [self initHGPhW];
//    return self;
//}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.title = @"图片预览";
    //[self initHGPhW];
    [self initData];
    self.imgesMuArr = [NSMutableArray array];
}
- (void)viewDidDisappear:(BOOL)animated {
    [[NSNotificationCenter defaultCenter] postNotificationName:kimgsFiles object:self];
}
- (void)initData {
//    self.imgesMuArr = [NSMutableArray array];
////    self.allImgsMuArr = [NSMutableArray array];
////    self.allImgAssets = [NSMutableArray array];
//    NSArray *arrData = [[XFDB sharedInstance]fetchAllPhotosFromLocal];
//    for (int count = 0; count < arrData.count; count ++) {
//        XFPhoto *xfphoto = arrData[count];
//        [self addOnePhoto:[UIImage imageWithData:xfphoto.photoData]];
//    }
}
- (void)initHGPhW {
    self.edgesForExtendedLayout = NO;
//    self.sureBtn = [IBTUIButton RoundCornerBtnWithTitle:@"确定上传图片" bgColor:nil];
//    _sureBtn.frame = CGRectMake(10, self.view.height - 50 - 64, self.view.width - 20, 40);
//    [_sureBtn addTarget:self action:@selector(surePhoto) forControlEvents:UIControlEventTouchUpInside];
//    [_sureBtn setBackgroundColor:[UIColor redColor]];
//    [self.view addSubview:_sureBtn];
    
    self.scrollV = [[UIScrollView alloc]initWithFrame:CGRectMake(0, 0, self.view.width, self.view.height)];
    [self.view addSubview:_scrollV];
    
    self.photoWall = [[HGPhotoWall alloc]init];
    _photoWall.backgroundColor = [UIColor colorWithWhite:1.000 alpha:0.000];
    _photoWall.frame = (CGRect) {
        .origin.x = 0,
        .origin.y = 0,
        .size.width = self.view.width,
        .size.height = self.scrollV.height
    };//self.view.bounds;

    _photoWall.delegate = self;
    
#pragma 初始化原来的图片数据  从数据库中读出
    [_photoWall setPhotos:[JavenImages shareInstance].imageArr];//
                     //  @"http://www.weiphone.com/images_v3/logo.png",nil]];

    [_photoWall setEditModel:YES];
    //[self.view addSubview:_photoWall];
    _scrollV.contentSize = _photoWall.size;
    [_scrollV addSubview:_photoWall];
    [self scrollViewContentHeight];
    
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark -
#pragma mark 点击图片并放大
//- (void)photoWallPhotoTaped:(NSUInteger)index
//{
- (void)photoWallPhotoTaped:(HGPhoto*)hgPhoto {
    [hgPhoto showImage];
//    UIImageView *imgV = [[UIImageView alloc]init];
//    imgV.frame =   _coverV.bounds;
//    [imgV setImageWithURL:self.photoWall]
//    UIActionSheet *actionSheetTemp = [[UIActionSheet alloc] initWithTitle:nil
//                                                                 delegate:self
//                                                        cancelButtonTitle:@"取消"
//                                                   destructiveButtonTitle:@"删除图片"
//                                                        otherButtonTitles:nil, nil];
//    [actionSheetTemp showInView:self.view];
  
    
}
- (void)photoWallPhotoDel:(NSUInteger)index {
    [_photoWall deletePhotoByIndex:index];
    [[JavenImages shareInstance].imageArr removeObjectAtIndex:index];
}

- (void)delCoverV {
    if (_coverV) {
        [_coverV removeFromSuperview];
    }

}
- (void)photoWallMovePhotoFromIndex:(NSInteger)index toIndex:(NSInteger)newIndex
{
    
}

- (void)photoWallAddAction
{
//    [self.photoWall addPhoto:_url];
   // [self.photoWall addPhoto:@"http://cc.cocimg.com/bbs/attachment/upload/92/1226921340986127.jpg"];
    [self.photoWall addPhotoImg:_img];
}

- (void)photoWallAddFinish
{
    
}

- (void)photoWallDeleteFinish
{
    
}



#pragma 增加一张照片
- (void)addOnePhoto: (UIImage *)img {
  // [self.photoWall addPhoto:@"http://cc.cocimg.com/bbs/attachment/upload/92/1226921340986127.jpg"];
    self.img = img;
    [self.photoWall addPhotoImg:img];
    NSLog(@"%@",NSStringFromCGRect(_photoWall.frame));
    
}
#pragma 增加多张照片
- (void)addPhotosWithArrayImgs:(NSArray *)arr {
    for(UIImage *img in arr){
        [self addOnePhoto:img];
    }

}

#pragma 照片选择
- (void)photowallChoosePhontoes {
   UIActionSheet *actionSheet =  [[UIActionSheet alloc]initWithTitle:nil delegate:self cancelButtonTitle:@"取消" destructiveButtonTitle:nil otherButtonTitles:@"打开照相机", @"从手机相册获取", nil];
    [actionSheet showInView:self.view];

}
- (void)actionSheet:(UIActionSheet *)actionSheet clickedButtonAtIndex:(NSInteger)buttonIndex
{
    switch (buttonIndex) {
        case 0:
            [self openCamera];
            break;
        case 1:
            [self libraryPhoto];
            break;
        default:
            break;
    }

}
- (void)openCamera {
    UIImagePickerControllerSourceType sourceType = UIImagePickerControllerSourceTypeCamera;
    UIImagePickerController *picker = [[UIImagePickerController alloc]init];
    picker.delegate = self;
    picker.allowsEditing = NO;
    picker.sourceType = sourceType;
    [self PresentModalViewController:picker animated:YES];
    
}
- (void)libraryPhoto {

    ZYQAssetPickerController *assetPicker = [[ZYQAssetPickerController alloc]init];
    assetPicker.maximumNumberOfSelection = 10;
    assetPicker.assetsFilter = [ALAssetsFilter allPhotos];
    assetPicker.showEmptyGroups = NO;
    assetPicker.delegate = self;
   // assetPicker.indexPathsForSelectedItems = _allImgAssets;
    assetPicker.selectionFilter = [NSPredicate predicateWithBlock:^BOOL(id evaluatedObject, NSDictionary *bindings) {
        if ([[(ALAsset *)evaluatedObject valueForProperty:ALAssetPropertyType] isEqual:ALAssetTypeVideo]) {
            NSTimeInterval duration = [[(ALAsset *)evaluatedObject valueForProperty:ALAssetPropertyDuration] doubleValue];
            return duration >= 5;
        } else {
            return YES;
        }
    }];
    
    [self PresentModalViewController:assetPicker animated:YES];
    
}

#pragma UIImagePickerControllerDelegate
- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary *)info {

    UIImage *img = [info objectForKey:UIImagePickerControllerOriginalImage];
    [self addOnePhoto:img];
//    NSData *imgData = UIImagePNGRepresentation(img);
//    [self savePhotoToDB:imgData];
    
    
 //   [self.allImgsMuArr addObject:imgData];
    [[JavenImages shareInstance] insertAImage:img];
    [self scrollViewContentHeight];
    [picker DismissModalViewControllerAnimated:YES];
}

#pragma 把选择的图片放入到本地数据库中
- (void)savePhotoToDB: (NSData *)imgData {
//    XFPhoto *xfphoto = [[XFPhoto alloc]initWithPhotoData:imgData];
//    BOOL isSave = [[setImage sharedInstance]savePhoto:xfphoto];
//    if (isSave) {
//        NSLog(@"保存成功");
//    } else {
//        NSLog(@"保存失败");
//    }
}
#pragma mark - ZYQAssetPickerController Delegate
-(void)assetPickerController:(ZYQAssetPickerController *)picker didFinishPickingAssets:(NSArray *)assets{

    
    if (_imgesMuArr.count > 0) {
        [_imgesMuArr removeAllObjects];
    }
    
    
    for (int i=0; i<assets.count; i++) {
        ALAsset *asset = assets[i];
        CGImageRef ref = [[asset  defaultRepresentation]fullResolutionImage];
        UIImage *img = [[UIImage alloc]initWithCGImage:ref];
        
        [self.imgesMuArr addObject: img];//[UIImage imageNamed:@"AttachCamera"]
        
    }
    [[JavenImages shareInstance] insertImages:_imgesMuArr];
    [self addPhotosWithArrayImgs:_imgesMuArr];
    
    [self scrollViewContentHeight];
    [picker popoverPresentationController];

}

#pragma 调整scrollView内容视图内容高度
- (void)scrollViewContentHeight {
    NSArray *arr = [JavenImages shareInstance].imageArr;
    NSInteger count = 1;
    if ((arr.count + 1) % kImagCount) {
        count += (arr.count + 1) / kImagCount + 1;
    } else {
        count  += (arr.count + 1) / kImagCount ;
    }
    self.photoWall.height = 15.0 / 568 * self.view.height + KpaddingPhonto * count;
    self.scrollV.contentSize = _photoWall.size;

}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.view removeAllSubViews];
    [self initHGPhW];
}
#pragma 确定选择的照片
- (void)surePhoto {
   
}
@end
