//
//  JTImagePreviewer.m
//  JobTalk
//
//  Created by Xummer on 14-7-1.
//  Copyright (c) 2014年 BST. All rights reserved.
//

#define PRE_IMAGE_SVAE_BTN_WIDTH    (44)

#import "JTImagePreviewer.h"
#import "UIImageView+WebCache.h"
#import "IBTLoadingView.h"

@interface JTImagePreviewer ()
<
    UIScrollViewDelegate
>
{
    NSURL *_url;
	CGRect _startRect;
    UITapGestureRecognizer *_tapGestureRecognizer;
}

@property (strong, nonatomic) IBTUIView *bgView;
@property (strong, nonatomic) UIScrollView *scrollView;
@property (strong, nonatomic) UIImageView *imageView;
@property (strong, nonatomic) IBTUIView *toolBarContainer;
@property (strong, nonatomic) UIButton *saveButton;

@property (weak, nonatomic) UIImage *tempImage;

@property (weak, nonatomic) UIViewController *viewController;

@end

@implementation JTImagePreviewer

#pragma mark - Life Cycle
- (id)initWithViewController:(UIViewController *)viewController
                   tempImage:(UIImage *)image
                         url:(NSURL *)url
                   startRect:(CGRect)rect
{
    
    CGRect frame = CGRectZero;
    
    UIViewController *vCtrl = viewController;
    
    while (vCtrl.navigationController) {
        vCtrl = vCtrl.navigationController;
    }
    
    if (vCtrl.tabBarController) {
        vCtrl = vCtrl.tabBarController;
    }
    
    frame = vCtrl.view.bounds;
    
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    _url = url;
    _startRect = rect;
    self.viewController = viewController;
    self.tempImage = image;
    
    [self _init];
    
    return self;
}

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self _init];
    }
    return self;
}

- (void)layoutSubviews {
    [super layoutSubviews];
    
    _scrollView.frame = _bgView.bounds;
    
    _scrollView.contentSize = _bgView.bounds.size;
    
    _imageView.frame = _bgView.bounds;
    
    _toolBarContainer.frame = (CGRect){
        .origin.x = 0,
        .origin.y = CGRectGetMaxY(_scrollView.frame) - PRE_IMAGE_SVAE_BTN_WIDTH,
        .size.width = CGRectGetWidth(_bgView.bounds),
        .size.height = PRE_IMAGE_SVAE_BTN_WIDTH
    };
    
    _saveButton.frame = (CGRect){
        .origin.x = (CGRectGetWidth(_toolBarContainer.bounds) - PRE_IMAGE_SVAE_BTN_WIDTH) * .5f,
        .origin.y = 0,
        .size.width = PRE_IMAGE_SVAE_BTN_WIDTH,
        .size.height = PRE_IMAGE_SVAE_BTN_WIDTH
    };
}

#pragma mark - Private Method
- (void)_init {
    self.bgView = [[IBTUIView alloc] init];
    _bgView.frame = self.bounds;
    _bgView.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
    _bgView.backgroundColor = [UIColor colorWithW:0 a:1];
    _tapGestureRecognizer = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(hide)];
    [_bgView addGestureRecognizer:_tapGestureRecognizer];
    
    self.scrollView = [[UIScrollView alloc] init];
    _scrollView.backgroundColor = [UIColor clearColor];
    _scrollView.delegate = self;
    _scrollView.maximumZoomScale = 2.6;
    _scrollView.minimumZoomScale = 1;
    _scrollView.zoomScale = 1;
    _scrollView.showsHorizontalScrollIndicator = NO;
    _scrollView.showsVerticalScrollIndicator = NO;
    
    self.imageView = [[UIImageView alloc] init];
    _imageView.backgroundColor = [UIColor clearColor];
    _imageView.contentMode = UIViewContentModeScaleAspectFit;
    
    @autoreleasepool {
        [_imageView sd_setImageWithURL:_url placeholderImage:_tempImage];
    }
    
    self.toolBarContainer = [[IBTUIView alloc] init];
    _toolBarContainer.backgroundColor = [UIColor colorWithW:0 a:.5f];
    
    self.saveButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [_saveButton setImage:[UIImage imageNamed:@"save_to_album"]
                 forState:UIControlStateNormal];
    _saveButton.showsTouchWhenHighlighted = YES;
    [_saveButton addTarget:self
                    action:@selector(save)
          forControlEvents:UIControlEventTouchUpInside];
    
    
    [_scrollView addSubview:_imageView];
    [_bgView addSubview:_scrollView];
    [_toolBarContainer addSubview:_saveButton];
    [_bgView addSubview:_toolBarContainer];
    
    [self addSubview:_bgView];
    
}

- (void)dealloc {
    [self cleanup];
}

#pragma mark - Action
- (void)cleanup {
    _url = nil;
    _tapGestureRecognizer = nil;
}

- (void)save {
    if (_imageView.image) {
        [IBTLoadingView showProgressLabel:@"保存中..."];
        UIImageWriteToSavedPhotosAlbum(_imageView.image, self, @selector(image:didFinishSavingWithError:contextInfo:), nil);
    }
}

- (void)hide {
    self.userInteractionEnabled = NO;
    [UIView animateWithDuration:.2f
                     animations:^{
                         _imageView.frame = _startRect;
                         self.alpha = 0;
                     }
                     completion:^(BOOL finished) {
                         [self removeFromSuperview];
                     }];

}

- (void)show {
    self.userInteractionEnabled = NO;
    self.alpha = 0;
    
    if (self.viewController.navigationController) {
        [self.viewController.navigationController.view.window addSubview:self];
    }
    else {
        [self.viewController.view.window addSubview:self];
    }
    
    
    _imageView.frame = _startRect;
    
    [UIView animateWithDuration:.2f
                     animations:^{
                         self.alpha = 1;
                         _imageView.frame = _bgView.bounds;
                     }
                     completion:^(BOOL finished) {
                         self.userInteractionEnabled = YES;
                     }];
}

#pragma mark - Save Call Back
- (void)image:(UIImage *)image
didFinishSavingWithError:(NSError *)error
  contextInfo:(void *)contextInfo
{
    [IBTLoadingView hideHUDWithText:@"已保存"];
}

#pragma mark - UIScrollViewDelegate
- (void)scrollViewDidZoom:(UIScrollView *)scrollView {
//    _imageView.center = (CGPoint){
//        .x = CGRectGetWidth(_scrollView.bounds) * .5f ,
//        .y = CGRectGetHeight(_scrollView.bounds) * .5f,
//    };
}

- (UIView *)viewForZoomingInScrollView:(UIScrollView *)scrollView {
    return _imageView;
}

@end
