//
//  JTOptionsViewController.m
//  JobTalk
//
//  Created by Xummer on 14-5-22.
//  Copyright (c) 2014年 BST. All rights reserved.
//

static NSString *optinsCellIdentifier = @"JTOptionsCell";

#import "JTOptionsViewController.h"
#import "IBTTableView.h"
#import "IBTTableViewCell.h"
#import "JTOptionCell.h"

@interface JTOptionsViewController ()
<
    UITableViewDataSource,
    UITableViewDelegate
>

@property (strong, nonatomic) IBTTableView *tableView;
@property (strong, nonatomic) JTOptionsEntity *optionsData;

@end

@implementation JTOptionsViewController

#pragma mark - Life Cycle
- (id)initWithOptions:(JTOptionsEntity *)options {
    self = [super init];
    if (!self) {
        return nil;
    }
    
    self.optionsData = options;
    
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self setupSubviews];
}

- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
    
//    [_tableView selectRowAtIndexPath:[NSIndexPath indexPathForRow:_optionsData.selectedIndex inSection:0]
//                            animated:YES
//                      scrollPosition:UITableViewScrollPositionMiddle];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


#pragma mark - Private Method
- (void)setupSubviews {
    // setup tableview
    
    CGRect frame = self.view.bounds;
    self.tableView =
    [[IBTTableView alloc] initWithFrame:frame style:UITableViewStyleGrouped];
    _tableView.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
    [_tableView registerClass:[JTOptionCell class]
       forCellReuseIdentifier:optinsCellIdentifier];
    _tableView.dataSource = self;
    _tableView.delegate = self;
    
    [self.view addSubview:_tableView];
    
}

- (id)optionsDataAtIndexPath:(NSIndexPath *)indexPath {
    return _optionsData.optionsArray[ indexPath.row ];
}

- (NSString *)optionDisplayDataAtIndexPath:(NSIndexPath *)indexPath {
    return _optionsData.m_arrDisplayStr[ indexPath.row ];
}

#pragma mark - UITableViewDataSource

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView
 numberOfRowsInSection:(NSInteger)section
{
    return [_optionsData.optionsArray count];
}

- (UITableViewCell *)tableView:(UITableView *)tableView
         cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:optinsCellIdentifier forIndexPath:indexPath];
    
    [self configureCell:cell forRowAtIndexPath:indexPath];
    
    return cell;
}

- (void)configureCell:(UITableViewCell *)cell
    forRowAtIndexPath:(NSIndexPath *)indexPath
{
//    cell.selected = (indexPath.row == _optionsData.selectedIndex);
    cell.textLabel.text = [IBTCommon localizableString:[self optionDisplayDataAtIndexPath:indexPath]];
}

#pragma mark - UITableViewDelegate

- (void)tableView:(UITableView *)tableView
didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    self.optionsData.selectedIndex = indexPath.row;
    
    if (_baseCellIndexPath) {
        if ([_optionsDelegate respondsToSelector:@selector(optionsViewController:didChangedSelectedOptions:atBaseIndexPath:)]) {
            [_optionsDelegate optionsViewController:self didChangedSelectedOptions:_optionsData atBaseIndexPath:_baseCellIndexPath];
        }
    }
    else {
        if ([_optionsDelegate respondsToSelector:@selector(optionsViewController:didChangedSelectedOptions:)]) {
            [_optionsDelegate optionsViewController:self didChangedSelectedOptions:_optionsData];
        }
    }
    
    self.tableView.userInteractionEnabled = NO;
    
    if ((![self isPushedIn]) && [self isPresentedIn]) {
        double delayInSeconds = .2f;
        dispatch_time_t popTime = dispatch_time(DISPATCH_TIME_NOW, delayInSeconds * NSEC_PER_SEC);
        dispatch_after(popTime, dispatch_get_main_queue(), ^(void){
            [self dismissViewControllerAnimated:YES completion:NULL];
        });
    }
    else {
        [self performSelector:@selector(PopViewControllerAnimated:)
                   withObject:@( YES )
                   afterDelay:.2f];
    }
}

@end
