//
//  ICRAnnouncementDetailContentView.m
//  XFFruit
//
//  Created by Lili Wang on 15/4/16.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#define LABEL_LEFT_PANDING       (20)
#define LABEL_TOP_PANDING        (25)
#define LABEL_HEIGHT             (13)
#define LABEL_WIDTH              (35)
#define TABLEVIEW_CELL_HEIGHT    (35)

#import "ICRAnnouncementDetailContentView.h"
#import "ICRAnnouncementDetailHeadView.h"
#import "IBTTableView.h"
#import "LBorderView.h"
#import "IBTTableViewCell.h"
#import "ICRAttachment.h"
#import "ICRAttachmentCellContentView.h"
#import "ICRAnnouncement.h"

static NSString *TableViewCell = @"IBTTableViewCell";

@interface ICRAnnouncementDetailContentView ()
<
UITableViewDataSource,
UITableViewDelegate
>

@property (strong, nonatomic) LBorderView *m_AttachmentView;
@property (strong, nonatomic) UILabel *m_attachemntLabel;
@property (strong, nonatomic) IBTTableView *m_tableView;
@property (strong, nonatomic) NSArray *m_arrData;

@end

@implementation ICRAnnouncementDetailContentView

- (id)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self _init];
    }
    return self;
}

- (void)layoutSubviews {
    
    _m_attachemntLabel.frame = (CGRect){
        .origin.x = LABEL_LEFT_PANDING,
        .origin.y = LABEL_TOP_PANDING + _m_headView.bottom,
        .size.width = LABEL_WIDTH,
        .size.height = LABEL_HEIGHT
    };
    
    _m_AttachmentView.frame = (CGRect){
        .origin.x = _m_attachemntLabel.left,
        .origin.y = _m_attachemntLabel.bottom + 6,
        .size.width = self.width - LABEL_LEFT_PANDING * 2,
        .size.height = _m_arrData.count * TABLEVIEW_CELL_HEIGHT
    };
    
    self.height = _m_AttachmentView.bottom + LABEL_TOP_PANDING;
}

#pragma mark - Private Method
- (void)_init {
    CGRect frame = self.frame;
    self.m_headView = [[ICRAnnouncementDetailHeadView alloc] initWithFrame:frame];
    [self addSubview:_m_headView];

    self.m_arrData = [NSArray array];
    
    self.m_attachemntLabel = [[UILabel alloc] init];
    _m_attachemntLabel.textColor = [UIColor colorWithRed:0.000f green:0.463f blue:0.925f alpha:1.00f];
    _m_attachemntLabel.font = [UIFont systemFontOfSize:12];
    _m_attachemntLabel.text = [IBTCommon localizableString:@"Attachment:"];
    [self addSubview:_m_attachemntLabel];
    
    // Bottom Refference View
    self.m_AttachmentView = [[LBorderView alloc] init];
    _m_AttachmentView.cornerRadius = IBT_DEFAULT_CORNER_RADIUS;
    _m_AttachmentView.borderType = BorderTypeDashed;
    _m_AttachmentView.borderWidth = .5f;
    _m_AttachmentView.borderColor = [UIColor lightGrayColor];
    _m_AttachmentView.dashPattern = 4;
    _m_AttachmentView.spacePattern = 2;
    
    [self addSubview:_m_AttachmentView];
    
    UIView *view = [[UIView alloc] initWithFrame:CGRectZero];
    
    self.m_tableView = [[IBTTableView alloc]
                       initWithFrame:_m_AttachmentView.bounds style:UITableViewStylePlain];
    _m_tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    [_m_tableView registerClass:[IBTTableViewCell class]
        forCellReuseIdentifier:TableViewCell];
    _m_tableView.scrollEnabled = NO;
    _m_tableView.rowHeight = TABLEVIEW_CELL_HEIGHT;
    _m_tableView.dataSource = self;
    _m_tableView.delegate = self;
    _m_tableView.tableFooterView = view;
    [_m_tableView autoresizingWithStrechFullSize];
    [_m_AttachmentView addSubview:_m_tableView];
    
}

#pragma mark - UITableViewDatasource -
- (NSInteger) tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _m_arrData.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:TableViewCell];
    
    [self configureCell:cell forRowAtIndexPath:indexPath];
    
    return cell;
}

- (void)configureCell:(UITableViewCell *)cell
    forRowAtIndexPath:(NSIndexPath *)indexPath {
    
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    
    id obj = [_m_arrData objectAtIndex:indexPath.row];
    
    UIView *contentView = cell.contentView;
    
    ICRAttachmentCellContentView *aContentView = [contentView viewWithClass:
                                                  [ICRAttachmentCellContentView class]];
    
    if (!aContentView) {
        aContentView = [[ICRAttachmentCellContentView alloc] initWithFrame:contentView.frame];
        [aContentView autoresizingWithStrechFullSize];
        [contentView addSubview:aContentView];
        
        aContentView.m_downloadBtn.tag = indexPath.row;
        [aContentView.m_downloadBtn addTarget:self action:@selector(downloadButtonAction:) forControlEvents:UIControlEventTouchUpInside];
    }
    
    [aContentView updateContentWithData:obj];
}

#pragma mark - UITableViewDelegate

//- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
//    return 35;
//}

#pragma mark - UIButton Actions

- (void)downloadButtonAction:(id)sender {
    UIButton *button = (UIButton *)sender;
//    button.backgroundColor = [UIColor colorWithRed:0.157f green:0.843f blue:0.463f alpha:1.00f];
//    button.userInteractionEnabled = NO;
    
    if ([self.m_delegate respondsToSelector:@selector(AttachmentDetail:downloadBtn:)]) {
        [self.m_delegate AttachmentDetail:_m_arrData[ button.tag ] downloadBtn:button];
    }
}

#pragma mark - Public Method
- (void)updateWithAnnouncement:(ICRAnnouncement *)announcement {
    
    [self.m_headView updateContentWithData:announcement];
    
////    NSUInteger uiAttachCount = [announcement.attachments count];
//    if (uiAttachCount > 0) {
//        _m_attachemntLabel.hidden = NO;
//        _m_AttachmentView.hidden = NO;
//        
//        NSArray *arrAttIDs = [announcement.attachments valueForKeyPath:@"id"];
//        
//        ICRDatabaseFetchBlock fetchBlk = ^FMResultSet *(FMDatabase *db) {
//            NSString * sql = [NSString stringWithFormat:@"SELECT * FROM %@ WHERE %@ IN %@ ORDER BY %@", [ICRAttachment TableName], @"id", [IBTModel ValuePlaceholdersWithCount:uiAttachCount] , @"id"];
//            return [db executeQuery:sql withArgumentsInArray:arrAttIDs];
//        };
    
//        __weak typeof(self)weakSelf = self;
//        ICRDatabaseFetchResultsBlock fetchResultsBlk = ^(NSArray *fetchedObjects) {
//            __strong __typeof(weakSelf)strongSelf = weakSelf;
//            strongSelf.m_arrData = fetchedObjects;
//            [strongSelf layoutSubviews];
//            [strongSelf.m_tableView reloadData];
//        };
//        
//        ICRDataBaseController *dbCtrl = [ICRDataBaseController sharedController];
//        [dbCtrl runFetchForClass:[ICRAttachment class]
//                      fetchBlock:fetchBlk
//               fetchResultsBlock:fetchResultsBlk];
//    }
//    else {
//        _m_attachemntLabel.hidden = YES;
//        _m_AttachmentView.hidden = YES;
//    }
}
@end
