//
//  NSData+EncodeAdditions.h
//  XFFruit
//
//  Created by Xummer on 15/4/13.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import <Foundation/Foundation.h>

void *NewBase64Decode(
                      const char *inputBuffer,
                      size_t length,
                      size_t *outputLength);

char *NewBase64Encode(
                      const void *inputBuffer,
                      size_t length,
                      bool separateLines,
                      size_t *outputLength);

@interface NSData (EncodeAdditions)

- (NSData *)md5Digest;
- (NSData *)sha1Digest;
- (NSString *)hexStringValue;
+ (NSData *)dataFromBase64String:(NSString *)aString;
- (NSString *)base64EncodedString;
- (NSData *)AES256EncryptWithKey:(NSString *)key;
- (NSData *)AES256DecryptWithKey:(NSString *)key;

@end

@interface NSData (FileExt)

- (BOOL)isImageType;

@end
