//
//  FooterCell.m
//  XFFruit
//
//  Created by n22 on 15/8/19.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "FooterCell.h"
#define HeadWidth 70
#define LeftMargin 13
@interface FooterCell ()
@property (nonatomic,strong)NSString *title;
@property (nonatomic,strong)UILabel *lineLabel;

@end
@implementation FooterCell
- (instancetype)initWithFrame:(CGRect)frame withTitle:(NSString *)title{
    self = [super initWithFrame:frame];
    if (self) {
        self.title = title;
        [self bulidLayout];
    }
    return self;
}
- (void)bulidLayout{
    
    UIButton *addBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    addBtn.frame = CGRectMake(0, 0, self.frame.size.width, 50);
    [addBtn setTitle:self.title forState:UIControlStateNormal];
    addBtn.backgroundColor = [UIColor whiteColor];
    [addBtn setTitleColor:GXF_PLACEHOLDER_COLOR forState:UIControlStateNormal];
    [addBtn addTarget:self action:@selector(addBtn) forControlEvents:UIControlEventTouchUpInside];
     addBtn.titleLabel.font = GXF_FIFTEENTEN_SIZE;
    [self addSubview:addBtn];
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, self.frame.size.height-1, ScreenSize.width - LeftMargin * 2, 1))];
    self.lineLabel.backgroundColor = GXF_LINE_COLOR;
    self.lineLabel.font = GXF_FIFTEENTEN_SIZE;
    [self addSubview:self.lineLabel];
}

- (void)addBtn{
    if ([self.delegate respondsToSelector:@selector(addClick)]) {
        [self.delegate addClick];
    }
}


@end
