//
//  ICRStoreDetailViewController.m
//  XFFruit
//
//  Created by Xummer on 4/11/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "ICRStoreDetailViewController.h"

#import "ICRStore.h"

@interface ICRStoreDetailViewController ()

@property (strong, nonatomic) ICRStore *m_store;
@property (strong, nonatomic) IBTTableViewInfo *m_tableViewInfo;
@property (strong, nonatomic) UIImageView *m_tableHeadView;

@end

@implementation ICRStoreDetailViewController

#pragma mark - Life Cycle
- (instancetype)initWithStoreData:(id)store {
    self = [super init];
    if (!self) {
        return nil;
    }
    
    if ([store isKindOfClass:[ICRStore class]]) {
        self.m_store = store;
    }
    
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self setupSubviews];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private Method
- (void)setupSubviews {
    self.m_tableViewInfo = [[IBTTableViewInfo alloc] initWithFrame:self.view.bounds style:UITableViewStyleGrouped];
    
    IBTTableView *tableV = [_m_tableViewInfo getTableView];
    [self.view addSubview:tableV];
    
    UIView *headView = [[UIView alloc] initWithFrame:(CGRect){
        .origin.x = 0,
        .origin.y = 0,
        .size.width = self.view.width,
        .size.height = 160
    }];
    headView.backgroundColor = [UIColor clearColor];
    
    self.m_tableHeadView = [[UIImageView alloc] init];
    _m_tableHeadView.frame = (CGRect){
        .origin.x = 0,
        .origin.y = 0,
        .size.width = headView.width,
        .size.height = headView.height
    };
    _m_tableHeadView.layer.masksToBounds = YES;
    _m_tableHeadView.layer.cornerRadius = 5;
    [headView addSubview:_m_tableHeadView];
    
    tableV.tableHeaderView = headView;
    
    IBTTableViewSectionInfo *sec0Info = [IBTTableViewSectionInfo sectionInfoDefaut];
    
    /*"Store Name:"                            = "店名:";
     "Store Code:"                            = "代码:";
     "Store Adress:"                          = "地址:";
     "Trading Area:"                          = "商圈:";
     "Level:"                                 = "级别:";
     "Operating Hours:"                       = "营业时间:";
     "Store Manager:"                         = "店长:";
     "Phone Number:"                          = "电话:";
     "Fax:"                                   = "传真:";
     "Operating Staff:"                       = "营业人员:";*/
    NSArray *arrTextLabelTitle = @[ [IBTCommon localizableString:@"Store Name:"],
                                    [IBTCommon localizableString:@"Store Code:"],
                                    [IBTCommon localizableString:@"Store Adress:"]];
//                                    [IBTCommon localizableString:@"Trading Area:"],
//                                    [IBTCommon localizableString:@"Level:"],
//                                    [IBTCommon localizableString:@"Operating Hours:"],
//                                    [IBTCommon localizableString:@"Store Manager:"],
//                                    [IBTCommon localizableString:@"Phone Number:"],
//                                    [IBTCommon localizableString:@"Fax:"],
//                                    [IBTCommon localizableString:@"Operating Staff:"], ];
    
    NSArray *arrCellRightValues = @[ _m_store.name,
                                     _m_store.code,
                                     _m_store.address==nil?@" ":_m_store.address
//                                     _m_store.zone,
//                                     _m_store.level,
//                                     [_m_store.businesshourfrom stringByAppendingFormat:@"~%@",_m_store.businesshourto],
//                                     _m_store.shopowner,
//                                     _m_store.phone,
//                                     _m_store.fax,
//                                     _m_store.salesman
                                     ];
    
    int i = 0;
    for (NSString *strLabelTitle in arrTextLabelTitle) {
        IBTTableViewCellInfo *phoneCellInfo =
        [IBTTableViewCellInfo normalCellForSel:nil target:nil
                                         title:strLabelTitle
                                    rightValue:[arrCellRightValues objectAtIndex:i]
                                 accessoryType:UITableViewCellAccessoryNone];
        phoneCellInfo.selectionStyle = UITableViewCellSelectionStyleNone;
        
        [sec0Info addCell:phoneCellInfo];
        i ++;
    }
    
    [_m_tableViewInfo addSection:sec0Info];
}
@end
