//
//  NewPurchaseViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/21.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "NewPurchaseViewController.h"
#import "TopPurchaseView.h"
#import "ProductBillViewController.h"
#import "AddProductViewController.h"
#import "PurchaseBillProduct.h"
#import "PurchaseViewController.h"
#define TopHeight 328
#define BottomHeight 300
#define SpaceHeight 20
#define BottomViewHeight 60
typedef enum : NSUInteger {
    SaveTag = 8000,
    CommitTag,
} BtnTag;

@interface NewPurchaseViewController ()<TopPurchaseViewDelegate>
{
    UIScrollView *_scrollView;
    TopPurchaseView *_purchaseView;
    UIView *_bottomView;
    ProductBillViewController *_pvc ;
    id uuidObject;
    id billNumberObject;
    NSNumber *versionObject;
}
@property (nonatomic,strong)NSString *state;

@end

@implementation NewPurchaseViewController

- (instancetype)init{
    self = [super init];
    if (self) {
        //监听值的改变
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(setProductTotalPrice:) name:SetProductTotalPrice object:nil];
    }
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    //布局
    [self bulidLayout];
    //数据默认值
    uuidObject = [NSNull null];
    billNumberObject = [NSNull null];
    versionObject = [NSNumber numberWithInteger:0];
}


#pragma mark - 布局
- (void)bulidLayout
{
    self.view.backgroundColor  = XXFBgColor;
    _scrollView = [[UIScrollView alloc]initWithFrame:CGRectMake(0,0, ScreenSize.width, ScreenSize.height- 64 - BottomViewHeight )];
    _scrollView.showsHorizontalScrollIndicator  = NO;
    _scrollView.showsVerticalScrollIndicator = NO;
    _scrollView.contentSize = CGSizeMake(ScreenSize.width, TopHeight+ BottomHeight + SpaceHeight*2);
    [self.view addSubview:_scrollView];
    
    
    UIView *footView = [[UIView alloc]initWithFrame:CGRectMake(0, ScreenSize.height - BottomViewHeight - 64, ScreenSize.width, BottomViewHeight)];
    UIButton *saveBtn =  [IBTCustomButtom creatButtonWithFrame:CGRectMake(15, 8, (ScreenSize.width - 15*3)/2, 44) target:self sel:@selector(btnClick:) tag:SaveTag image:nil title:@"保存" titleColor: [UIColor whiteColor] isCorner:YES corner:5 bgColor:GXF_SAVE_COLOR];
    [footView addSubview:saveBtn];
    
    UIButton *commitBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(CGRectGetMaxX(saveBtn.frame) + 15, 8, (ScreenSize.width - 15*3)/2, 44) target:self sel:@selector(btnClick:) tag:CommitTag image:nil title:@"提交" titleColor: [UIColor whiteColor] isCorner:YES corner:5 bgColor:GXF_COMMIT_COLOR];
    [footView addSubview:commitBtn];
    
    [self.view addSubview:footView];

    _purchaseView = [[TopPurchaseView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, TopHeight)];
    _purchaseView.delegate = self;
    [_scrollView addSubview:_purchaseView];
    
    _bottomView = [[UIView alloc]initWithFrame:CGRectMake(0, CGRectGetMaxY(_purchaseView.frame) + 20, ScreenSize.width,BottomHeight)];
    _bottomView.backgroundColor = [UIColor whiteColor];
    [_scrollView addSubview:_bottomView];
    
    _pvc = [[ProductBillViewController alloc]init];
    _pvc.viewFrame = _bottomView.bounds;
    [_bottomView addSubview:_pvc.view];
    
}

- (void)setProductTotalPrice:(NSNotification *)fication{
    //计算总金额
    //其他费用 + 商品总金额
    float otherPrice = [_purchaseView.otherPriceFiled.text floatValue];
    NSMutableArray *purchaseProduct = _pvc.productArr;
    float totalPrice = 0;
    for (PurchaseBillProduct *billProduct in purchaseProduct) {
        totalPrice += [billProduct.total floatValue];
    }
    _purchaseView.purchasePriceLabel.text = [NSString stringWithFormat:@"%.2f",totalPrice + otherPrice];
    _purchaseView.chargePurchase = [NSNumber numberWithFloat:otherPrice];
    _purchaseView.total = [NSNumber numberWithFloat:totalPrice+otherPrice];
}

- (void)btnClick:(UIButton *)btn{
    switch (btn.tag) {
        case SaveTag:
        {
            if ([self checkPurchase]) {
                [self getDataFromServer:PURCHASE_STATE_INITIAL msg:@"正在保存..."];
            }
        }
            break;
        case CommitTag:{
            if ([self checkPurchase]) {
                [self getDataFromServer:PURCHASE_STATE_SUBMITTED msg:@"正在提交..."];
 
            }
        }
            break;
        default:
            break;
    }
}

- (void)getDataFromServer:(NSString *)state msg:(NSString *)msg{
    //保存
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message = data[@"message"];
            if (success == 1) {
                //成功
                if ([state isEqualToString:PURCHASE_STATE_INITIAL]) {//保存成功
                    NSString *uuidS = data[@"data"][@"uuid"];
                    NSString *billNumberS = data[@"data"][@"billNumber"];
                    NSNumber *versionN = data[@"data"][@"version"];
                    uuidObject = uuidS;
                    billNumberObject = billNumberS;
                    versionObject = versionN;
                    [IBTLoadingView showTips:[NSString stringWithFormat:@"当前单据%@已保存成功",billNumberS]];
                }else{//提交成功
                    PurchaseViewController *svc = [PurchaseViewController new];
                    [self PushViewController:svc animated:YES];
                }
            }else{
                [IBTLoadingView showTips:message];
            }
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    
    if(self.purchaseBill.uuid.length > 0 && uuidObject == [NSNull null]){
        uuidObject = self.purchaseBill.uuid;
    }
    if (self.purchaseBill.billNumber > 0 && billNumberObject == [NSNull null]) {
        billNumberObject = self.purchaseBill.billNumber;
    }
    if (self.purchaseBill && [versionObject integerValue] == 0) {
        versionObject = self.purchaseBill.version;
    }
    NSMutableArray *billProducts = [NSMutableArray array];
    for (PurchaseBillProduct *billProduct in _pvc.productArr) {
        [billProducts  addObject:[billProduct dictForCommit]];
    }
    
    NSDictionary *dict = @{@"uuid":uuidObject,
                           @"version":versionObject,
                           @"billnumber":billNumberObject,
                           @"state":state,
                           @"type":[IBTCommon checkString:_purchaseView.type],
                           @"noticeUuid":[IBTCommon checkString:_purchaseView.noticeUuid],
                           @"noticeNumber":[IBTCommon checkString:_purchaseView.noticeNumber],
                           @"vendor_uuid":[IBTCommon checkString:_purchaseView.vendor_uuid],
                           @"vendor_code":[IBTCommon checkString:_purchaseView.vendor_code],
                           @"vendor_name":[IBTCommon checkString:_purchaseView.vendor_name],
                           @"receiveWrh_uuid":[IBTCommon checkString:_purchaseView.receiveWrh_uuid],
                           @"receiveWrh_code":[IBTCommon checkString:_purchaseView.receiveWrh_code],
                           @"receiveWrh_name":[IBTCommon checkString:_purchaseView.receiveWrh_name],
                           @"total":_purchaseView.total,
                           @"charge":_purchaseView.chargePurchase,
                           @"remark":_purchaseView.remark,
                           @"products":billProducts};
    [IBTLoadingView showProgressLabel:msg];
    [[ICRHTTPController sharedController] savePurchaseWithData:dict success:succ failure:fail];
}
#pragma mark - checkNull
- (BOOL)checkPurchase{
    _purchaseView.remark = _purchaseView.remarkTextView.text;
    if (_purchaseView.type.length == 0 ) {
        ShowMessage(@"采购类型不能为空");
        return NO;
    }
    if (_purchaseView.vendor_uuid.length == 0 ) {
        ShowMessage(@"供应商不能为空");
        return NO;
    }
    if (_purchaseView.receiveWrh_uuid.length == 0 ) {
        ShowMessage(@"收货仓库不能为空");
        return NO;
    }
    if (_pvc.productArr.count == 0) {
        ShowMessage(@"采购商品不能为空");
        return NO;
    }
    if ([_purchaseView.total floatValue] < 0 || !_purchaseView.total) {
        ShowMessage(@"金额不能为空");
        return NO;
    }
    return YES;
}


#pragma mark - TopPurchaseViewDelegate

- (void)pushNextViewController:(id)vc{
    [self PushViewController:vc animated:YES];
}


#pragma mark - 协议方法
- (void)hiddenKeyBoard{
    [self keyboardHidden];
}
- (void)keyboardHidden{
    [_purchaseView.otherPriceFiled resignFirstResponder];
    [_purchaseView.remarkTextView resignFirstResponder];
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
